/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.internal.R;

@Deprecated
public class PreferenceFrameLayout
extends FrameLayout {
    private static final int DEFAULT_BORDER_TOP = 0;
    private static final int DEFAULT_BORDER_BOTTOM = 0;
    private static final int DEFAULT_BORDER_LEFT = 0;
    private static final int DEFAULT_BORDER_RIGHT = 0;
    private final int mBorderTop;
    private final int mBorderBottom;
    private final int mBorderLeft;
    private final int mBorderRight;
    private boolean mPaddingApplied;

    public PreferenceFrameLayout(Context context) {
        this(context, null);
    }

    public PreferenceFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 17957045);
    }

    public PreferenceFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public PreferenceFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PreferenceFrameLayout, defStyleAttr, defStyleRes);
        float density = context.getResources().getDisplayMetrics().density;
        int defaultBorderTop = (int)(density * 0.0f + 0.5f);
        int defaultBottomPadding = (int)(density * 0.0f + 0.5f);
        int defaultLeftPadding = (int)(density * 0.0f + 0.5f);
        int defaultRightPadding = (int)(density * 0.0f + 0.5f);
        this.mBorderTop = a.getDimensionPixelSize(3, defaultBorderTop);
        this.mBorderBottom = a.getDimensionPixelSize(0, defaultBottomPadding);
        this.mBorderLeft = a.getDimensionPixelSize(1, defaultLeftPadding);
        this.mBorderRight = a.getDimensionPixelSize(2, defaultRightPadding);
        a.recycle();
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    public void addView(View child) {
        LayoutParams layoutParams;
        int borderTop = this.getPaddingTop();
        int borderBottom = this.getPaddingBottom();
        int borderLeft = this.getPaddingLeft();
        int borderRight = this.getPaddingRight();
        ViewGroup.LayoutParams params = child.getLayoutParams();
        LayoutParams layoutParams2 = layoutParams = params instanceof LayoutParams ? (LayoutParams)child.getLayoutParams() : null;
        if (layoutParams != null && layoutParams.removeBorders) {
            if (this.mPaddingApplied) {
                borderTop -= this.mBorderTop;
                borderBottom -= this.mBorderBottom;
                borderLeft -= this.mBorderLeft;
                borderRight -= this.mBorderRight;
                this.mPaddingApplied = false;
            }
        } else if (!this.mPaddingApplied) {
            borderTop += this.mBorderTop;
            borderBottom += this.mBorderBottom;
            borderLeft += this.mBorderLeft;
            borderRight += this.mBorderRight;
            this.mPaddingApplied = true;
        }
        int previousTop = this.getPaddingTop();
        int previousBottom = this.getPaddingBottom();
        int previousLeft = this.getPaddingLeft();
        int previousRight = this.getPaddingRight();
        if (previousTop != borderTop || previousBottom != borderBottom || previousLeft != borderLeft || previousRight != borderRight) {
            this.setPadding(borderLeft, borderTop, borderRight, borderBottom);
        }
        super.addView(child);
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public boolean removeBorders = false;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.PreferenceFrameLayout_Layout);
            this.removeBorders = a.getBoolean(0, false);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }
    }
}

