/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.os.IBinder;
import android.os.ServiceManager;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class StatsServiceManager {
    public ServiceRegisterer getStatsCompanionServiceRegisterer() {
        return new ServiceRegisterer("statscompanion");
    }

    public ServiceRegisterer getStatsManagerServiceRegisterer() {
        return new ServiceRegisterer("statsmanager");
    }

    public ServiceRegisterer getStatsdServiceRegisterer() {
        return new ServiceRegisterer("stats");
    }

    public static class ServiceNotFoundException
    extends ServiceManager.ServiceNotFoundException {
        public ServiceNotFoundException(String name) {
            super(name);
        }
    }

    public static class ServiceRegisterer {
        private final String mServiceName;

        public ServiceRegisterer(String serviceName) {
            this.mServiceName = serviceName;
        }

        public IBinder get() {
            return ServiceManager.getService(this.mServiceName);
        }

        public IBinder getOrThrow() throws ServiceNotFoundException {
            try {
                return ServiceManager.getServiceOrThrow(this.mServiceName);
            }
            catch (ServiceManager.ServiceNotFoundException e) {
                throw new ServiceNotFoundException(this.mServiceName);
            }
        }

        private IBinder tryGet() {
            return ServiceManager.checkService(this.mServiceName);
        }
    }
}

