/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.text.TextUtils;
import android.util.Log;

public class MediaRouter2Utils {
    static final String TAG = "MR2Utils";
    static final String SEPARATOR = ":";

    public static String toUniqueId(String providerId, String id2) {
        if (TextUtils.isEmpty(providerId)) {
            Log.w(TAG, "toUniqueId: providerId shouldn't be empty");
            return null;
        }
        if (TextUtils.isEmpty(id2)) {
            Log.w(TAG, "toUniqueId: id shouldn't be null");
            return null;
        }
        return providerId + SEPARATOR + id2;
    }

    public static String getProviderId(String uniqueId) {
        if (TextUtils.isEmpty(uniqueId)) {
            Log.w(TAG, "getProviderId: uniqueId shouldn't be empty");
            return null;
        }
        int firstIndexOfSeparator = uniqueId.indexOf(SEPARATOR);
        if (firstIndexOfSeparator == -1) {
            return null;
        }
        String providerId = uniqueId.substring(0, firstIndexOfSeparator);
        if (TextUtils.isEmpty(providerId)) {
            return null;
        }
        return providerId;
    }

    public static String getOriginalId(String uniqueId) {
        if (TextUtils.isEmpty(uniqueId)) {
            Log.w(TAG, "getOriginalId: uniqueId shouldn't be empty");
            return null;
        }
        int firstIndexOfSeparator = uniqueId.indexOf(SEPARATOR);
        if (firstIndexOfSeparator == -1 || firstIndexOfSeparator + 1 >= uniqueId.length()) {
            return null;
        }
        String providerId = uniqueId.substring(firstIndexOfSeparator + 1);
        if (TextUtils.isEmpty(providerId)) {
            return null;
        }
        return providerId;
    }
}

