/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IMediaRouter2;
import android.media.IMediaRouter2Manager;
import android.media.IMediaRouterClient;
import android.media.MediaRoute2Info;
import android.media.MediaRouterClientState;
import android.media.RouteDiscoveryPreference;
import android.media.RoutingSessionInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IMediaRouterService
extends IInterface {
    public void registerClientAsUser(IMediaRouterClient var1, String var2, int var3) throws RemoteException;

    public void unregisterClient(IMediaRouterClient var1) throws RemoteException;

    public void registerClientGroupId(IMediaRouterClient var1, String var2) throws RemoteException;

    public MediaRouterClientState getState(IMediaRouterClient var1) throws RemoteException;

    public boolean isPlaybackActive(IMediaRouterClient var1) throws RemoteException;

    public void setDiscoveryRequest(IMediaRouterClient var1, int var2, boolean var3) throws RemoteException;

    public void setSelectedRoute(IMediaRouterClient var1, String var2, boolean var3) throws RemoteException;

    public void requestSetVolume(IMediaRouterClient var1, String var2, int var3) throws RemoteException;

    public void requestUpdateVolume(IMediaRouterClient var1, String var2, int var3) throws RemoteException;

    public List<MediaRoute2Info> getSystemRoutes() throws RemoteException;

    public RoutingSessionInfo getSystemSessionInfo() throws RemoteException;

    public void registerRouter2(IMediaRouter2 var1, String var2) throws RemoteException;

    public void unregisterRouter2(IMediaRouter2 var1) throws RemoteException;

    public void setDiscoveryRequestWithRouter2(IMediaRouter2 var1, RouteDiscoveryPreference var2) throws RemoteException;

    public void setRouteVolumeWithRouter2(IMediaRouter2 var1, MediaRoute2Info var2, int var3) throws RemoteException;

    public void requestCreateSessionWithRouter2(IMediaRouter2 var1, int var2, long var3, RoutingSessionInfo var5, MediaRoute2Info var6, Bundle var7) throws RemoteException;

    public void selectRouteWithRouter2(IMediaRouter2 var1, String var2, MediaRoute2Info var3) throws RemoteException;

    public void deselectRouteWithRouter2(IMediaRouter2 var1, String var2, MediaRoute2Info var3) throws RemoteException;

    public void transferToRouteWithRouter2(IMediaRouter2 var1, String var2, MediaRoute2Info var3) throws RemoteException;

    public void setSessionVolumeWithRouter2(IMediaRouter2 var1, String var2, int var3) throws RemoteException;

    public void releaseSessionWithRouter2(IMediaRouter2 var1, String var2) throws RemoteException;

    public List<RoutingSessionInfo> getActiveSessions(IMediaRouter2Manager var1) throws RemoteException;

    public void registerManager(IMediaRouter2Manager var1, String var2) throws RemoteException;

    public void unregisterManager(IMediaRouter2Manager var1) throws RemoteException;

    public void setRouteVolumeWithManager(IMediaRouter2Manager var1, int var2, MediaRoute2Info var3, int var4) throws RemoteException;

    public void requestCreateSessionWithManager(IMediaRouter2Manager var1, int var2, RoutingSessionInfo var3, MediaRoute2Info var4) throws RemoteException;

    public void selectRouteWithManager(IMediaRouter2Manager var1, int var2, String var3, MediaRoute2Info var4) throws RemoteException;

    public void deselectRouteWithManager(IMediaRouter2Manager var1, int var2, String var3, MediaRoute2Info var4) throws RemoteException;

    public void transferToRouteWithManager(IMediaRouter2Manager var1, int var2, String var3, MediaRoute2Info var4) throws RemoteException;

    public void setSessionVolumeWithManager(IMediaRouter2Manager var1, int var2, String var3, int var4) throws RemoteException;

    public void releaseSessionWithManager(IMediaRouter2Manager var1, int var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaRouterService {
        private static final String DESCRIPTOR = "android.media.IMediaRouterService";
        static final int TRANSACTION_registerClientAsUser = 1;
        static final int TRANSACTION_unregisterClient = 2;
        static final int TRANSACTION_registerClientGroupId = 3;
        static final int TRANSACTION_getState = 4;
        static final int TRANSACTION_isPlaybackActive = 5;
        static final int TRANSACTION_setDiscoveryRequest = 6;
        static final int TRANSACTION_setSelectedRoute = 7;
        static final int TRANSACTION_requestSetVolume = 8;
        static final int TRANSACTION_requestUpdateVolume = 9;
        static final int TRANSACTION_getSystemRoutes = 10;
        static final int TRANSACTION_getSystemSessionInfo = 11;
        static final int TRANSACTION_registerRouter2 = 12;
        static final int TRANSACTION_unregisterRouter2 = 13;
        static final int TRANSACTION_setDiscoveryRequestWithRouter2 = 14;
        static final int TRANSACTION_setRouteVolumeWithRouter2 = 15;
        static final int TRANSACTION_requestCreateSessionWithRouter2 = 16;
        static final int TRANSACTION_selectRouteWithRouter2 = 17;
        static final int TRANSACTION_deselectRouteWithRouter2 = 18;
        static final int TRANSACTION_transferToRouteWithRouter2 = 19;
        static final int TRANSACTION_setSessionVolumeWithRouter2 = 20;
        static final int TRANSACTION_releaseSessionWithRouter2 = 21;
        static final int TRANSACTION_getActiveSessions = 22;
        static final int TRANSACTION_registerManager = 23;
        static final int TRANSACTION_unregisterManager = 24;
        static final int TRANSACTION_setRouteVolumeWithManager = 25;
        static final int TRANSACTION_requestCreateSessionWithManager = 26;
        static final int TRANSACTION_selectRouteWithManager = 27;
        static final int TRANSACTION_deselectRouteWithManager = 28;
        static final int TRANSACTION_transferToRouteWithManager = 29;
        static final int TRANSACTION_setSessionVolumeWithManager = 30;
        static final int TRANSACTION_releaseSessionWithManager = 31;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaRouterService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaRouterService) {
                return (IMediaRouterService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerClientAsUser";
                }
                case 2: {
                    return "unregisterClient";
                }
                case 3: {
                    return "registerClientGroupId";
                }
                case 4: {
                    return "getState";
                }
                case 5: {
                    return "isPlaybackActive";
                }
                case 6: {
                    return "setDiscoveryRequest";
                }
                case 7: {
                    return "setSelectedRoute";
                }
                case 8: {
                    return "requestSetVolume";
                }
                case 9: {
                    return "requestUpdateVolume";
                }
                case 10: {
                    return "getSystemRoutes";
                }
                case 11: {
                    return "getSystemSessionInfo";
                }
                case 12: {
                    return "registerRouter2";
                }
                case 13: {
                    return "unregisterRouter2";
                }
                case 14: {
                    return "setDiscoveryRequestWithRouter2";
                }
                case 15: {
                    return "setRouteVolumeWithRouter2";
                }
                case 16: {
                    return "requestCreateSessionWithRouter2";
                }
                case 17: {
                    return "selectRouteWithRouter2";
                }
                case 18: {
                    return "deselectRouteWithRouter2";
                }
                case 19: {
                    return "transferToRouteWithRouter2";
                }
                case 20: {
                    return "setSessionVolumeWithRouter2";
                }
                case 21: {
                    return "releaseSessionWithRouter2";
                }
                case 22: {
                    return "getActiveSessions";
                }
                case 23: {
                    return "registerManager";
                }
                case 24: {
                    return "unregisterManager";
                }
                case 25: {
                    return "setRouteVolumeWithManager";
                }
                case 26: {
                    return "requestCreateSessionWithManager";
                }
                case 27: {
                    return "selectRouteWithManager";
                }
                case 28: {
                    return "deselectRouteWithManager";
                }
                case 29: {
                    return "transferToRouteWithManager";
                }
                case 30: {
                    return "setSessionVolumeWithManager";
                }
                case 31: {
                    return "releaseSessionWithManager";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.registerClientAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    this.unregisterClient(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.registerClientGroupId(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    MediaRouterClientState _result = this.getState(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.isPlaybackActive(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.setDiscoveryRequest(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    this.setSelectedRoute(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.requestSetVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    IMediaRouterClient _arg0 = IMediaRouterClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.requestUpdateVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    List<MediaRoute2Info> _result = this.getSystemRoutes();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    RoutingSessionInfo _result = this.getSystemSessionInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.registerRouter2(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    this.unregisterRouter2(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    RouteDiscoveryPreference _arg1 = 0 != data.readInt() ? RouteDiscoveryPreference.CREATOR.createFromParcel(data) : null;
                    this.setDiscoveryRequestWithRouter2(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    MediaRoute2Info _arg1 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.setRouteVolumeWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    long _arg2 = data.readLong();
                    RoutingSessionInfo _arg3 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    MediaRoute2Info _arg4 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    Bundle _arg5 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.requestCreateSessionWithRouter2(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    MediaRoute2Info _arg2 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    this.selectRouteWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    MediaRoute2Info _arg2 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    this.deselectRouteWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    MediaRoute2Info _arg2 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    this.transferToRouteWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.setSessionVolumeWithRouter2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2 _arg0 = IMediaRouter2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.releaseSessionWithRouter2(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    List<RoutingSessionInfo> _result = this.getActiveSessions(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.registerManager(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    this.unregisterManager(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    MediaRoute2Info _arg2 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.setRouteVolumeWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    RoutingSessionInfo _arg2 = 0 != data.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(data) : null;
                    MediaRoute2Info _arg3 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    this.requestCreateSessionWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    MediaRoute2Info _arg3 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    this.selectRouteWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    MediaRoute2Info _arg3 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    this.deselectRouteWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    MediaRoute2Info _arg3 = 0 != data.readInt() ? MediaRoute2Info.CREATOR.createFromParcel(data) : null;
                    this.transferToRouteWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    this.setSessionVolumeWithManager(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    IMediaRouter2Manager _arg0 = IMediaRouter2Manager.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    this.releaseSessionWithManager(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IMediaRouterService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IMediaRouterService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IMediaRouterService {
            private IBinder mRemote;
            public static IMediaRouterService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClientAsUser(IMediaRouterClient client, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerClientAsUser(client, packageName, userId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterClient(IMediaRouterClient client) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterClient(client);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClientGroupId(IMediaRouterClient client, String groupId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    _data.writeString(groupId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerClientGroupId(client, groupId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaRouterClientState getState(IMediaRouterClient client) throws RemoteException {
                MediaRouterClientState _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        MediaRouterClientState mediaRouterClientState = Stub.getDefaultImpl().getState(client);
                        return mediaRouterClientState;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? MediaRouterClientState.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPlaybackActive(IMediaRouterClient client) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isPlaybackActive(client);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDiscoveryRequest(IMediaRouterClient client, int routeTypes, boolean activeScan) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    _data.writeInt(routeTypes);
                    _data.writeInt(activeScan ? 1 : 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDiscoveryRequest(client, routeTypes, activeScan);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSelectedRoute(IMediaRouterClient client, String routeId, boolean explicit) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    _data.writeString(routeId);
                    _data.writeInt(explicit ? 1 : 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSelectedRoute(client, routeId, explicit);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestSetVolume(IMediaRouterClient client, String routeId, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    _data.writeString(routeId);
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestSetVolume(client, routeId, volume);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestUpdateVolume(IMediaRouterClient client, String routeId, int direction) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    _data.writeString(routeId);
                    _data.writeInt(direction);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestUpdateVolume(client, routeId, direction);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<MediaRoute2Info> getSystemRoutes() throws RemoteException {
                ArrayList<MediaRoute2Info> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<MediaRoute2Info> list = Stub.getDefaultImpl().getSystemRoutes();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(MediaRoute2Info.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RoutingSessionInfo getSystemSessionInfo() throws RemoteException {
                RoutingSessionInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        RoutingSessionInfo routingSessionInfo = Stub.getDefaultImpl().getSystemSessionInfo();
                        return routingSessionInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? RoutingSessionInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRouter2(IMediaRouter2 router, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerRouter2(router, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRouter2(IMediaRouter2 router) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterRouter2(router);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDiscoveryRequestWithRouter2(IMediaRouter2 router, RouteDiscoveryPreference preference) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    if (preference != null) {
                        _data.writeInt(1);
                        preference.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDiscoveryRequestWithRouter2(router, preference);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRouteVolumeWithRouter2(IMediaRouter2 router, MediaRoute2Info route, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRouteVolumeWithRouter2(router, route, volume);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCreateSessionWithRouter2(IMediaRouter2 router, int requestId, long managerRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route, Bundle sessionHints) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    _data.writeInt(requestId);
                    _data.writeLong(managerRequestId);
                    if (oldSession != null) {
                        _data.writeInt(1);
                        oldSession.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (sessionHints != null) {
                        _data.writeInt(1);
                        sessionHints.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestCreateSessionWithRouter2(router, requestId, managerRequestId, oldSession, route, sessionHints);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    _data.writeString(sessionId);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().selectRouteWithRouter2(router, sessionId, route);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deselectRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    _data.writeString(sessionId);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deselectRouteWithRouter2(router, sessionId, route);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transferToRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    _data.writeString(sessionId);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().transferToRouteWithRouter2(router, sessionId, route);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionVolumeWithRouter2(IMediaRouter2 router, String sessionId, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    _data.writeString(sessionId);
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSessionVolumeWithRouter2(router, sessionId, volume);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSessionWithRouter2(IMediaRouter2 router, String sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(router != null ? router.asBinder() : null);
                    _data.writeString(sessionId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseSessionWithRouter2(router, sessionId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<RoutingSessionInfo> getActiveSessions(IMediaRouter2Manager manager) throws RemoteException {
                ArrayList<RoutingSessionInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<RoutingSessionInfo> list = Stub.getDefaultImpl().getActiveSessions(manager);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(RoutingSessionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerManager(IMediaRouter2Manager manager, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerManager(manager, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterManager(IMediaRouter2Manager manager) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterManager(manager);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRouteVolumeWithManager(IMediaRouter2Manager manager, int requestId, MediaRoute2Info route, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    _data.writeInt(requestId);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setRouteVolumeWithManager(manager, requestId, route, volume);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCreateSessionWithManager(IMediaRouter2Manager manager, int requestId, RoutingSessionInfo oldSession, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    _data.writeInt(requestId);
                    if (oldSession != null) {
                        _data.writeInt(1);
                        oldSession.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestCreateSessionWithManager(manager, requestId, oldSession, route);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().selectRouteWithManager(manager, requestId, sessionId, route);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deselectRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deselectRouteWithManager(manager, requestId, sessionId, route);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transferToRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().transferToRouteWithManager(manager, requestId, sessionId, route);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionVolumeWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, int volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    _data.writeInt(volume);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSessionVolumeWithManager(manager, requestId, sessionId, volume);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseSessionWithManager(IMediaRouter2Manager manager, int requestId, String sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(manager != null ? manager.asBinder() : null);
                    _data.writeInt(requestId);
                    _data.writeString(sessionId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseSessionWithManager(manager, requestId, sessionId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaRouterService {
        @Override
        public void registerClientAsUser(IMediaRouterClient client, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void unregisterClient(IMediaRouterClient client) throws RemoteException {
        }

        @Override
        public void registerClientGroupId(IMediaRouterClient client, String groupId) throws RemoteException {
        }

        @Override
        public MediaRouterClientState getState(IMediaRouterClient client) throws RemoteException {
            return null;
        }

        @Override
        public boolean isPlaybackActive(IMediaRouterClient client) throws RemoteException {
            return false;
        }

        @Override
        public void setDiscoveryRequest(IMediaRouterClient client, int routeTypes, boolean activeScan) throws RemoteException {
        }

        @Override
        public void setSelectedRoute(IMediaRouterClient client, String routeId, boolean explicit) throws RemoteException {
        }

        @Override
        public void requestSetVolume(IMediaRouterClient client, String routeId, int volume) throws RemoteException {
        }

        @Override
        public void requestUpdateVolume(IMediaRouterClient client, String routeId, int direction) throws RemoteException {
        }

        @Override
        public List<MediaRoute2Info> getSystemRoutes() throws RemoteException {
            return null;
        }

        @Override
        public RoutingSessionInfo getSystemSessionInfo() throws RemoteException {
            return null;
        }

        @Override
        public void registerRouter2(IMediaRouter2 router, String packageName) throws RemoteException {
        }

        @Override
        public void unregisterRouter2(IMediaRouter2 router) throws RemoteException {
        }

        @Override
        public void setDiscoveryRequestWithRouter2(IMediaRouter2 router, RouteDiscoveryPreference preference) throws RemoteException {
        }

        @Override
        public void setRouteVolumeWithRouter2(IMediaRouter2 router, MediaRoute2Info route, int volume) throws RemoteException {
        }

        @Override
        public void requestCreateSessionWithRouter2(IMediaRouter2 router, int requestId, long managerRequestId, RoutingSessionInfo oldSession, MediaRoute2Info route, Bundle sessionHints) throws RemoteException {
        }

        @Override
        public void selectRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void deselectRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void transferToRouteWithRouter2(IMediaRouter2 router, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void setSessionVolumeWithRouter2(IMediaRouter2 router, String sessionId, int volume) throws RemoteException {
        }

        @Override
        public void releaseSessionWithRouter2(IMediaRouter2 router, String sessionId) throws RemoteException {
        }

        @Override
        public List<RoutingSessionInfo> getActiveSessions(IMediaRouter2Manager manager) throws RemoteException {
            return null;
        }

        @Override
        public void registerManager(IMediaRouter2Manager manager, String packageName) throws RemoteException {
        }

        @Override
        public void unregisterManager(IMediaRouter2Manager manager) throws RemoteException {
        }

        @Override
        public void setRouteVolumeWithManager(IMediaRouter2Manager manager, int requestId, MediaRoute2Info route, int volume) throws RemoteException {
        }

        @Override
        public void requestCreateSessionWithManager(IMediaRouter2Manager manager, int requestId, RoutingSessionInfo oldSession, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void selectRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void deselectRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void transferToRouteWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, MediaRoute2Info route) throws RemoteException {
        }

        @Override
        public void setSessionVolumeWithManager(IMediaRouter2Manager manager, int requestId, String sessionId, int volume) throws RemoteException {
        }

        @Override
        public void releaseSessionWithManager(IMediaRouter2Manager manager, int requestId, String sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

