/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.app.PropertyInvalidatedCache;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.location.AbstractListenerManager;
import android.location.BatchedLocationCallback;
import android.location.Criteria;
import android.location.Geofence;
import android.location.GnssAntennaInfo;
import android.location.GnssCapabilities;
import android.location.GnssMeasurementCorrections;
import android.location.GnssMeasurementsEvent;
import android.location.GnssNavigationMessage;
import android.location.GnssRequest;
import android.location.GnssStatus;
import android.location.GpsMeasurementsEvent;
import android.location.GpsNavigationMessageEvent;
import android.location.GpsStatus;
import android.location.IBatchedLocationCallback;
import android.location.IGnssAntennaInfoListener;
import android.location.IGnssMeasurementsListener;
import android.location.IGnssNavigationMessageListener;
import android.location.IGnssStatusListener;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.location.LocationRequest;
import android.location.OnNmeaMessageListener;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.location.ProviderProperties;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.internal.util.function.pooled.PooledRunnable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;

public class LocationManager {
    @GuardedBy(value={"mLock"})
    private PropertyInvalidatedCache<Integer, Boolean> mLocationEnabledCache = new PropertyInvalidatedCache<Integer, Boolean>(4, "cache_key.location_enabled"){

        @Override
        protected Boolean recompute(Integer userHandle) {
            try {
                return LocationManager.this.mService.isLocationEnabledForUser(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    };
    private final Object mLock = new Object();
    private static final long GET_PROVIDER_SECURITY_EXCEPTIONS = 150935354L;
    private static final long TARGETED_PENDING_INTENT = 148963590L;
    private static final long INCOMPLETE_LOCATION = 148964793L;
    private static final long GPS_STATUS_USAGE = 144027538L;
    public static final String NETWORK_PROVIDER = "network";
    public static final String GPS_PROVIDER = "gps";
    public static final String PASSIVE_PROVIDER = "passive";
    public static final String FUSED_PROVIDER = "fused";
    public static final String KEY_PROXIMITY_ENTERING = "entering";
    @Deprecated
    public static final String KEY_STATUS_CHANGED = "status";
    public static final String KEY_PROVIDER_ENABLED = "providerEnabled";
    public static final String KEY_LOCATION_CHANGED = "location";
    public static final String PROVIDERS_CHANGED_ACTION = "android.location.PROVIDERS_CHANGED";
    public static final String EXTRA_PROVIDER_NAME = "android.location.extra.PROVIDER_NAME";
    public static final String EXTRA_PROVIDER_ENABLED = "android.location.extra.PROVIDER_ENABLED";
    public static final String MODE_CHANGED_ACTION = "android.location.MODE_CHANGED";
    public static final String EXTRA_LOCATION_ENABLED = "android.location.extra.LOCATION_ENABLED";
    public static final String HIGH_POWER_REQUEST_CHANGE_ACTION = "android.location.HIGH_POWER_REQUEST_CHANGE";
    public static final String SETTINGS_FOOTER_DISPLAYED_ACTION = "com.android.settings.location.DISPLAYED_FOOTER";
    public static final String METADATA_SETTINGS_FOOTER_STRING = "com.android.settings.location.FOOTER_STRING";
    private static final long GET_CURRENT_LOCATION_MAX_TIMEOUT_MS = 30000L;
    private final Context mContext;
    @UnsupportedAppUsage
    private final ILocationManager mService;
    @GuardedBy(value={"mListeners"})
    private final ArrayMap<LocationListener, LocationListenerTransport> mListeners = new ArrayMap();
    @GuardedBy(value={"mBatchedLocationCallbackManager"})
    private final BatchedLocationCallbackManager mBatchedLocationCallbackManager = new BatchedLocationCallbackManager();
    private final GnssStatusListenerManager mGnssStatusListenerManager = new GnssStatusListenerManager();
    private final GnssMeasurementsListenerManager mGnssMeasurementsListenerManager = new GnssMeasurementsListenerManager();
    private final GnssNavigationMessageListenerManager mGnssNavigationMessageListenerTransport = new GnssNavigationMessageListenerManager();
    private final GnssAntennaInfoListenerManager mGnssAntennaInfoListenerManager = new GnssAntennaInfoListenerManager();
    public static final String CACHE_KEY_LOCATION_ENABLED_PROPERTY = "cache_key.location_enabled";

    public LocationManager(Context context, ILocationManager service) {
        this.mService = service;
        this.mContext = context;
    }

    public String[] getBackgroundThrottlingWhitelist() {
        try {
            return this.mService.getBackgroundThrottlingWhitelist();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String[] getIgnoreSettingsWhitelist() {
        try {
            return this.mService.getIgnoreSettingsWhitelist();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public String getExtraLocationControllerPackage() {
        try {
            return this.mService.getExtraLocationControllerPackage();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    @SystemApi
    public void setExtraLocationControllerPackage(String packageName) {
        try {
            this.mService.setExtraLocationControllerPackage(packageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setExtraLocationControllerPackageEnabled(boolean enabled) {
        try {
            this.mService.setExtraLocationControllerPackageEnabled(enabled);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean isExtraLocationControllerPackageEnabled() {
        try {
            return this.mService.isExtraLocationControllerPackageEnabled();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @Deprecated
    @SystemApi
    public void setLocationControllerExtraPackage(String packageName) {
        try {
            this.mService.setExtraLocationControllerPackage(packageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    public void setLocationControllerExtraPackageEnabled(boolean enabled) {
        try {
            this.mService.setExtraLocationControllerPackageEnabled(enabled);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean isLocationEnabled() {
        return this.isLocationEnabledForUser(Process.myUserHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public boolean isLocationEnabledForUser(UserHandle userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLocationEnabledCache != null) {
                return this.mLocationEnabledCache.query(userHandle.getIdentifier());
            }
        }
        try {
            return this.mService.isLocationEnabledForUser(userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setLocationEnabledForUser(boolean enabled, UserHandle userHandle) {
        try {
            this.mService.setLocationEnabledForUser(enabled, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isProviderEnabled(String provider) {
        return this.isProviderEnabledForUser(provider, Process.myUserHandle());
    }

    @SystemApi
    public boolean isProviderEnabledForUser(String provider, UserHandle userHandle) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        try {
            return this.mService.isProviderEnabledForUser(provider, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    public boolean setProviderEnabledForUser(String provider, boolean enabled, UserHandle userHandle) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        return Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "location_providers_allowed", (enabled ? "+" : "-") + provider, userHandle.getIdentifier());
    }

    public Location getLastLocation() {
        try {
            return this.mService.getLastLocation(null, this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Location getLastKnownLocation(String provider) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        try {
            return this.mService.getLastLocation(request, this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getCurrentLocation(String provider, CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        this.getCurrentLocation(LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true), cancellationSignal, executor, consumer);
    }

    @SystemApi
    public void getCurrentLocation(LocationRequest locationRequest, CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        LocationRequest currentLocationRequest = new LocationRequest(locationRequest).setNumUpdates(1);
        if (currentLocationRequest.getExpireIn() > 30000L) {
            currentLocationRequest.setExpireIn(30000L);
        }
        GetCurrentLocationTransport transport = new GetCurrentLocationTransport(executor, consumer);
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        ICancellationSignal remoteCancellationSignal = CancellationSignal.createTransport();
        try {
            if (this.mService.getCurrentLocation(currentLocationRequest, remoteCancellationSignal, transport, this.mContext.getPackageName(), this.mContext.getAttributionTag(), transport.getListenerId())) {
                transport.register(this.mContext.getSystemService(AlarmManager.class), remoteCancellationSignal);
                if (cancellationSignal != null) {
                    cancellationSignal.setOnCancelListener(transport::cancel);
                }
            } else {
                transport.fail();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void requestSingleUpdate(String provider, LocationListener listener, Looper looper) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(listener != null, "invalid null listener");
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        request.setExpireIn(30000L);
        this.requestLocationUpdates(request, listener, looper);
    }

    @Deprecated
    public void requestSingleUpdate(Criteria criteria, LocationListener listener, Looper looper) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        Preconditions.checkArgument(listener != null, "invalid null listener");
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, 0L, 0.0f, true);
        request.setExpireIn(30000L);
        this.requestLocationUpdates(request, listener, looper);
    }

    @Deprecated
    public void requestSingleUpdate(String provider, PendingIntent pendingIntent) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, 0L, 0.0f, true);
        request.setExpireIn(30000L);
        this.requestLocationUpdates(request, pendingIntent);
    }

    @Deprecated
    public void requestSingleUpdate(Criteria criteria, PendingIntent pendingIntent) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, 0L, 0.0f, true);
        request.setExpireIn(30000L);
        this.requestLocationUpdates(request, pendingIntent);
    }

    public void requestLocationUpdates(String provider, long minTimeMs, float minDistanceM, LocationListener listener) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(listener != null, "invalid null listener");
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTimeMs, minDistanceM, false);
        this.requestLocationUpdates(request, listener, null);
    }

    public void requestLocationUpdates(String provider, long minTimeMs, float minDistanceM, LocationListener listener, Looper looper) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(listener != null, "invalid null listener");
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTimeMs, minDistanceM, false);
        this.requestLocationUpdates(request, listener, looper);
    }

    public void requestLocationUpdates(String provider, long minTimeMs, float minDistanceM, Executor executor, LocationListener listener) {
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTimeMs, minDistanceM, false);
        this.requestLocationUpdates(request, executor, listener);
    }

    public void requestLocationUpdates(long minTimeMs, float minDistanceM, Criteria criteria, LocationListener listener, Looper looper) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        Preconditions.checkArgument(listener != null, "invalid null listener");
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, minTimeMs, minDistanceM, false);
        this.requestLocationUpdates(request, listener, looper);
    }

    public void requestLocationUpdates(long minTimeMs, float minDistanceM, Criteria criteria, Executor executor, LocationListener listener) {
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, minTimeMs, minDistanceM, false);
        this.requestLocationUpdates(request, executor, listener);
    }

    public void requestLocationUpdates(String provider, long minTimeMs, float minDistanceM, PendingIntent pendingIntent) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        LocationRequest request = LocationRequest.createFromDeprecatedProvider(provider, minTimeMs, minDistanceM, false);
        this.requestLocationUpdates(request, pendingIntent);
    }

    public void requestLocationUpdates(long minTimeMs, float minDistanceM, Criteria criteria, PendingIntent pendingIntent) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        LocationRequest request = LocationRequest.createFromDeprecatedCriteria(criteria, minTimeMs, minDistanceM, false);
        this.requestLocationUpdates(request, pendingIntent);
    }

    @SystemApi
    public void requestLocationUpdates(LocationRequest locationRequest, LocationListener listener, Looper looper) {
        Handler handler = looper == null ? new Handler() : new Handler(looper);
        this.requestLocationUpdates(locationRequest, new HandlerExecutor(handler), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void requestLocationUpdates(LocationRequest locationRequest, Executor executor, LocationListener listener) {
        ArrayMap<LocationListener, LocationListenerTransport> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            LocationListenerTransport transport = this.mListeners.get(listener);
            if (transport != null) {
                transport.unregister();
            } else {
                transport = new LocationListenerTransport(listener);
                this.mListeners.put(listener, transport);
            }
            transport.register(executor);
            boolean registered = false;
            try {
                this.mService.requestLocationUpdates(locationRequest, transport, null, this.mContext.getPackageName(), this.mContext.getAttributionTag(), transport.getListenerId());
                registered = true;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                if (!registered) {
                    transport.unregister();
                    this.mListeners.remove(listener);
                }
            }
        }
    }

    @SystemApi
    public void requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        Preconditions.checkArgument(locationRequest != null, "invalid null location request");
        Preconditions.checkArgument(pendingIntent != null, "invalid null pending intent");
        if (Compatibility.isChangeEnabled(148963590L)) {
            Preconditions.checkArgument(pendingIntent.isTargetedToPackage(), "pending intent must be targeted to a package");
        }
        try {
            this.mService.requestLocationUpdates(locationRequest, null, pendingIntent, this.mContext.getPackageName(), this.mContext.getAttributionTag(), null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean injectLocation(Location location) {
        Preconditions.checkArgument(location != null, "invalid null location");
        Preconditions.checkArgument(location.isComplete(), "incomplete location object, missing timestamp or accuracy?");
        try {
            this.mService.injectLocation(location);
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdates(LocationListener listener) {
        Preconditions.checkArgument(listener != null, "invalid null listener");
        ArrayMap<LocationListener, LocationListenerTransport> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            LocationListenerTransport transport = this.mListeners.remove(listener);
            if (transport == null) {
                return;
            }
            transport.unregister();
            try {
                this.mService.removeUpdates(transport, null);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void removeUpdates(PendingIntent pendingIntent) {
        Preconditions.checkArgument(pendingIntent != null, "invalid null pending intent");
        try {
            this.mService.removeUpdates(null, pendingIntent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getAllProviders() {
        try {
            return this.mService.getAllProviders();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getProviders(boolean enabledOnly) {
        try {
            return this.mService.getProviders(null, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getProviders(Criteria criteria, boolean enabledOnly) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        try {
            return this.mService.getProviders(criteria, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        try {
            return this.mService.getBestProvider(criteria, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public LocationProvider getProvider(String provider) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        if (!Compatibility.isChangeEnabled(150935354L)) {
            if (NETWORK_PROVIDER.equals(provider) || FUSED_PROVIDER.equals(provider)) {
                try {
                    this.mContext.enforcePermission("android.permission.ACCESS_FINE_LOCATION", Process.myPid(), Process.myUid(), null);
                }
                catch (SecurityException e) {
                    this.mContext.enforcePermission("android.permission.ACCESS_COARSE_LOCATION", Process.myPid(), Process.myUid(), null);
                }
            } else {
                this.mContext.enforcePermission("android.permission.ACCESS_FINE_LOCATION", Process.myPid(), Process.myUid(), null);
            }
        }
        try {
            ProviderProperties properties = this.mService.getProviderProperties(provider);
            if (properties == null) {
                return null;
            }
            return new LocationProvider(provider, properties);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean isProviderPackage(String packageName) {
        try {
            return this.mService.isProviderPackage(packageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public List<String> getProviderPackages(String provider) {
        try {
            return this.mService.getProviderPackages(provider);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return Collections.emptyList();
        }
    }

    public boolean sendExtraCommand(String provider, String command, Bundle extras) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(command != null, "invalid null command");
        try {
            return this.mService.sendExtraCommand(provider, command, extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addTestProvider(String provider, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        ProviderProperties properties = new ProviderProperties(requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
        try {
            this.mService.addTestProvider(provider, properties, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeTestProvider(String provider) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        try {
            this.mService.removeTestProvider(provider, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTestProviderLocation(String provider, Location location) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(location != null, "invalid null location");
        if (Compatibility.isChangeEnabled(148964793L)) {
            Preconditions.checkArgument(location.isComplete(), "incomplete location object, missing timestamp or accuracy?");
        } else {
            location.makeComplete();
        }
        try {
            this.mService.setTestProviderLocation(provider, location, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void clearTestProviderLocation(String provider) {
    }

    public void setTestProviderEnabled(String provider, boolean enabled) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        try {
            this.mService.setTestProviderEnabled(provider, enabled, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void clearTestProviderEnabled(String provider) {
        this.setTestProviderEnabled(provider, false);
    }

    @Deprecated
    public void setTestProviderStatus(String provider, int status, Bundle extras, long updateTime) {
    }

    @Deprecated
    public void clearTestProviderStatus(String provider) {
    }

    public List<LocationRequest> getTestProviderCurrentRequests(String providerName) {
        Preconditions.checkArgument(providerName != null, "invalid null provider");
        try {
            return this.mService.getTestProviderCurrentRequests(providerName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addProximityAlert(double latitude, double longitude, float radius, long expiration, PendingIntent intent) {
        Preconditions.checkArgument(intent != null, "invalid null pending intent");
        if (Compatibility.isChangeEnabled(148963590L)) {
            Preconditions.checkArgument(intent.isTargetedToPackage(), "pending intent must be targeted to a package");
        }
        if (expiration < 0L) {
            expiration = Long.MAX_VALUE;
        }
        Geofence fence = Geofence.createCircle(latitude, longitude, radius);
        LocationRequest request = new LocationRequest().setExpireIn(expiration);
        try {
            this.mService.requestGeofence(request, fence, intent, this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeProximityAlert(PendingIntent intent) {
        Preconditions.checkArgument(intent != null, "invalid null pending intent");
        if (Compatibility.isChangeEnabled(148963590L)) {
            Preconditions.checkArgument(intent.isTargetedToPackage(), "pending intent must be targeted to a package");
        }
        try {
            this.mService.removeGeofence(null, intent, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addGeofence(LocationRequest request, Geofence fence, PendingIntent intent) {
        Preconditions.checkArgument(request != null, "invalid null location request");
        Preconditions.checkArgument(fence != null, "invalid null geofence");
        Preconditions.checkArgument(intent != null, "invalid null pending intent");
        if (Compatibility.isChangeEnabled(148963590L)) {
            Preconditions.checkArgument(intent.isTargetedToPackage(), "pending intent must be targeted to a package");
        }
        try {
            this.mService.requestGeofence(request, fence, intent, this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeGeofence(Geofence fence, PendingIntent intent) {
        Preconditions.checkArgument(fence != null, "invalid null geofence");
        Preconditions.checkArgument(intent != null, "invalid null pending intent");
        if (Compatibility.isChangeEnabled(148963590L)) {
            Preconditions.checkArgument(intent.isTargetedToPackage(), "pending intent must be targeted to a package");
        }
        try {
            this.mService.removeGeofence(fence, intent, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeAllGeofences(PendingIntent intent) {
        Preconditions.checkArgument(intent != null, "invalid null pending intent");
        if (Compatibility.isChangeEnabled(148963590L)) {
            Preconditions.checkArgument(intent.isTargetedToPackage(), "pending intent must be targeted to a package");
        }
        try {
            this.mService.removeGeofence(null, intent, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public GnssCapabilities getGnssCapabilities() {
        try {
            long gnssCapabilities = this.mService.getGnssCapabilities();
            if (gnssCapabilities == -1L) {
                gnssCapabilities = 0L;
            }
            return GnssCapabilities.of(gnssCapabilities);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getGnssYearOfHardware() {
        try {
            return this.mService.getGnssYearOfHardware();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getGnssHardwareModelName() {
        try {
            return this.mService.getGnssHardwareModelName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public GpsStatus getGpsStatus(GpsStatus status) {
        if (Compatibility.isChangeEnabled(144027538L)) {
            throw new UnsupportedOperationException("GpsStatus APIs not supported, please use GnssStatus APIs instead");
        }
        GnssStatus gnssStatus = this.mGnssStatusListenerManager.getGnssStatus();
        int ttff = this.mGnssStatusListenerManager.getTtff();
        if (gnssStatus != null) {
            if (status == null) {
                status = GpsStatus.create(gnssStatus, ttff);
            } else {
                status.setStatus(gnssStatus, ttff);
            }
        } else if (status == null) {
            status = GpsStatus.createEmpty();
        }
        return status;
    }

    @Deprecated
    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        if (Compatibility.isChangeEnabled(144027538L)) {
            throw new UnsupportedOperationException("GpsStatus APIs not supported, please use GnssStatus APIs instead");
        }
        try {
            return this.mGnssStatusListenerManager.addListener(listener, (Executor)new HandlerExecutor(new Handler()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        if (Compatibility.isChangeEnabled(144027538L)) {
            throw new UnsupportedOperationException("GpsStatus APIs not supported, please use GnssStatus APIs instead");
        }
        try {
            this.mGnssStatusListenerManager.removeListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean registerGnssStatusCallback(GnssStatus.Callback callback) {
        return this.registerGnssStatusCallback(callback, null);
    }

    public boolean registerGnssStatusCallback(GnssStatus.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        try {
            return this.mGnssStatusListenerManager.addListener(callback, handler);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean registerGnssStatusCallback(Executor executor, GnssStatus.Callback callback) {
        try {
            return this.mGnssStatusListenerManager.addListener(callback, executor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterGnssStatusCallback(GnssStatus.Callback callback) {
        try {
            this.mGnssStatusListenerManager.removeListener(callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean addNmeaListener(GpsStatus.NmeaListener listener) {
        return false;
    }

    @Deprecated
    public void removeNmeaListener(GpsStatus.NmeaListener listener) {
    }

    @Deprecated
    public boolean addNmeaListener(OnNmeaMessageListener listener) {
        return this.addNmeaListener(listener, null);
    }

    public boolean addNmeaListener(OnNmeaMessageListener listener, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        try {
            return this.mGnssStatusListenerManager.addListener(listener, handler);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean addNmeaListener(Executor executor, OnNmeaMessageListener listener) {
        try {
            return this.mGnssStatusListenerManager.addListener(listener, executor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeNmeaListener(OnNmeaMessageListener listener) {
        try {
            this.mGnssStatusListenerManager.removeListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    public boolean addGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        return false;
    }

    @Deprecated
    @SystemApi
    public void removeGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
    }

    @Deprecated
    public boolean registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        return this.registerGnssMeasurementsCallback(Runnable::run, callback);
    }

    public boolean registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        try {
            return this.mGnssMeasurementsListenerManager.addListener(callback, handler);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean registerGnssMeasurementsCallback(Executor executor, GnssMeasurementsEvent.Callback callback) {
        try {
            return this.mGnssMeasurementsListenerManager.addListener(callback, executor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean registerGnssMeasurementsCallback(GnssRequest request, Executor executor, GnssMeasurementsEvent.Callback callback) {
        Preconditions.checkArgument(request != null, "invalid null request");
        try {
            return this.mGnssMeasurementsListenerManager.addListener(request, callback, executor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void injectGnssMeasurementCorrections(GnssMeasurementCorrections measurementCorrections) {
        Preconditions.checkArgument(measurementCorrections != null);
        try {
            this.mService.injectGnssMeasurementCorrections(measurementCorrections, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        try {
            this.mGnssMeasurementsListenerManager.removeListener(callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean registerAntennaInfoListener(Executor executor, GnssAntennaInfo.Listener listener) {
        try {
            return this.mGnssAntennaInfoListenerManager.addListener(listener, executor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterAntennaInfoListener(GnssAntennaInfo.Listener listener) {
        try {
            this.mGnssAntennaInfoListenerManager.removeListener(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    public boolean addGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        return false;
    }

    @Deprecated
    @SystemApi
    public void removeGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
    }

    @Deprecated
    public boolean registerGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback) {
        return this.registerGnssNavigationMessageCallback(Runnable::run, callback);
    }

    public boolean registerGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        try {
            return this.mGnssNavigationMessageListenerTransport.addListener(callback, handler);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean registerGnssNavigationMessageCallback(Executor executor, GnssNavigationMessage.Callback callback) {
        try {
            return this.mGnssNavigationMessageListenerTransport.addListener(callback, executor);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback) {
        try {
            this.mGnssNavigationMessageListenerTransport.removeListener(callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public int getGnssBatchSize() {
        try {
            return this.mService.getGnssBatchSize(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean registerGnssBatchedLocationCallback(long periodNanos, boolean wakeOnFifoFull, BatchedLocationCallback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        BatchedLocationCallbackManager batchedLocationCallbackManager = this.mBatchedLocationCallbackManager;
        synchronized (batchedLocationCallbackManager) {
            try {
                if (this.mBatchedLocationCallbackManager.addListener(callback, handler)) {
                    return this.mService.startGnssBatch(periodNanos, wakeOnFifoFull, this.mContext.getPackageName(), this.mContext.getAttributionTag());
                }
                return false;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    public void flushGnssBatch() {
        try {
            this.mService.flushGnssBatch(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean unregisterGnssBatchedLocationCallback(BatchedLocationCallback callback) {
        BatchedLocationCallbackManager batchedLocationCallbackManager = this.mBatchedLocationCallbackManager;
        synchronized (batchedLocationCallbackManager) {
            try {
                this.mBatchedLocationCallbackManager.removeListener(callback);
                this.mService.stopGnssBatch();
                return true;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static void invalidateLocalLocationEnabledCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_LOCATION_ENABLED_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableLocalLocationEnabledCaches() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocationEnabledCache = null;
        }
    }

    private class BatchedLocationCallbackManager
    extends AbstractListenerManager<Void, android.location.BatchedLocationCallback> {
        private IBatchedLocationCallback mListenerTransport;

        private BatchedLocationCallbackManager() {
        }

        @Override
        protected boolean registerService(Void ignored) throws RemoteException {
            Preconditions.checkState(this.mListenerTransport == null);
            BatchedLocationCallback transport = new BatchedLocationCallback();
            if (LocationManager.this.mService.addGnssBatchingCallback(transport, LocationManager.this.mContext.getPackageName(), LocationManager.this.mContext.getAttributionTag())) {
                this.mListenerTransport = transport;
                return true;
            }
            return false;
        }

        @Override
        protected void unregisterService() throws RemoteException {
            if (this.mListenerTransport != null) {
                LocationManager.this.mService.removeGnssBatchingCallback();
                this.mListenerTransport = null;
            }
        }

        private class BatchedLocationCallback
        extends IBatchedLocationCallback.Stub {
            private BatchedLocationCallback() {
            }

            @Override
            public void onLocationBatch(List<Location> locations) {
                BatchedLocationCallbackManager.this.execute(listener -> listener.onLocationBatch(locations));
            }
        }
    }

    private class GnssAntennaInfoListenerManager
    extends AbstractListenerManager<Void, GnssAntennaInfo.Listener> {
        private IGnssAntennaInfoListener mListenerTransport;

        private GnssAntennaInfoListenerManager() {
        }

        @Override
        protected boolean registerService(Void ignored) throws RemoteException {
            Preconditions.checkState(this.mListenerTransport == null);
            GnssAntennaInfoListener transport = new GnssAntennaInfoListener();
            if (LocationManager.this.mService.addGnssAntennaInfoListener(transport, LocationManager.this.mContext.getPackageName(), LocationManager.this.mContext.getAttributionTag())) {
                this.mListenerTransport = transport;
                return true;
            }
            return false;
        }

        @Override
        protected void unregisterService() throws RemoteException {
            if (this.mListenerTransport != null) {
                LocationManager.this.mService.removeGnssAntennaInfoListener(this.mListenerTransport);
                this.mListenerTransport = null;
            }
        }

        private class GnssAntennaInfoListener
        extends IGnssAntennaInfoListener.Stub {
            private GnssAntennaInfoListener() {
            }

            @Override
            public void onGnssAntennaInfoReceived(List<GnssAntennaInfo> gnssAntennaInfos) {
                GnssAntennaInfoListenerManager.this.execute(callback -> callback.onGnssAntennaInfoReceived(gnssAntennaInfos));
            }
        }
    }

    private class GnssNavigationMessageListenerManager
    extends AbstractListenerManager<Void, GnssNavigationMessage.Callback> {
        private IGnssNavigationMessageListener mListenerTransport;

        private GnssNavigationMessageListenerManager() {
        }

        @Override
        protected boolean registerService(Void ignored) throws RemoteException {
            Preconditions.checkState(this.mListenerTransport == null);
            GnssNavigationMessageListener transport = new GnssNavigationMessageListener();
            if (LocationManager.this.mService.addGnssNavigationMessageListener(transport, LocationManager.this.mContext.getPackageName(), LocationManager.this.mContext.getAttributionTag())) {
                this.mListenerTransport = transport;
                return true;
            }
            return false;
        }

        @Override
        protected void unregisterService() throws RemoteException {
            if (this.mListenerTransport != null) {
                LocationManager.this.mService.removeGnssNavigationMessageListener(this.mListenerTransport);
                this.mListenerTransport = null;
            }
        }

        private class GnssNavigationMessageListener
        extends IGnssNavigationMessageListener.Stub {
            private GnssNavigationMessageListener() {
            }

            @Override
            public void onGnssNavigationMessageReceived(GnssNavigationMessage event) {
                GnssNavigationMessageListenerManager.this.execute(listener -> listener.onGnssNavigationMessageReceived(event));
            }

            @Override
            public void onStatusChanged(int status) {
                GnssNavigationMessageListenerManager.this.execute(listener -> listener.onStatusChanged(status));
            }
        }
    }

    private class GnssMeasurementsListenerManager
    extends AbstractListenerManager<GnssRequest, GnssMeasurementsEvent.Callback> {
        private IGnssMeasurementsListener mListenerTransport;

        private GnssMeasurementsListenerManager() {
        }

        @Override
        protected boolean registerService(GnssRequest request) throws RemoteException {
            Preconditions.checkState(this.mListenerTransport == null);
            GnssMeasurementsListener transport = new GnssMeasurementsListener();
            if (LocationManager.this.mService.addGnssMeasurementsListener(request, transport, LocationManager.this.mContext.getPackageName(), LocationManager.this.mContext.getAttributionTag())) {
                this.mListenerTransport = transport;
                return true;
            }
            return false;
        }

        @Override
        protected void unregisterService() throws RemoteException {
            if (this.mListenerTransport != null) {
                LocationManager.this.mService.removeGnssMeasurementsListener(this.mListenerTransport);
                this.mListenerTransport = null;
            }
        }

        @Override
        protected GnssRequest merge(List<GnssRequest> requests) {
            Preconditions.checkArgument(!requests.isEmpty());
            for (GnssRequest request : requests) {
                if (!request.isFullTracking()) continue;
                return request;
            }
            return requests.get(0);
        }

        private class GnssMeasurementsListener
        extends IGnssMeasurementsListener.Stub {
            private GnssMeasurementsListener() {
            }

            @Override
            public void onGnssMeasurementsReceived(GnssMeasurementsEvent event) {
                GnssMeasurementsListenerManager.this.execute(callback -> callback.onGnssMeasurementsReceived(event));
            }

            @Override
            public void onStatusChanged(int status) {
                GnssMeasurementsListenerManager.this.execute(callback -> callback.onStatusChanged(status));
            }
        }
    }

    private class GnssStatusListenerManager
    extends AbstractListenerManager<Void, GnssStatus.Callback> {
        private IGnssStatusListener mListenerTransport;
        private volatile GnssStatus mGnssStatus;
        private volatile int mTtff;

        private GnssStatusListenerManager() {
        }

        public GnssStatus getGnssStatus() {
            return this.mGnssStatus;
        }

        public int getTtff() {
            return this.mTtff;
        }

        @Override
        public boolean addListener(GpsStatus.Listener listener, Executor executor) throws RemoteException {
            return this.addInternal(null, (Object)listener, executor);
        }

        @Override
        public boolean addListener(OnNmeaMessageListener listener, Handler handler) throws RemoteException {
            return this.addInternal(null, (Object)listener, handler);
        }

        @Override
        public boolean addListener(OnNmeaMessageListener listener, Executor executor) throws RemoteException {
            return this.addInternal(null, (Object)listener, executor);
        }

        @Override
        protected GnssStatus.Callback convertKey(final Object listener) {
            if (listener instanceof GnssStatus.Callback) {
                return (GnssStatus.Callback)listener;
            }
            if (listener instanceof GpsStatus.Listener) {
                return new GnssStatus.Callback(){
                    private final GpsStatus.Listener mGpsListener;
                    {
                        this.mGpsListener = (GpsStatus.Listener)listener;
                    }

                    @Override
                    public void onStarted() {
                        this.mGpsListener.onGpsStatusChanged(1);
                    }

                    @Override
                    public void onStopped() {
                        this.mGpsListener.onGpsStatusChanged(2);
                    }

                    @Override
                    public void onFirstFix(int ttffMillis) {
                        this.mGpsListener.onGpsStatusChanged(3);
                    }

                    @Override
                    public void onSatelliteStatusChanged(GnssStatus status) {
                        this.mGpsListener.onGpsStatusChanged(4);
                    }
                };
            }
            if (listener instanceof OnNmeaMessageListener) {
                return new NmeaAdapter((OnNmeaMessageListener)listener);
            }
            throw new IllegalStateException();
        }

        @Override
        protected boolean registerService(Void ignored) throws RemoteException {
            Preconditions.checkState(this.mListenerTransport == null);
            GnssStatusListener transport = new GnssStatusListener();
            if (LocationManager.this.mService.registerGnssStatusCallback(transport, LocationManager.this.mContext.getPackageName(), LocationManager.this.mContext.getAttributionTag())) {
                this.mListenerTransport = transport;
                return true;
            }
            return false;
        }

        @Override
        protected void unregisterService() throws RemoteException {
            if (this.mListenerTransport != null) {
                LocationManager.this.mService.unregisterGnssStatusCallback(this.mListenerTransport);
                this.mListenerTransport = null;
            }
        }

        private class GnssStatusListener
        extends IGnssStatusListener.Stub {
            private GnssStatusListener() {
            }

            @Override
            public void onGnssStarted() {
                GnssStatusListenerManager.this.execute(GnssStatus.Callback::onStarted);
            }

            @Override
            public void onGnssStopped() {
                GnssStatusListenerManager.this.execute(GnssStatus.Callback::onStopped);
            }

            @Override
            public void onFirstFix(int ttff) {
                GnssStatusListenerManager.this.mTtff = ttff;
                GnssStatusListenerManager.this.execute(callback -> callback.onFirstFix(ttff));
            }

            @Override
            public void onSvStatusChanged(int svCount, int[] svidWithFlags, float[] cn0s, float[] elevations, float[] azimuths, float[] carrierFreqs, float[] basebandCn0s) {
                GnssStatus localStatus = GnssStatus.wrap(svCount, svidWithFlags, cn0s, elevations, azimuths, carrierFreqs, basebandCn0s);
                GnssStatusListenerManager.this.mGnssStatus = localStatus;
                GnssStatusListenerManager.this.execute(callback -> callback.onSatelliteStatusChanged(localStatus));
            }

            @Override
            public void onNmeaReceived(long timestamp, String nmea) {
                GnssStatusListenerManager.this.execute(callback -> {
                    if (callback instanceof NmeaAdapter) {
                        ((NmeaAdapter)callback).onNmeaMessage(nmea, timestamp);
                    }
                });
            }
        }
    }

    private static class NmeaAdapter
    extends GnssStatus.Callback
    implements OnNmeaMessageListener {
        private final OnNmeaMessageListener mListener;

        private NmeaAdapter(OnNmeaMessageListener listener) {
            this.mListener = listener;
        }

        @Override
        public void onNmeaMessage(String message, long timestamp) {
            this.mListener.onNmeaMessage(message, timestamp);
        }
    }

    private class LocationListenerTransport
    extends ILocationListener.Stub {
        private final LocationListener mListener;
        private volatile Executor mExecutor = null;

        private LocationListenerTransport(LocationListener listener) {
            Preconditions.checkArgument(listener != null, "invalid null listener");
            this.mListener = listener;
        }

        public LocationListener getKey() {
            return this.mListener;
        }

        public String getListenerId() {
            return AppOpsManager.toReceiverId(this.mListener);
        }

        public void register(Executor executor) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            this.mExecutor = executor;
        }

        public void unregister() {
            this.mExecutor = null;
        }

        @Override
        public void onLocationChanged(Location location) {
            Executor currentExecutor = this.mExecutor;
            if (currentExecutor == null) {
                return;
            }
            PooledRunnable runnable = PooledLambda.obtainRunnable(LocationListenerTransport::acceptLocation, this, currentExecutor, location).recycleOnUse();
            try {
                currentExecutor.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                runnable.recycle();
                this.locationCallbackFinished();
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptLocation(Executor currentExecutor, Location location) {
            try {
                if (currentExecutor != this.mExecutor) {
                    return;
                }
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mListener.onLocationChanged(location);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            finally {
                this.locationCallbackFinished();
            }
        }

        @Override
        public void onProviderEnabled(String provider) {
            Executor currentExecutor = this.mExecutor;
            if (currentExecutor == null) {
                return;
            }
            PooledRunnable runnable = PooledLambda.obtainRunnable(LocationListenerTransport::acceptProviderChange, this, currentExecutor, provider, true).recycleOnUse();
            try {
                currentExecutor.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                runnable.recycle();
                this.locationCallbackFinished();
                throw e;
            }
        }

        @Override
        public void onProviderDisabled(String provider) {
            Executor currentExecutor = this.mExecutor;
            if (currentExecutor == null) {
                return;
            }
            PooledRunnable runnable = PooledLambda.obtainRunnable(LocationListenerTransport::acceptProviderChange, this, currentExecutor, provider, false).recycleOnUse();
            try {
                currentExecutor.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                runnable.recycle();
                this.locationCallbackFinished();
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptProviderChange(Executor currentExecutor, String provider, boolean enabled) {
            try {
                if (currentExecutor != this.mExecutor) {
                    return;
                }
                long identity = Binder.clearCallingIdentity();
                try {
                    if (enabled) {
                        this.mListener.onProviderEnabled(provider);
                    } else {
                        this.mListener.onProviderDisabled(provider);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            finally {
                this.locationCallbackFinished();
            }
        }

        @Override
        public void onRemoved() {
            Executor currentExecutor = this.mExecutor;
            if (currentExecutor == null) {
                return;
            }
            currentExecutor.execute(() -> {
                if (currentExecutor != this.mExecutor) {
                    return;
                }
                this.unregister();
                ArrayMap arrayMap = LocationManager.this.mListeners;
                synchronized (arrayMap) {
                    LocationManager.this.mListeners.remove(this.mListener, this);
                }
            });
        }

        private void locationCallbackFinished() {
            try {
                LocationManager.this.mService.locationCallbackFinished(this);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private static class GetCurrentLocationTransport
    extends ILocationListener.Stub
    implements AlarmManager.OnAlarmListener {
        @GuardedBy(value={"this"})
        private Executor mExecutor;
        @GuardedBy(value={"this"})
        private Consumer<Location> mConsumer;
        @GuardedBy(value={"this"})
        private AlarmManager mAlarmManager;
        @GuardedBy(value={"this"})
        private ICancellationSignal mRemoteCancellationSignal;

        private GetCurrentLocationTransport(Executor executor, Consumer<Location> consumer) {
            Preconditions.checkArgument(executor != null, "illegal null executor");
            Preconditions.checkArgument(consumer != null, "illegal null consumer");
            this.mExecutor = executor;
            this.mConsumer = consumer;
            this.mAlarmManager = null;
            this.mRemoteCancellationSignal = null;
        }

        public String getListenerId() {
            return AppOpsManager.toReceiverId(this.mConsumer);
        }

        public synchronized void register(AlarmManager alarmManager, ICancellationSignal remoteCancellationSignal) {
            if (this.mConsumer == null) {
                return;
            }
            this.mAlarmManager = alarmManager;
            this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + 30000L, "GetCurrentLocation", this, null);
            this.mRemoteCancellationSignal = remoteCancellationSignal;
        }

        public void cancel() {
            this.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Consumer<Location> remove() {
            ICancellationSignal cancellationSignal;
            Consumer<Location> consumer;
            GetCurrentLocationTransport getCurrentLocationTransport = this;
            synchronized (getCurrentLocationTransport) {
                this.mExecutor = null;
                consumer = this.mConsumer;
                this.mConsumer = null;
                if (this.mAlarmManager != null) {
                    this.mAlarmManager.cancel(this);
                    this.mAlarmManager = null;
                }
                cancellationSignal = this.mRemoteCancellationSignal;
                this.mRemoteCancellationSignal = null;
            }
            if (cancellationSignal != null) {
                try {
                    cancellationSignal.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return consumer;
        }

        public void fail() {
            this.deliverResult(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            GetCurrentLocationTransport getCurrentLocationTransport = this;
            synchronized (getCurrentLocationTransport) {
                this.mAlarmManager = null;
            }
            this.deliverResult(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationChanged(Location location) {
            GetCurrentLocationTransport getCurrentLocationTransport = this;
            synchronized (getCurrentLocationTransport) {
                this.mRemoteCancellationSignal = null;
            }
            this.deliverResult(location);
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
            this.deliverResult(null);
        }

        @Override
        public void onRemoved() {
            this.deliverResult(null);
        }

        private synchronized void deliverResult(Location location) {
            if (this.mExecutor == null) {
                return;
            }
            PooledRunnable runnable = PooledLambda.obtainRunnable(GetCurrentLocationTransport::acceptResult, this, location).recycleOnUse();
            try {
                this.mExecutor.execute(runnable);
            }
            catch (RejectedExecutionException e) {
                runnable.recycle();
                throw e;
            }
        }

        private void acceptResult(Location location) {
            Consumer<Location> consumer = this.remove();
            if (consumer != null) {
                consumer.accept(location);
            }
        }
    }
}

