/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorSpace;
import android.os.Parcel;
import android.os.Parcelable;

public class ParcelableColorSpace
extends ColorSpace
implements Parcelable {
    private final ColorSpace mColorSpace;
    public static final Parcelable.Creator<ParcelableColorSpace> CREATOR = new Parcelable.Creator<ParcelableColorSpace>(){

        @Override
        public ParcelableColorSpace createFromParcel(Parcel in) {
            int id2 = in.readInt();
            if (id2 == -1) {
                String name = in.readString();
                float[] primaries = in.createFloatArray();
                float[] whitePoint = in.createFloatArray();
                double a = in.readDouble();
                double b = in.readDouble();
                double c = in.readDouble();
                double d = in.readDouble();
                double e = in.readDouble();
                double f = in.readDouble();
                double g = in.readDouble();
                ColorSpace.Rgb.TransferParameters function = new ColorSpace.Rgb.TransferParameters(a, b, c, d, e, f, g);
                return new ParcelableColorSpace(new ColorSpace.Rgb(name, primaries, whitePoint, function));
            }
            return new ParcelableColorSpace(ColorSpace.get(id2));
        }

        public ParcelableColorSpace[] newArray(int size) {
            return new ParcelableColorSpace[size];
        }
    };

    public static boolean isParcelable(ColorSpace colorSpace) {
        if (colorSpace.getId() == -1) {
            if (!(colorSpace instanceof ColorSpace.Rgb)) {
                return false;
            }
            ColorSpace.Rgb rgb = (ColorSpace.Rgb)colorSpace;
            if (rgb.getTransferParameters() == null) {
                return false;
            }
        }
        return true;
    }

    public ParcelableColorSpace(ColorSpace colorSpace) {
        super(colorSpace.getName(), colorSpace.getModel(), colorSpace.getId());
        this.mColorSpace = colorSpace;
        if (this.mColorSpace.getId() == -1) {
            if (!(this.mColorSpace instanceof ColorSpace.Rgb)) {
                throw new IllegalArgumentException("Unable to parcel unknown ColorSpaces that are not ColorSpace.Rgb");
            }
            ColorSpace.Rgb rgb = (ColorSpace.Rgb)this.mColorSpace;
            if (rgb.getTransferParameters() == null) {
                throw new IllegalArgumentException("ColorSpace must use an ICC parametric transfer function to be parcelable");
            }
        }
    }

    public ColorSpace getColorSpace() {
        return this.mColorSpace;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int id2 = this.mColorSpace.getId();
        dest.writeInt(id2);
        if (id2 == -1) {
            ColorSpace.Rgb rgb = (ColorSpace.Rgb)this.mColorSpace;
            dest.writeString(rgb.getName());
            dest.writeFloatArray(rgb.getPrimaries());
            dest.writeFloatArray(rgb.getWhitePoint());
            ColorSpace.Rgb.TransferParameters transferParameters = rgb.getTransferParameters();
            dest.writeDouble(transferParameters.a);
            dest.writeDouble(transferParameters.b);
            dest.writeDouble(transferParameters.c);
            dest.writeDouble(transferParameters.d);
            dest.writeDouble(transferParameters.e);
            dest.writeDouble(transferParameters.f);
            dest.writeDouble(transferParameters.g);
        }
    }

    @Override
    public boolean isWideGamut() {
        return this.mColorSpace.isWideGamut();
    }

    @Override
    public float getMinValue(int component) {
        return this.mColorSpace.getMinValue(component);
    }

    @Override
    public float getMaxValue(int component) {
        return this.mColorSpace.getMaxValue(component);
    }

    @Override
    public float[] toXyz(float[] v) {
        return this.mColorSpace.toXyz(v);
    }

    @Override
    public float[] fromXyz(float[] v) {
        return this.mColorSpace.fromXyz(v);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParcelableColorSpace other = (ParcelableColorSpace)o;
        return this.mColorSpace.equals(other.mColorSpace);
    }

    @Override
    public int hashCode() {
        return this.mColorSpace.hashCode();
    }

    @Override
    long getNativeInstance() {
        return this.mColorSpace.getNativeInstance();
    }
}

