/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.ImageDecoder_Delegate;
import android.graphics.NinePatch;
import android.graphics.PostProcessor;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.Uri;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Size;
import android.util.TypedValue;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;

public final class ImageDecoder
implements AutoCloseable {
    public static int sApiLevel;
    @Deprecated
    public static final int ERROR_SOURCE_EXCEPTION = 1;
    @Deprecated
    public static final int ERROR_SOURCE_INCOMPLETE = 2;
    @Deprecated
    public static final int ERROR_SOURCE_ERROR = 3;
    private long mNativePtr;
    private final int mWidth;
    private final int mHeight;
    private final boolean mAnimated;
    private final boolean mIsNinePatch;
    private int mDesiredWidth;
    private int mDesiredHeight;
    private int mAllocator = 0;
    private boolean mUnpremultipliedRequired = false;
    private boolean mMutable = false;
    private boolean mConserveMemory = false;
    private boolean mDecodeAsAlphaMask = false;
    private ColorSpace mDesiredColorSpace = null;
    private Rect mCropRect;
    private Rect mOutPaddingRect;
    private Source mSource;
    private PostProcessor mPostProcessor;
    private OnPartialImageListener mOnPartialImageListener;
    private InputStream mInputStream;
    private boolean mOwnsInputStream;
    private byte[] mTempStorage;
    private AssetFileDescriptor mAssetFd;
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final int ALLOCATOR_DEFAULT = 0;
    public static final int ALLOCATOR_SOFTWARE = 1;
    public static final int ALLOCATOR_SHARED_MEMORY = 2;
    public static final int ALLOCATOR_HARDWARE = 3;
    public static final int MEMORY_POLICY_LOW_RAM = 0;
    public static final int MEMORY_POLICY_DEFAULT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromFile(File file, boolean preferAnimation, Source source) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        FileDescriptor fd = stream.getFD();
        try {
            Os.lseek(fd, 0L, OsConstants.SEEK_CUR);
        }
        catch (ErrnoException e) {
            return ImageDecoder.createFromStream(stream, true, preferAnimation, source);
        }
        ImageDecoder decoder = null;
        try {
            decoder = ImageDecoder.nCreate(fd, preferAnimation, source);
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(stream);
            } else {
                decoder.mInputStream = stream;
                decoder.mOwnsInputStream = true;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromStream(InputStream is, boolean closeInputStream, boolean preferAnimation, Source source) throws IOException {
        byte[] storage = new byte[16384];
        ImageDecoder decoder = null;
        try {
            decoder = ImageDecoder.nCreate(is, storage, preferAnimation, source);
        }
        finally {
            if (decoder == null) {
                if (closeInputStream) {
                    IoUtils.closeQuietly(is);
                }
            } else {
                decoder.mInputStream = is;
                decoder.mOwnsInputStream = closeInputStream;
                decoder.mTempStorage = storage;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromAssetFileDescriptor(AssetFileDescriptor assetFd, boolean preferAnimation, Source source) throws IOException {
        if (assetFd == null) {
            throw new FileNotFoundException();
        }
        FileDescriptor fd = assetFd.getFileDescriptor();
        long offset = assetFd.getStartOffset();
        ImageDecoder decoder = null;
        try {
            try {
                Os.lseek(fd, offset, OsConstants.SEEK_SET);
                decoder = ImageDecoder.nCreate(fd, preferAnimation, source);
            }
            catch (ErrnoException e) {
                decoder = ImageDecoder.createFromStream(new FileInputStream(fd), true, preferAnimation, source);
            }
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(assetFd);
            } else {
                decoder.mAssetFd = assetFd;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromAsset(AssetManager.AssetInputStream ais, boolean preferAnimation, Source source) throws IOException {
        ImageDecoder decoder = null;
        try {
            long asset = ais.getNativeAsset();
            decoder = ImageDecoder.nCreate(asset, preferAnimation, source);
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(ais);
            } else {
                decoder.mInputStream = ais;
                decoder.mOwnsInputStream = true;
            }
        }
        return decoder;
    }

    private ImageDecoder(long nativePtr, int width, int height, boolean animated, boolean isNinePatch) {
        this.mNativePtr = nativePtr;
        this.mWidth = width;
        this.mHeight = height;
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        this.mAnimated = animated;
        this.mIsNinePatch = isNinePatch;
        this.mCloseGuard.open("close");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mInputStream = null;
            this.mAssetFd = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static boolean isMimeTypeSupported(String mimeType) {
        Objects.requireNonNull(mimeType);
        switch (mimeType.toLowerCase(Locale.US)) {
            case "image/png": 
            case "image/jpeg": 
            case "image/webp": 
            case "image/gif": 
            case "image/heif": 
            case "image/heic": 
            case "image/bmp": 
            case "image/x-ico": 
            case "image/vnd.wap.wbmp": 
            case "image/x-sony-arw": 
            case "image/x-canon-cr2": 
            case "image/x-adobe-dng": 
            case "image/x-nikon-nef": 
            case "image/x-nikon-nrw": 
            case "image/x-olympus-orf": 
            case "image/x-fuji-raf": 
            case "image/x-panasonic-rw2": 
            case "image/x-pentax-pef": 
            case "image/x-samsung-srw": {
                return true;
            }
        }
        return false;
    }

    public static Source createSource(Resources res, int resId) {
        return new ResourceSource(res, resId);
    }

    public static Source createSource(ContentResolver cr, Uri uri) {
        return new ContentResolverSource(cr, uri, null);
    }

    public static Source createSource(ContentResolver cr, Uri uri, Resources res) {
        return new ContentResolverSource(cr, uri, res);
    }

    public static Source createSource(AssetManager assets, String fileName) {
        return new AssetSource(assets, fileName);
    }

    public static Source createSource(byte[] data, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (data == null) {
            throw new NullPointerException("null byte[] in createSource!");
        }
        if (offset < 0 || length < 0 || offset >= data.length || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException("invalid offset/length!");
        }
        return new ByteArraySource(data, offset, length);
    }

    public static Source createSource(byte[] data) {
        return ImageDecoder.createSource(data, 0, data.length);
    }

    public static Source createSource(ByteBuffer buffer) {
        return new ByteBufferSource(buffer);
    }

    public static Source createSource(Resources res, InputStream is) {
        return new InputStreamSource(res, is, Bitmap.getDefaultDensity());
    }

    public static Source createSource(Resources res, InputStream is, int density) {
        return new InputStreamSource(res, is, density);
    }

    public static Source createSource(File file) {
        return new FileSource(file);
    }

    public static Source createSource(Callable<AssetFileDescriptor> callable) {
        return new CallableSource(callable);
    }

    public Size getSampledSize(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("sampleSize must be positive! provided " + sampleSize);
        }
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("ImageDecoder is closed!");
        }
        return ImageDecoder.nGetSampledSize(this.mNativePtr, sampleSize);
    }

    @Deprecated
    public ImageDecoder setResize(int width, int height) {
        this.setTargetSize(width, height);
        return this;
    }

    public void setTargetSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Dimensions must be positive! provided (" + width + ", " + height + ")");
        }
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
    }

    @Deprecated
    public ImageDecoder setResize(int sampleSize) {
        this.setTargetSampleSize(sampleSize);
        return this;
    }

    private int getTargetDimension(int original, int sampleSize, int computed) {
        if (sampleSize >= original) {
            return 1;
        }
        int target = original / sampleSize;
        if (computed == target) {
            return computed;
        }
        int reverse = computed * sampleSize;
        if (Math.abs(reverse - original) < sampleSize) {
            return computed;
        }
        return target;
    }

    public void setTargetSampleSize(int sampleSize) {
        Size size = this.getSampledSize(sampleSize);
        int targetWidth = this.getTargetDimension(this.mWidth, sampleSize, size.getWidth());
        int targetHeight = this.getTargetDimension(this.mHeight, sampleSize, size.getHeight());
        this.setTargetSize(targetWidth, targetHeight);
    }

    private boolean requestedResize() {
        return this.mWidth != this.mDesiredWidth || this.mHeight != this.mDesiredHeight;
    }

    public void setAllocator(int allocator) {
        if (allocator < 0 || allocator > 3) {
            throw new IllegalArgumentException("invalid allocator " + allocator);
        }
        this.mAllocator = allocator;
    }

    public int getAllocator() {
        return this.mAllocator;
    }

    public void setUnpremultipliedRequired(boolean unpremultipliedRequired) {
        this.mUnpremultipliedRequired = unpremultipliedRequired;
    }

    @Deprecated
    public ImageDecoder setRequireUnpremultiplied(boolean unpremultipliedRequired) {
        this.setUnpremultipliedRequired(unpremultipliedRequired);
        return this;
    }

    public boolean isUnpremultipliedRequired() {
        return this.mUnpremultipliedRequired;
    }

    @Deprecated
    public boolean getRequireUnpremultiplied() {
        return this.isUnpremultipliedRequired();
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        this.mPostProcessor = postProcessor;
    }

    public PostProcessor getPostProcessor() {
        return this.mPostProcessor;
    }

    public void setOnPartialImageListener(OnPartialImageListener listener) {
        this.mOnPartialImageListener = listener;
    }

    public OnPartialImageListener getOnPartialImageListener() {
        return this.mOnPartialImageListener;
    }

    public void setCrop(Rect subset) {
        this.mCropRect = subset;
    }

    public Rect getCrop() {
        return this.mCropRect;
    }

    public void setOutPaddingRect(Rect outPadding) {
        this.mOutPaddingRect = outPadding;
    }

    public void setMutableRequired(boolean mutable) {
        this.mMutable = mutable;
    }

    @Deprecated
    public ImageDecoder setMutable(boolean mutable) {
        this.setMutableRequired(mutable);
        return this;
    }

    public boolean isMutableRequired() {
        return this.mMutable;
    }

    @Deprecated
    public boolean getMutable() {
        return this.isMutableRequired();
    }

    public void setMemorySizePolicy(int policy) {
        this.mConserveMemory = policy == 0;
    }

    public int getMemorySizePolicy() {
        return this.mConserveMemory ? 0 : 1;
    }

    @Deprecated
    public void setConserveMemory(boolean conserveMemory) {
        this.mConserveMemory = conserveMemory;
    }

    @Deprecated
    public boolean getConserveMemory() {
        return this.mConserveMemory;
    }

    public void setDecodeAsAlphaMaskEnabled(boolean enabled) {
        this.mDecodeAsAlphaMask = enabled;
    }

    @Deprecated
    public ImageDecoder setDecodeAsAlphaMask(boolean enabled) {
        this.setDecodeAsAlphaMaskEnabled(enabled);
        return this;
    }

    @Deprecated
    public ImageDecoder setAsAlphaMask(boolean asAlphaMask) {
        this.setDecodeAsAlphaMask(asAlphaMask);
        return this;
    }

    public boolean isDecodeAsAlphaMaskEnabled() {
        return this.mDecodeAsAlphaMask;
    }

    @Deprecated
    public boolean getDecodeAsAlphaMask() {
        return this.mDecodeAsAlphaMask;
    }

    @Deprecated
    public boolean getAsAlphaMask() {
        return this.getDecodeAsAlphaMask();
    }

    public void setTargetColorSpace(ColorSpace colorSpace) {
        this.mDesiredColorSpace = colorSpace;
    }

    @Override
    public void close() {
        this.mCloseGuard.close();
        if (!this.mClosed.compareAndSet(false, true)) {
            return;
        }
        ImageDecoder.nClose(this.mNativePtr);
        this.mNativePtr = 0L;
        if (this.mOwnsInputStream) {
            IoUtils.closeQuietly(this.mInputStream);
        }
        IoUtils.closeQuietly(this.mAssetFd);
        this.mInputStream = null;
        this.mAssetFd = null;
        this.mTempStorage = null;
    }

    private void checkState(boolean animated) {
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("Cannot use closed ImageDecoder!");
        }
        ImageDecoder.checkSubset(this.mDesiredWidth, this.mDesiredHeight, this.mCropRect);
        if (!animated && this.mAllocator == 3) {
            if (this.mMutable) {
                throw new IllegalStateException("Cannot make mutable HARDWARE Bitmap!");
            }
            if (this.mDecodeAsAlphaMask) {
                throw new IllegalStateException("Cannot make HARDWARE Alpha mask Bitmap!");
            }
        }
        if (this.mPostProcessor != null && this.mUnpremultipliedRequired) {
            throw new IllegalStateException("Cannot draw to unpremultiplied pixels!");
        }
    }

    private static void checkSubset(int width, int height, Rect r) {
        if (r == null) {
            return;
        }
        if (r.width() <= 0 || r.height() <= 0) {
            throw new IllegalStateException("Subset " + r + " is empty/unsorted");
        }
        if (r.left < 0 || r.top < 0 || r.right > width || r.bottom > height) {
            throw new IllegalStateException("Subset " + r + " not contained by scaled image bounds: (" + width + " x " + height + ")");
        }
    }

    private boolean checkForExtended() {
        if (this.mDesiredColorSpace == null) {
            return false;
        }
        return this.mDesiredColorSpace == ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB) || this.mDesiredColorSpace == ColorSpace.get(ColorSpace.Named.LINEAR_EXTENDED_SRGB);
    }

    private long getColorSpacePtr() {
        if (this.mDesiredColorSpace == null) {
            return 0L;
        }
        return this.mDesiredColorSpace.getNativeInstance();
    }

    private Bitmap decodeBitmapInternal() throws IOException {
        this.checkState(false);
        return ImageDecoder.nDecodeBitmap(this.mNativePtr, this, this.mPostProcessor != null, this.mDesiredWidth, this.mDesiredHeight, this.mCropRect, this.mMutable, this.mAllocator, this.mUnpremultipliedRequired, this.mConserveMemory, this.mDecodeAsAlphaMask, this.getColorSpacePtr(), this.checkForExtended());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHeaderDecoded(OnHeaderDecodedListener listener, Source src) {
        if (listener != null) {
            ImageInfo info = new ImageInfo(this);
            try {
                listener.onHeaderDecoded(this, info, src);
            }
            finally {
                info.mDecoder = null;
            }
        }
    }

    public static Drawable decodeDrawable(Source src, OnHeaderDecodedListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null! Use decodeDrawable(Source) to not have a listener");
        }
        return ImageDecoder.decodeDrawableImpl(src, listener);
    }

    private static Drawable decodeDrawableImpl(Source src, OnHeaderDecodedListener listener) throws IOException {
        try (ImageDecoder decoder = src.createImageDecoder(true);){
            decoder.mSource = src;
            decoder.callHeaderDecoded(listener, src);
            if (decoder.mUnpremultipliedRequired) {
                throw new IllegalStateException("Cannot decode a Drawable with unpremultiplied pixels!");
            }
            if (decoder.mMutable) {
                throw new IllegalStateException("Cannot decode a mutable Drawable!");
            }
            int srcDensity = decoder.computeDensity(src);
            if (decoder.mAnimated) {
                ImageDecoder postProcessPtr = decoder.mPostProcessor == null ? null : decoder;
                decoder.checkState(true);
                AnimatedImageDrawable d = new AnimatedImageDrawable(decoder.mNativePtr, postProcessPtr, decoder.mDesiredWidth, decoder.mDesiredHeight, decoder.getColorSpacePtr(), decoder.checkForExtended(), srcDensity, src.computeDstDensity(), decoder.mCropRect, decoder.mInputStream, decoder.mAssetFd);
                decoder.mInputStream = null;
                decoder.mAssetFd = null;
                AnimatedImageDrawable animatedImageDrawable = d;
                return animatedImageDrawable;
            }
            Bitmap bm = decoder.decodeBitmapInternal();
            bm.setDensity(srcDensity);
            Resources res = src.getResources();
            byte[] np = bm.getNinePatchChunk();
            if (np != null && NinePatch.isNinePatchChunk(np)) {
                Rect opticalInsets = new Rect();
                bm.getOpticalInsets(opticalInsets);
                Rect padding = decoder.mOutPaddingRect;
                if (padding == null) {
                    padding = new Rect();
                }
                ImageDecoder.nGetPadding(decoder.mNativePtr, padding);
                NinePatchDrawable ninePatchDrawable = new NinePatchDrawable(res, bm, np, padding, opticalInsets, null);
                return ninePatchDrawable;
            }
            BitmapDrawable bitmapDrawable = new BitmapDrawable(res, bm);
            return bitmapDrawable;
        }
    }

    public static Drawable decodeDrawable(Source src) throws IOException {
        return ImageDecoder.decodeDrawableImpl(src, null);
    }

    public static Bitmap decodeBitmap(Source src, OnHeaderDecodedListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null! Use decodeBitmap(Source) to not have a listener");
        }
        return ImageDecoder.decodeBitmapImpl(src, listener);
    }

    static Bitmap decodeBitmapImpl_Original(Source src, OnHeaderDecodedListener listener) throws IOException {
        try (ImageDecoder decoder = src.createImageDecoder(false);){
            byte[] np;
            decoder.mSource = src;
            decoder.callHeaderDecoded(listener, src);
            int srcDensity = decoder.computeDensity(src);
            Bitmap bm = decoder.decodeBitmapInternal();
            bm.setDensity(srcDensity);
            Rect padding = decoder.mOutPaddingRect;
            if (padding != null && (np = bm.getNinePatchChunk()) != null && NinePatch.isNinePatchChunk(np)) {
                ImageDecoder.nGetPadding(decoder.mNativePtr, padding);
            }
            Bitmap bitmap = bm;
            return bitmap;
        }
    }

    @LayoutlibDelegate
    private static Bitmap decodeBitmapImpl(Source source, OnHeaderDecodedListener onHeaderDecodedListener) throws IOException {
        return ImageDecoder_Delegate.decodeBitmapImpl(source, onHeaderDecodedListener);
    }

    private int computeDensity(Source src) {
        if (this.requestedResize()) {
            return 0;
        }
        int srcDensity = src.getDensity();
        if (srcDensity == 0) {
            return srcDensity;
        }
        if (this.mIsNinePatch && this.mPostProcessor == null) {
            return srcDensity;
        }
        Resources res = src.getResources();
        if (res != null && res.getDisplayMetrics().noncompatDensityDpi == srcDensity) {
            return srcDensity;
        }
        int dstDensity = src.computeDstDensity();
        if (srcDensity == dstDensity) {
            return srcDensity;
        }
        if (srcDensity < dstDensity && sApiLevel >= 28) {
            return srcDensity;
        }
        float scale = (float)dstDensity / (float)srcDensity;
        int scaledWidth = Math.max((int)((float)this.mWidth * scale + 0.5f), 1);
        int scaledHeight = Math.max((int)((float)this.mHeight * scale + 0.5f), 1);
        this.setTargetSize(scaledWidth, scaledHeight);
        return dstDensity;
    }

    private String getMimeType() {
        return ImageDecoder.nGetMimeType(this.mNativePtr);
    }

    private ColorSpace getColorSpace() {
        return ImageDecoder.nGetColorSpace(this.mNativePtr);
    }

    public static Bitmap decodeBitmap(Source src) throws IOException {
        return ImageDecoder.decodeBitmapImpl(src, null);
    }

    @UnsupportedAppUsage
    private int postProcessAndRelease(Canvas canvas) {
        try {
            int n = this.mPostProcessor.onPostProcess(canvas);
            return n;
        }
        finally {
            canvas.release();
        }
    }

    private void onPartialImage(int error, Throwable cause) throws DecodeException {
        DecodeException exception = new DecodeException(error, cause, this.mSource);
        if (this.mOnPartialImageListener == null || !this.mOnPartialImageListener.onPartialImage(exception)) {
            throw exception;
        }
    }

    private static native ImageDecoder nCreate(long var0, boolean var2, Source var3) throws IOException;

    private static native ImageDecoder nCreate(ByteBuffer var0, int var1, int var2, boolean var3, Source var4) throws IOException;

    private static native ImageDecoder nCreate(byte[] var0, int var1, int var2, boolean var3, Source var4) throws IOException;

    private static native ImageDecoder nCreate(InputStream var0, byte[] var1, boolean var2, Source var3) throws IOException;

    private static native ImageDecoder nCreate(FileDescriptor var0, boolean var1, Source var2) throws IOException;

    private static native Bitmap nDecodeBitmap(long var0, ImageDecoder var2, boolean var3, int var4, int var5, Rect var6, boolean var7, int var8, boolean var9, boolean var10, boolean var11, long var12, boolean var14) throws IOException;

    private static native Size nGetSampledSize(long var0, int var2);

    private static native void nGetPadding(long var0, Rect var2);

    private static native void nClose(long var0);

    private static native String nGetMimeType(long var0);

    private static native ColorSpace nGetColorSpace(long var0);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MemoryPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Allocator {
    }

    public static interface OnPartialImageListener {
        public boolean onPartialImage(DecodeException var1);
    }

    public static class DecodeException
    extends IOException {
        public static final int SOURCE_EXCEPTION = 1;
        public static final int SOURCE_INCOMPLETE = 2;
        public static final int SOURCE_MALFORMED_DATA = 3;
        final int mError;
        final Source mSource;

        DecodeException(int error, Throwable cause, Source source) {
            super(DecodeException.errorMessage(error, cause), cause);
            this.mError = error;
            this.mSource = source;
        }

        DecodeException(int error, String msg, Throwable cause, Source source) {
            super(msg + DecodeException.errorMessage(error, cause), cause);
            this.mError = error;
            this.mSource = source;
        }

        public int getError() {
            return this.mError;
        }

        public Source getSource() {
            return this.mSource;
        }

        private static String errorMessage(int error, Throwable cause) {
            switch (error) {
                case 1: {
                    return "Exception in input: " + cause;
                }
                case 2: {
                    return "Input was incomplete.";
                }
                case 3: {
                    return "Input contained an error.";
                }
            }
            return "";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Error {
        }
    }

    public static interface OnHeaderDecodedListener {
        public void onHeaderDecoded(ImageDecoder var1, ImageInfo var2, Source var3);
    }

    @Deprecated
    public static class IncompleteException
    extends IOException {
    }

    public static class ImageInfo {
        private final Size mSize;
        private ImageDecoder mDecoder;

        private ImageInfo(ImageDecoder decoder) {
            this.mSize = new Size(decoder.mWidth, decoder.mHeight);
            this.mDecoder = decoder;
        }

        public Size getSize() {
            return this.mSize;
        }

        public String getMimeType() {
            return this.mDecoder.getMimeType();
        }

        public boolean isAnimated() {
            return this.mDecoder.mAnimated;
        }

        public ColorSpace getColorSpace() {
            return this.mDecoder.getColorSpace();
        }
    }

    private static class CallableSource
    extends Source {
        private final Callable<AssetFileDescriptor> mCallable;

        CallableSource(Callable<AssetFileDescriptor> callable) {
            this.mCallable = callable;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            AssetFileDescriptor assetFd = null;
            try {
                assetFd = this.mCallable.call();
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            return ImageDecoder.createFromAssetFileDescriptor(assetFd, preferAnimation, this);
        }
    }

    private static class FileSource
    extends Source {
        private final File mFile;

        FileSource(File file) {
            this.mFile = file;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            return ImageDecoder.createFromFile(this.mFile, preferAnimation, this);
        }
    }

    private static class AssetSource
    extends Source {
        private final AssetManager mAssets;
        private final String mFileName;

        AssetSource(AssetManager assets, String fileName) {
            this.mAssets = assets;
            this.mFileName = fileName;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            InputStream is = this.mAssets.open(this.mFileName);
            return ImageDecoder.createFromAsset((AssetManager.AssetInputStream)is, preferAnimation, this);
        }
    }

    private static class ResourceSource
    extends Source {
        final Resources mResources;
        final int mResId;
        int mResDensity;
        private Object mLock = new Object();

        ResourceSource(Resources res, int resId) {
            this.mResources = res;
            this.mResId = resId;
            this.mResDensity = 0;
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDensity() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mResDensity;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            TypedValue value = new TypedValue();
            InputStream is = this.mResources.openRawResource(this.mResId, value);
            Object object = this.mLock;
            synchronized (object) {
                if (value.density == 0) {
                    this.mResDensity = 160;
                } else if (value.density != 65535) {
                    this.mResDensity = value.density;
                }
            }
            return ImageDecoder.createFromAsset((AssetManager.AssetInputStream)is, preferAnimation, this);
        }
    }

    public static class AssetInputStreamSource
    extends Source {
        private AssetManager.AssetInputStream mAssetInputStream;
        private final Resources mResources;
        private final int mDensity;

        public AssetInputStreamSource(AssetManager.AssetInputStream ais, Resources res, TypedValue value) {
            this.mAssetInputStream = ais;
            this.mResources = res;
            this.mDensity = value.density == 0 ? 160 : (value.density != 65535 ? value.density : 0);
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            AssetInputStreamSource assetInputStreamSource = this;
            synchronized (assetInputStreamSource) {
                if (this.mAssetInputStream == null) {
                    throw new IOException("Cannot reuse AssetInputStreamSource");
                }
                AssetManager.AssetInputStream ais = this.mAssetInputStream;
                this.mAssetInputStream = null;
                return ImageDecoder.createFromAsset(ais, preferAnimation, this);
            }
        }
    }

    public static class InputStreamSource
    extends Source {
        final Resources mResources;
        public InputStream mInputStream;
        final int mInputDensity;

        InputStreamSource(Resources res, InputStream is, int inputDensity) {
            if (is == null) {
                throw new IllegalArgumentException("The InputStream cannot be null");
            }
            this.mResources = res;
            this.mInputStream = is;
            this.mInputDensity = inputDensity;
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mInputDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            InputStreamSource inputStreamSource = this;
            synchronized (inputStreamSource) {
                if (this.mInputStream == null) {
                    throw new IOException("Cannot reuse InputStreamSource");
                }
                InputStream is = this.mInputStream;
                this.mInputStream = null;
                return ImageDecoder.createFromStream(is, false, preferAnimation, this);
            }
        }
    }

    private static class ContentResolverSource
    extends Source {
        private final ContentResolver mResolver;
        private final Uri mUri;
        private final Resources mResources;

        ContentResolverSource(ContentResolver resolver, Uri uri, Resources res) {
            this.mResolver = resolver;
            this.mUri = uri;
            this.mResources = res;
        }

        @Override
        Resources getResources() {
            return this.mResources;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            AssetFileDescriptor assetFd = null;
            try {
                assetFd = "content".equals(this.mUri.getScheme()) ? this.mResolver.openTypedAssetFileDescriptor(this.mUri, "image/*", null) : this.mResolver.openAssetFileDescriptor(this.mUri, "r");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (assetFd == null) {
                InputStream is = this.mResolver.openInputStream(this.mUri);
                if (is == null) {
                    throw new FileNotFoundException(this.mUri.toString());
                }
                return ImageDecoder.createFromStream(is, true, preferAnimation, this);
            }
            return ImageDecoder.createFromAssetFileDescriptor(assetFd, preferAnimation, this);
        }
    }

    private static class ByteBufferSource
    extends Source {
        private final ByteBuffer mBuffer;

        ByteBufferSource(ByteBuffer buffer) {
            this.mBuffer = buffer;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            if (!this.mBuffer.isDirect() && this.mBuffer.hasArray()) {
                int offset = this.mBuffer.arrayOffset() + this.mBuffer.position();
                int length = this.mBuffer.limit() - this.mBuffer.position();
                return ImageDecoder.nCreate(this.mBuffer.array(), offset, length, preferAnimation, this);
            }
            ByteBuffer buffer = this.mBuffer.slice();
            return ImageDecoder.nCreate(buffer, buffer.position(), buffer.limit(), preferAnimation, this);
        }
    }

    private static class ByteArraySource
    extends Source {
        private final byte[] mData;
        private final int mOffset;
        private final int mLength;

        ByteArraySource(byte[] data, int offset, int length) {
            this.mData = data;
            this.mOffset = offset;
            this.mLength = length;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            return ImageDecoder.nCreate(this.mData, this.mOffset, this.mLength, preferAnimation, this);
        }
    }

    public static abstract class Source {
        private Source() {
        }

        Resources getResources() {
            return null;
        }

        int getDensity() {
            return 0;
        }

        int computeDstDensity() {
            Resources res = this.getResources();
            if (res == null) {
                return Bitmap.getDefaultDensity();
            }
            return res.getDisplayMetrics().densityDpi;
        }

        abstract ImageDecoder createImageDecoder(boolean var1) throws IOException;
    }
}

