/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.app.ActivityTaskManager;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageParser;
import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.ParsingUtils;
import android.content.pm.parsing.component.ComponentParseUtils;
import android.content.pm.parsing.component.ParsedActivity;
import android.content.pm.parsing.component.ParsedComponentUtils;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.content.pm.parsing.component.ParsedMainComponentUtils;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedActivityUtils {
    private static final String TAG = "PackageParsing";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static ParseResult<ParsedActivity> parseActivityOrReceiver(String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, boolean useRoundIcon, ParseInput input) throws XmlPullParserException, IOException {
        String packageName = pkg.getPackageName();
        ParsedActivity activity = new ParsedActivity();
        boolean receiver = "receiver".equals(parser.getName());
        String tag = "<" + parser.getName() + ">";
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivity);
        try {
            ParseResult<ParsedActivity> result = ParsedMainComponentUtils.parseMainComponent(activity, tag, separateProcesses, pkg, sa, flags, useRoundIcon, input, 30, 17, 42, 5, 2, 1, 23, 3, 7, 44, 48);
            if (result.isError()) {
                ParseResult<ParsedActivity> parseResult = result;
                return parseResult;
            }
            if (receiver && pkg.isCantSaveState() && Objects.equals(activity.getProcessName(), packageName)) {
                ParseResult<ParsedActivity> parseResult = input.error("Heavy-weight applications can not have receivers in main process");
                return parseResult;
            }
            activity.theme = sa.getResourceId(0, 0);
            activity.uiOptions = sa.getInt(26, pkg.getUiOptions());
            activity.flags |= ComponentParseUtils.flag(64, 19, pkg.isAllowTaskReparenting(), sa) | ComponentParseUtils.flag(8, 18, sa) | ComponentParseUtils.flag(4, 11, sa) | ComponentParseUtils.flag(32, 13, sa) | ComponentParseUtils.flag(256, 22, sa) | ComponentParseUtils.flag(2, 10, sa) | ComponentParseUtils.flag(2048, 24, sa) | ComponentParseUtils.flag(1, 9, sa) | ComponentParseUtils.flag(128, 21, sa) | ComponentParseUtils.flag(1024, 39, sa) | ComponentParseUtils.flag(1024, 29, sa) | ComponentParseUtils.flag(16, 12, sa) | ComponentParseUtils.flag(0x20000000, 58, sa);
            if (!receiver) {
                activity.flags |= ComponentParseUtils.flag(512, 25, pkg.isBaseHardwareAccelerated(), sa) | ComponentParseUtils.flag(Integer.MIN_VALUE, 31, sa) | ComponentParseUtils.flag(262144, 57, sa) | ComponentParseUtils.flag(8192, 35, sa) | ComponentParseUtils.flag(4096, 36, sa) | ComponentParseUtils.flag(16384, 37, sa) | ComponentParseUtils.flag(0x800000, 51, sa) | ComponentParseUtils.flag(0x400000, 41, sa) | ComponentParseUtils.flag(0x1000000, 52, sa) | ComponentParseUtils.flag(0x2000000, 56, sa);
                activity.privateFlags |= ComponentParseUtils.flag(1, 54, sa);
                activity.colorMode = sa.getInt(49, 0);
                activity.documentLaunchMode = sa.getInt(33, 0);
                activity.launchMode = sa.getInt(14, 0);
                activity.lockTaskLaunchMode = sa.getInt(38, 0);
                activity.maxRecents = sa.getInt(34, ActivityTaskManager.getDefaultAppRecentsLimitStatic());
                activity.persistableMode = sa.getInteger(32, 0);
                activity.requestedVrComponent = sa.getString(43);
                activity.rotationAnimation = sa.getInt(46, -1);
                activity.softInputMode = sa.getInt(20, 0);
                activity.configChanges = PackageParser.getActivityConfigChanges(sa.getInt(16, 0), sa.getInt(47, 0));
                int screenOrientation = sa.getInt(15, -1);
                int resizeMode = ParsedActivityUtils.getActivityResizeMode(pkg, sa, screenOrientation);
                activity.screenOrientation = screenOrientation;
                activity.resizeMode = resizeMode;
                if (sa.hasValue(50) && sa.getType(50) == 4) {
                    activity.setMaxAspectRatio(resizeMode, sa.getFloat(50, 0.0f));
                }
                if (sa.hasValue(53) && sa.getType(53) == 4) {
                    activity.setMinAspectRatio(resizeMode, sa.getFloat(53, 0.0f));
                }
            } else {
                activity.launchMode = 0;
                activity.configChanges = 0;
                activity.flags |= ComponentParseUtils.flag(0x40000000, 28, sa);
            }
            String taskAffinity = sa.getNonConfigurationString(8, 1024);
            ParseResult<String> affinityNameResult = ComponentParseUtils.buildTaskAffinityName(packageName, pkg.getTaskAffinity(), taskAffinity, input);
            if (affinityNameResult.isError()) {
                ParseResult<ParsedActivity> parseResult = input.error(affinityNameResult);
                return parseResult;
            }
            activity.taskAffinity = affinityNameResult.getResult();
            boolean visibleToEphemeral = sa.getBoolean(45, false);
            if (visibleToEphemeral) {
                activity.flags |= 0x100000;
                pkg.setVisibleToInstantApps(true);
            }
            ParseResult<ParsedActivity> parseResult = ParsedActivityUtils.parseActivityOrAlias(activity, pkg, tag, parser, res, sa, receiver, false, visibleToEphemeral, input, 27, 4, 6);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<ParsedActivity> parseActivityAlias(ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean useRoundIcon, ParseInput input) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestActivityAlias);
        try {
            String tag;
            String targetActivity = sa.getNonConfigurationString(7, 1024);
            if (targetActivity == null) {
                ParseResult<ParsedActivity> parseResult = input.error("<activity-alias> does not specify android:targetActivity");
                return parseResult;
            }
            String packageName = pkg.getPackageName();
            targetActivity = ParsingUtils.buildClassName(packageName, targetActivity);
            if (targetActivity == null) {
                ParseResult<ParsedActivity> parseResult = input.error("Empty class name in package " + packageName);
                return parseResult;
            }
            ParsedActivity target = null;
            List<ParsedActivity> activities = pkg.getActivities();
            int activitiesSize = ArrayUtils.size(activities);
            for (int i = 0; i < activitiesSize; ++i) {
                ParsedActivity t = activities.get(i);
                if (!targetActivity.equals(t.getName())) continue;
                target = t;
                break;
            }
            if (target == null) {
                ParseResult<ParsedActivity> i = input.error("<activity-alias> target activity " + targetActivity + " not found in manifest with activities = " + pkg.getActivities() + ", parsedActivities = " + activities);
                return i;
            }
            ParsedActivity activity = ParsedActivity.makeAlias(targetActivity, target);
            ParseResult<ParsedActivity> result = ParsedMainComponentUtils.parseMainComponent(activity, tag = "<" + parser.getName() + ">", null, pkg, sa, 0, useRoundIcon, input, 10, 6, null, 4, 1, 0, 8, 2, null, 11, null);
            if (result.isError()) {
                ParseResult<ParsedActivity> parseResult = result;
                return parseResult;
            }
            boolean visibleToEphemeral = (activity.getFlags() & 0x100000) != 0;
            ParseResult<ParsedActivity> parseResult = ParsedActivityUtils.parseActivityOrAlias(activity, pkg, tag, parser, res, sa, false, true, visibleToEphemeral, input, 9, 3, 5);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static ParseResult<ParsedActivity> parseActivityOrAlias(ParsedActivity activity, ParsingPackage pkg, String tag, XmlResourceParser parser, Resources resources, TypedArray array2, boolean isReceiver, boolean isAlias, boolean visibleToEphemeral, ParseInput input, int parentActivityNameAttr, int permissionAttr, int exportedAttr) throws IOException, XmlPullParserException {
        int type;
        String parentActivityName = array2.getNonConfigurationString(parentActivityNameAttr, 1024);
        if (parentActivityName != null) {
            String packageName = pkg.getPackageName();
            String parentClassName = ParsingUtils.buildClassName(packageName, parentActivityName);
            if (parentClassName == null) {
                Log.e(TAG, "Activity " + activity.getName() + " specified invalid parentActivityName " + parentActivityName);
            } else {
                activity.setParentActivity(parentClassName);
            }
        }
        String permission2 = array2.getNonConfigurationString(permissionAttr, 0);
        if (isAlias) {
            activity.setPermission(permission2);
        } else {
            activity.setPermission(permission2 != null ? permission2 : pkg.getPermission());
        }
        boolean setExported = array2.hasValue(exportedAttr);
        if (setExported) {
            activity.exported = array2.getBoolean(exportedAttr, false);
        }
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Object> result;
            ParsedIntentInfo intent;
            ParseResult<ParsedIntentInfo> intentResult;
            if (type != 2) continue;
            if (parser.getName().equals("intent-filter")) {
                intentResult = ParsedActivityUtils.parseIntentFilter(pkg, activity, !isReceiver, visibleToEphemeral, resources, parser, input);
                if (intentResult.isSuccess() && (intent = intentResult.getResult()) != null) {
                    activity.order = Math.max(intent.getOrder(), activity.order);
                    activity.addIntent(intent);
                }
                result = intentResult;
            } else if (parser.getName().equals("meta-data")) {
                result = ParsedComponentUtils.addMetaData(activity, pkg, resources, parser, input);
            } else if (!isReceiver && !isAlias && parser.getName().equals("preferred")) {
                intentResult = ParsedActivityUtils.parseIntentFilter(pkg, activity, true, visibleToEphemeral, resources, parser, input);
                if (intentResult.isSuccess() && (intent = intentResult.getResult()) != null) {
                    pkg.addPreferredActivityFilter(activity.getClassName(), intent);
                }
                result = intentResult;
            } else if (!isReceiver && !isAlias && parser.getName().equals("layout")) {
                ParseResult<ActivityInfo.WindowLayout> layoutResult = ParsedActivityUtils.parseLayout(resources, parser, input);
                if (layoutResult.isSuccess()) {
                    activity.windowLayout = layoutResult.getResult();
                }
                result = layoutResult;
            } else {
                result = ParsingUtils.unknownTag(tag, pkg, parser, input);
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        ParseResult<ActivityInfo.WindowLayout> layoutResult = ParsedActivityUtils.resolveWindowLayout(activity, input);
        if (layoutResult.isError()) {
            return input.error(layoutResult);
        }
        activity.windowLayout = layoutResult.getResult();
        if (!setExported) {
            activity.exported = activity.getIntents().size() > 0;
        }
        return input.success(activity);
    }

    private static ParseResult<ParsedIntentInfo> parseIntentFilter(ParsingPackage pkg, ParsedActivity activity, boolean allowImplicitEphemeralVisibility, boolean visibleToEphemeral, Resources resources, XmlResourceParser parser, ParseInput input) throws IOException, XmlPullParserException {
        ParseResult<ParsedIntentInfo> result = ParsedMainComponentUtils.parseIntentFilter(activity, pkg, resources, parser, visibleToEphemeral, true, true, allowImplicitEphemeralVisibility, true, input);
        if (result.isError()) {
            return input.error(result);
        }
        ParsedIntentInfo intent = result.getResult();
        if (intent != null) {
            if (intent.isVisibleToInstantApp()) {
                activity.flags |= 0x100000;
            }
            if (intent.isImplicitlyVisibleToInstantApp()) {
                activity.flags |= 0x200000;
            }
        }
        return input.success(intent);
    }

    private static int getActivityResizeMode(ParsingPackage pkg, TypedArray sa, int screenOrientation) {
        Boolean resizeableActivity = pkg.getResizeableActivity();
        if (sa.hasValue(40) || resizeableActivity != null) {
            if (sa.getBoolean(40, resizeableActivity != null && resizeableActivity != false)) {
                return 2;
            }
            return 0;
        }
        if (pkg.isResizeableActivityViaSdkVersion()) {
            return 1;
        }
        if (ActivityInfo.isFixedOrientationPortrait(screenOrientation)) {
            return 6;
        }
        if (ActivityInfo.isFixedOrientationLandscape(screenOrientation)) {
            return 5;
        }
        if (screenOrientation == 14) {
            return 7;
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ActivityInfo.WindowLayout> parseLayout(Resources res, AttributeSet attrs, ParseInput input) {
        TypedArray sw = res.obtainAttributes(attrs, R.styleable.AndroidManifestLayout);
        try {
            int width = -1;
            float widthFraction = -1.0f;
            int height = -1;
            float heightFraction = -1.0f;
            int widthType = sw.getType(3);
            if (widthType == 6) {
                widthFraction = sw.getFraction(3, 1, 1, -1.0f);
            } else if (widthType == 5) {
                width = sw.getDimensionPixelSize(3, -1);
            }
            int heightType = sw.getType(4);
            if (heightType == 6) {
                heightFraction = sw.getFraction(4, 1, 1, -1.0f);
            } else if (heightType == 5) {
                height = sw.getDimensionPixelSize(4, -1);
            }
            int gravity = sw.getInt(0, 17);
            int minWidth = sw.getDimensionPixelSize(1, -1);
            int minHeight = sw.getDimensionPixelSize(2, -1);
            ParseResult<ActivityInfo.WindowLayout> parseResult = input.success(new ActivityInfo.WindowLayout(width, widthFraction, height, heightFraction, gravity, minWidth, minHeight));
            return parseResult;
        }
        finally {
            sw.recycle();
        }
    }

    private static ParseResult<ActivityInfo.WindowLayout> resolveWindowLayout(ParsedActivity activity, ParseInput input) {
        if (activity.metaData == null || !activity.metaData.containsKey("android.activity_window_layout_affinity")) {
            return input.success(activity.windowLayout);
        }
        if (activity.windowLayout != null && activity.windowLayout.windowLayoutAffinity != null) {
            return input.success(activity.windowLayout);
        }
        String windowLayoutAffinity = activity.metaData.getString("android.activity_window_layout_affinity");
        ActivityInfo.WindowLayout layout2 = activity.windowLayout;
        if (layout2 == null) {
            layout2 = new ActivityInfo.WindowLayout(-1, -1.0f, -1, -1.0f, 0, -1, -1);
        }
        layout2.windowLayoutAffinity = windowLayoutAffinity;
        return input.success(layout2);
    }
}

