/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezone;

import android.app.timezone.Callback;
import android.app.timezone.ICallback;
import android.app.timezone.IRulesManager;
import android.app.timezone.RulesState;
import android.content.Context;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public class RulesManager {
    private static final String TAG = "timezone.RulesManager";
    private static final boolean DEBUG = false;
    public static final String ACTION_RULES_UPDATE_OPERATION = "com.android.intent.action.timezone.RULES_UPDATE_OPERATION";
    public static final String EXTRA_OPERATION_STAGED = "staged";
    public static final int SUCCESS = 0;
    public static final int ERROR_OPERATION_IN_PROGRESS = 1;
    public static final int ERROR_UNKNOWN_FAILURE = 2;
    private final Context mContext;
    private final IRulesManager mIRulesManager;

    public RulesManager(Context context) {
        this.mContext = context;
        this.mIRulesManager = IRulesManager.Stub.asInterface(ServiceManager.getService("timezone"));
    }

    public RulesState getRulesState() {
        try {
            RulesManager.logDebug("mIRulesManager.getRulesState()");
            RulesState rulesState = this.mIRulesManager.getRulesState();
            RulesManager.logDebug("mIRulesManager.getRulesState() returned " + rulesState);
            return rulesState;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int requestInstall(ParcelFileDescriptor distroFileDescriptor, byte[] checkToken, Callback callback) throws IOException {
        CallbackWrapper iCallback = new CallbackWrapper(this.mContext, callback);
        try {
            RulesManager.logDebug("mIRulesManager.requestInstall()");
            return this.mIRulesManager.requestInstall(distroFileDescriptor, checkToken, iCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int requestUninstall(byte[] checkToken, Callback callback) {
        CallbackWrapper iCallback = new CallbackWrapper(this.mContext, callback);
        try {
            RulesManager.logDebug("mIRulesManager.requestUninstall()");
            return this.mIRulesManager.requestUninstall(checkToken, iCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestNothing(byte[] checkToken, boolean succeeded) {
        try {
            RulesManager.logDebug("mIRulesManager.requestNothing() with token=" + Arrays.toString(checkToken));
            this.mIRulesManager.requestNothing(checkToken, succeeded);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void logDebug(String msg) {
    }

    private class CallbackWrapper
    extends ICallback.Stub {
        final Handler mHandler;
        final Callback mCallback;

        CallbackWrapper(Context context, Callback callback) {
            this.mCallback = callback;
            this.mHandler = new Handler(context.getMainLooper());
        }

        @Override
        public void onFinished(int status) {
            RulesManager.logDebug("mCallback.onFinished(status), status=" + status);
            this.mHandler.post(() -> this.mCallback.onFinished(status));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResultCode {
    }
}

