/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ApplicationPackageManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ApplicationInfo;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.CompatResources;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.ResourcesKey;
import android.content.res.loader.ResourcesLoader;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.os.Process;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LruCache;
import android.util.Pair;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayAdjustments;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;

public class ResourcesManager {
    static final String TAG = "ResourcesManager";
    private static final boolean DEBUG = false;
    private static ResourcesManager sResourcesManager;
    private CompatibilityInfo mResCompatibilityInfo;
    @UnsupportedAppUsage
    private final Configuration mResConfiguration = new Configuration();
    @UnsupportedAppUsage
    private final ArrayMap<ResourcesKey, WeakReference<ResourcesImpl>> mResourceImpls = new ArrayMap();
    @UnsupportedAppUsage
    private final ArrayList<WeakReference<Resources>> mResourceReferences = new ArrayList();
    private final ReferenceQueue<Resources> mResourcesReferencesQueue = new ReferenceQueue();
    private static final boolean ENABLE_APK_ASSETS_CACHE = false;
    private final LruCache<ApkKey, ApkAssets> mLoadedApkAssets = null;
    private final ArrayMap<ApkKey, WeakReference<ApkAssets>> mCachedApkAssets = new ArrayMap();
    @UnsupportedAppUsage
    private final WeakHashMap<IBinder, ActivityResources> mActivityResourceReferences = new WeakHashMap();
    private final ArrayMap<Pair<Integer, DisplayAdjustments>, WeakReference<Display>> mAdjustedDisplays = new ArrayMap();
    private final UpdateHandler mUpdateCallbacks = new UpdateHandler();

    @UnsupportedAppUsage
    public ResourcesManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static ResourcesManager getInstance() {
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            if (sResourcesManager == null) {
                sResourcesManager = new ResourcesManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResourcesManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePath(String path) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            Object key;
            int i;
            int count = 0;
            for (i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                key = this.mResourceImpls.keyAt(i);
                if (!((ResourcesKey)key).isPathReferenced(path)) continue;
                ResourcesImpl impl = (ResourcesImpl)this.mResourceImpls.removeAt(i).get();
                if (impl != null) {
                    impl.flushLayoutCache();
                }
                ++count;
            }
            Log.i(TAG, "Invalidated " + count + " asset managers that referenced " + path);
            for (i = this.mCachedApkAssets.size() - 1; i >= 0; --i) {
                WeakReference<ApkAssets> apkAssetsRef;
                key = this.mCachedApkAssets.keyAt(i);
                if (!((ApkKey)key).path.equals(path) || (apkAssetsRef = this.mCachedApkAssets.removeAt(i)) == null || apkAssetsRef.get() == null) continue;
                ((ApkAssets)apkAssetsRef.get()).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration() {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            return this.mResConfiguration;
        }
    }

    DisplayMetrics getDisplayMetrics() {
        return this.getDisplayMetrics(0, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    @VisibleForTesting
    protected DisplayMetrics getDisplayMetrics(int displayId, DisplayAdjustments da) {
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getAdjustedDisplay(displayId, da);
        if (display != null) {
            display.getMetrics(dm);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private static void applyNonDefaultDisplayMetricsToConfiguration(DisplayMetrics dm, Configuration config) {
        config.touchscreen = 1;
        config.densityDpi = dm.densityDpi;
        config.screenWidthDp = (int)((float)dm.widthPixels / dm.density);
        config.screenHeightDp = (int)((float)dm.heightPixels / dm.density);
        int sl = Configuration.resetScreenLayout(config.screenLayout);
        if (dm.widthPixels > dm.heightPixels) {
            config.orientation = 2;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenWidthDp, config.screenHeightDp);
        } else {
            config.orientation = 1;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenHeightDp, config.screenWidthDp);
        }
        config.smallestScreenWidthDp = Math.min(config.screenWidthDp, config.screenHeightDp);
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        config.compatSmallestScreenWidthDp = config.smallestScreenWidthDp;
    }

    public boolean applyCompatConfigurationLocked(int displayDensity, Configuration compatConfiguration) {
        if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
            this.mResCompatibilityInfo.applyToConfiguration(displayDensity, compatConfiguration);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Display getAdjustedDisplay(int displayId, DisplayAdjustments displayAdjustments) {
        DisplayAdjustments displayAdjustmentsCopy = displayAdjustments != null ? new DisplayAdjustments(displayAdjustments) : new DisplayAdjustments();
        Pair<Integer, DisplayAdjustments> key = Pair.create(displayId, displayAdjustmentsCopy);
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            Display display;
            WeakReference<Display> wd = this.mAdjustedDisplays.get(key);
            if (wd != null && (display = (Display)wd.get()) != null) {
                return display;
            }
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            Display display2 = dm.getCompatibleDisplay(displayId, (DisplayAdjustments)key.second);
            if (display2 != null) {
                this.mAdjustedDisplays.put(key, new WeakReference<Display>(display2));
            }
            return display2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Display getAdjustedDisplay(int displayId, Resources resources) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            return dm.getCompatibleDisplay(displayId, resources);
        }
    }

    private static String overlayPathToIdmapPath(String path) {
        return "/data/resource-cache/" + path.substring(1).replace('/', '@') + "@idmap";
    }

    private ApkAssets loadApkAssets(String path, boolean sharedLib, boolean overlay) throws IOException {
        ApkKey newKey = new ApkKey(path, sharedLib, overlay);
        ApkAssets apkAssets = null;
        if (this.mLoadedApkAssets != null && (apkAssets = this.mLoadedApkAssets.get(newKey)) != null && apkAssets.isUpToDate()) {
            return apkAssets;
        }
        WeakReference<ApkAssets> apkAssetsRef = this.mCachedApkAssets.get(newKey);
        if (apkAssetsRef != null) {
            apkAssets = (ApkAssets)apkAssetsRef.get();
            if (apkAssets != null && apkAssets.isUpToDate()) {
                if (this.mLoadedApkAssets != null) {
                    this.mLoadedApkAssets.put(newKey, apkAssets);
                }
                return apkAssets;
            }
            this.mCachedApkAssets.remove(newKey);
        }
        apkAssets = overlay ? ApkAssets.loadOverlayFromPath(ResourcesManager.overlayPathToIdmapPath(path), 0) : ApkAssets.loadFromPath(path, sharedLib ? 2 : 0);
        if (this.mLoadedApkAssets != null) {
            this.mLoadedApkAssets.put(newKey, apkAssets);
        }
        this.mCachedApkAssets.put(newKey, new WeakReference<ApkAssets>(apkAssets));
        return apkAssets;
    }

    @VisibleForTesting
    @UnsupportedAppUsage
    protected AssetManager createAssetManager(ResourcesKey key) {
        AssetManager.Builder builder = new AssetManager.Builder();
        if (key.mResDir != null) {
            try {
                builder.addApkAssets(this.loadApkAssets(key.mResDir, false, false));
            }
            catch (IOException e) {
                Log.e(TAG, "failed to add asset path " + key.mResDir);
                return null;
            }
        }
        if (key.mSplitResDirs != null) {
            for (String splitResDir : key.mSplitResDirs) {
                try {
                    builder.addApkAssets(this.loadApkAssets(splitResDir, false, false));
                }
                catch (IOException e) {
                    Log.e(TAG, "failed to add split asset path " + splitResDir);
                    return null;
                }
            }
        }
        if (key.mLibDirs != null) {
            for (String libDir : key.mLibDirs) {
                if (!libDir.endsWith(".apk")) continue;
                try {
                    builder.addApkAssets(this.loadApkAssets(libDir, true, false));
                }
                catch (IOException e) {
                    Log.w(TAG, "Asset path '" + (String)libDir + "' does not exist or contains no resources.");
                }
            }
        }
        if (key.mOverlayDirs != null) {
            for (String idmapPath : key.mOverlayDirs) {
                try {
                    builder.addApkAssets(this.loadApkAssets(idmapPath, false, true));
                }
                catch (IOException e) {
                    Log.w(TAG, "failed to add overlay path " + (String)idmapPath);
                }
            }
        }
        if (key.mLoaders != null) {
            for (ResourcesLoader loader : key.mLoaders) {
                builder.addLoader(loader);
            }
        }
        return builder.build();
    }

    private static <T> int countLiveReferences(Collection<WeakReference<T>> collection) {
        int count = 0;
        for (WeakReference<T> ref : collection) {
            Object value = ref != null ? ref.get() : null;
            if (value == null) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter printWriter) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
            for (int i = 0; i < prefix.length() / 2; ++i) {
                pw.increaseIndent();
            }
            pw.println("ResourcesManager:");
            pw.increaseIndent();
            if (this.mLoadedApkAssets != null) {
                pw.print("cached apks: total=");
                pw.print(this.mLoadedApkAssets.size());
                pw.print(" created=");
                pw.print(this.mLoadedApkAssets.createCount());
                pw.print(" evicted=");
                pw.print(this.mLoadedApkAssets.evictionCount());
                pw.print(" hit=");
                pw.print(this.mLoadedApkAssets.hitCount());
                pw.print(" miss=");
                pw.print(this.mLoadedApkAssets.missCount());
                pw.print(" max=");
                pw.print(this.mLoadedApkAssets.maxSize());
            } else {
                pw.print("cached apks: 0 [cache disabled]");
            }
            pw.println();
            pw.print("total apks: ");
            pw.println(ResourcesManager.countLiveReferences(this.mCachedApkAssets.values()));
            pw.print("resources: ");
            int references = ResourcesManager.countLiveReferences(this.mResourceReferences);
            for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
                references += ResourcesManager.countLiveReferences(activityResources.activityResources);
            }
            pw.println(references);
            pw.print("resource impls: ");
            pw.println(ResourcesManager.countLiveReferences(this.mResourceImpls.values()));
        }
    }

    private Configuration generateConfig(ResourcesKey key, DisplayMetrics dm) {
        Configuration config;
        boolean isDefaultDisplay = key.mDisplayId == 0;
        boolean hasOverrideConfig = key.hasOverrideConfiguration();
        if (!isDefaultDisplay || hasOverrideConfig) {
            config = new Configuration(this.getConfiguration());
            if (!isDefaultDisplay) {
                ResourcesManager.applyNonDefaultDisplayMetricsToConfiguration(dm, config);
            }
            if (hasOverrideConfig) {
                config.updateFrom(key.mOverrideConfiguration);
            }
        } else {
            config = this.getConfiguration();
        }
        return config;
    }

    private ResourcesImpl createResourcesImpl(ResourcesKey key) {
        DisplayAdjustments daj = new DisplayAdjustments(key.mOverrideConfiguration);
        daj.setCompatibilityInfo(key.mCompatInfo);
        AssetManager assets = this.createAssetManager(key);
        if (assets == null) {
            return null;
        }
        DisplayMetrics dm = this.getDisplayMetrics(key.mDisplayId, daj);
        Configuration config = this.generateConfig(key, dm);
        ResourcesImpl impl = new ResourcesImpl(assets, dm, config, daj);
        return impl;
    }

    private ResourcesImpl findResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl;
        WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.get(key);
        ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
        if (impl != null && impl.getAssets().isUpToDate()) {
            return impl;
        }
        return null;
    }

    private ResourcesImpl findOrCreateResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl = this.findResourcesImplForKeyLocked(key);
        if (impl == null && (impl = this.createResourcesImpl(key)) != null) {
            this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(impl));
        }
        return impl;
    }

    private ResourcesKey findKeyForResourceImplLocked(ResourcesImpl resourceImpl) {
        int refCount = this.mResourceImpls.size();
        for (int i = 0; i < refCount; ++i) {
            ResourcesImpl impl;
            WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
            ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
            if (resourceImpl != impl) continue;
            return this.mResourceImpls.keyAt(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSameResourcesOverrideConfig(IBinder activityToken, Configuration overrideConfig) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ActivityResources activityResources;
            ActivityResources activityResources2 = activityResources = activityToken != null ? this.mActivityResourceReferences.get(activityToken) : null;
            if (activityResources == null) {
                return overrideConfig == null;
            }
            return Objects.equals(activityResources.overrideConfig, overrideConfig) || overrideConfig != null && activityResources.overrideConfig != null && 0 == overrideConfig.diffPublicOnly(activityResources.overrideConfig);
        }
    }

    private ActivityResources getOrCreateActivityResourcesStructLocked(IBinder activityToken) {
        ActivityResources activityResources = this.mActivityResourceReferences.get(activityToken);
        if (activityResources == null) {
            activityResources = new ActivityResources();
            this.mActivityResourceReferences.put(activityToken, activityResources);
        }
        return activityResources;
    }

    private Resources findResourcesForActivityLocked(IBinder targetActivityToken, ResourcesKey targetKey, ClassLoader targetClassLoader) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(targetActivityToken);
        int size = activityResources.activityResources.size();
        for (int index = 0; index < size; ++index) {
            ResourcesKey key;
            WeakReference<Resources> ref = activityResources.activityResources.get(index);
            Resources resources = (Resources)ref.get();
            ResourcesKey resourcesKey = key = resources == null ? null : this.findKeyForResourceImplLocked(resources.getImpl());
            if (key == null || !Objects.equals(resources.getClassLoader(), targetClassLoader) || !Objects.equals(key, targetKey)) continue;
            return resources;
        }
        return null;
    }

    private Resources createResourcesForActivityLocked(IBinder activityToken, ClassLoader classLoader, ResourcesImpl impl, CompatibilityInfo compatInfo) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
        ResourcesManager.cleanupReferences(activityResources.activityResources, activityResources.activityResourcesQueue);
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        resources.setCallbacks(this.mUpdateCallbacks);
        activityResources.activityResources.add(new WeakReference<Resources>(resources, activityResources.activityResourcesQueue));
        return resources;
    }

    private Resources createResourcesLocked(ClassLoader classLoader, ResourcesImpl impl, CompatibilityInfo compatInfo) {
        ResourcesManager.cleanupReferences(this.mResourceReferences, this.mResourcesReferencesQueue);
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        resources.setCallbacks(this.mUpdateCallbacks);
        this.mResourceReferences.add(new WeakReference<Resources>(resources, this.mResourcesReferencesQueue));
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Resources createBaseTokenResources(IBinder token, String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader, List<ResourcesLoader> loaders) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#createBaseActivityResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfig != null ? new Configuration(overrideConfig) : null, compatInfo, loaders == null ? null : loaders.toArray(new ResourcesLoader[0]));
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Object object = this;
            synchronized (object) {
                this.getOrCreateActivityResourcesStructLocked(token);
            }
            this.updateResourcesForActivity(token, overrideConfig, displayId, false);
            this.rebaseKeyForActivity(token, key);
            object = this;
            synchronized (object) {
                Resources resources = this.findResourcesForActivityLocked(token, key, classLoader);
                if (resources != null) {
                    Resources resources2 = resources;
                    return resources2;
                }
            }
            object = this.createResources(token, key, classLoader);
            return object;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebaseKeyForActivity(IBinder activityToken, ResourcesKey key) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
            if (key.hasOverrideConfiguration() && !activityResources.overrideConfig.equals(Configuration.EMPTY)) {
                Configuration temp = new Configuration(activityResources.overrideConfig);
                temp.updateFrom(key.mOverrideConfiguration);
                key.mOverrideConfiguration.setTo(temp);
            }
        }
    }

    private static <T> void cleanupReferences(ArrayList<WeakReference<T>> references, ReferenceQueue<T> referenceQueue) {
        Reference<T> enduedRef = referenceQueue.poll();
        if (enduedRef == null) {
            return;
        }
        HashSet deadReferences = new HashSet();
        while (enduedRef != null) {
            deadReferences.add(enduedRef);
            enduedRef = referenceQueue.poll();
        }
        ArrayUtils.unstableRemoveIf(references, ref -> ref == null || deadReferences.contains(ref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resources createResources(IBinder activityToken, ResourcesKey key, ClassLoader classLoader) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ResourcesImpl resourcesImpl = this.findOrCreateResourcesImplForKeyLocked(key);
            if (resourcesImpl == null) {
                return null;
            }
            if (activityToken != null) {
                return this.createResourcesForActivityLocked(activityToken, classLoader, resourcesImpl, key.mCompatInfo);
            }
            return this.createResourcesLocked(classLoader, resourcesImpl, key.mCompatInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resources getResources(IBinder activityToken, String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader, List<ResourcesLoader> loaders) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#getResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfig != null ? new Configuration(overrideConfig) : null, compatInfo, loaders == null ? null : loaders.toArray(new ResourcesLoader[0]));
            ClassLoader classLoader2 = classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            if (activityToken != null) {
                this.rebaseKeyForActivity(activityToken, key);
            }
            Resources resources = this.createResources(activityToken, key, classLoader);
            return resources;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResourcesForActivity(IBinder activityToken, Configuration overrideConfig, int displayId, boolean movedToDifferentDisplay) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#updateResourcesForActivity");
            ResourcesManager resourcesManager = this;
            synchronized (resourcesManager) {
                ActivityResources activityResources;
                block11: {
                    activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                    if (!Objects.equals(activityResources.overrideConfig, overrideConfig) || movedToDifferentDisplay) break block11;
                    return;
                }
                Configuration oldConfig = new Configuration(activityResources.overrideConfig);
                if (overrideConfig != null) {
                    activityResources.overrideConfig.setTo(overrideConfig);
                } else {
                    activityResources.overrideConfig.unset();
                }
                int refCount = activityResources.activityResources.size();
                for (int i = 0; i < refCount; ++i) {
                    ResourcesKey newKey;
                    WeakReference<Resources> weakResRef = activityResources.activityResources.get(i);
                    Resources resources = (Resources)weakResRef.get();
                    if (resources == null || (newKey = this.rebaseActivityOverrideConfig(resources, oldConfig, overrideConfig, displayId)) == null) continue;
                    this.updateActivityResources(resources, newKey, false);
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private ResourcesKey rebaseActivityOverrideConfig(Resources resources, Configuration oldOverrideConfig, Configuration newOverrideConfig, int displayId) {
        boolean hadOverrideConfig;
        ResourcesKey oldKey = this.findKeyForResourceImplLocked(resources.getImpl());
        if (oldKey == null) {
            Slog.e(TAG, "can't find ResourcesKey for resources impl=" + resources.getImpl());
            return null;
        }
        Configuration rebasedOverrideConfig = new Configuration();
        if (newOverrideConfig != null) {
            rebasedOverrideConfig.setTo(newOverrideConfig);
        }
        boolean bl = hadOverrideConfig = !oldOverrideConfig.equals(Configuration.EMPTY);
        if (hadOverrideConfig && oldKey.hasOverrideConfiguration()) {
            Configuration overrideOverrideConfig = Configuration.generateDelta(oldOverrideConfig, oldKey.mOverrideConfiguration);
            rebasedOverrideConfig.updateFrom(overrideOverrideConfig);
        }
        ResourcesKey newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayDirs, oldKey.mLibDirs, displayId, rebasedOverrideConfig, oldKey.mCompatInfo, oldKey.mLoaders);
        return newKey;
    }

    private void updateActivityResources(Resources resources, ResourcesKey newKey, boolean hasLoader) {
        ResourcesImpl resourcesImpl = hasLoader ? this.createResourcesImpl(newKey) : this.findOrCreateResourcesImplForKeyLocked(newKey);
        if (resourcesImpl != null && resourcesImpl != resources.getImpl()) {
            resources.setImpl(resourcesImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyConfigurationToResources(Configuration config, CompatibilityInfo compat) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            return this.applyConfigurationToResourcesLocked(config, compat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyConfigurationToResourcesLocked");
            if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
                boolean bl = false;
                return bl;
            }
            int changes = this.mResConfiguration.updateFrom(config);
            this.mAdjustedDisplays.clear();
            DisplayMetrics defaultDisplayMetrics = this.getDisplayMetrics();
            if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
                this.mResCompatibilityInfo = compat;
                changes |= 0xD00;
            }
            Resources.updateSystemConfiguration(config, defaultDisplayMetrics, compat);
            ApplicationPackageManager.configurationChanged();
            Configuration tmpConfig = new Configuration();
            for (int i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                ResourcesImpl r;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = r = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (r != null) {
                    this.applyConfigurationToResourcesLocked(config, compat, tmpConfig, key, r);
                    continue;
                }
                this.mResourceImpls.removeAt(i);
            }
            boolean bl = changes != 0;
            return bl;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private void applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat, Configuration tmpConfig, ResourcesKey key, ResourcesImpl resourcesImpl) {
        int displayId;
        tmpConfig.setTo(config);
        boolean hasOverrideConfiguration = key.hasOverrideConfiguration();
        if (hasOverrideConfiguration) {
            tmpConfig.updateFrom(key.mOverrideConfiguration);
        }
        DisplayAdjustments daj = resourcesImpl.getDisplayAdjustments();
        if (compat != null) {
            daj = new DisplayAdjustments(daj);
            daj.setCompatibilityInfo(compat);
        }
        if ((displayId = key.mDisplayId) == 0) {
            daj.setConfiguration(tmpConfig);
        }
        DisplayMetrics dm = this.getDisplayMetrics(displayId, daj);
        if (displayId != 0) {
            ResourcesManager.applyNonDefaultDisplayMetricsToConfiguration(dm, tmpConfig);
            if (hasOverrideConfiguration) {
                tmpConfig.updateFrom(key.mOverrideConfiguration);
            }
        }
        resourcesImpl.updateConfiguration(tmpConfig, dm, compat);
    }

    @UnsupportedAppUsage
    public void appendLibAssetForMainAssetPath(String assetPath, String libAsset) {
        this.appendLibAssetsForMainAssetPath(assetPath, new String[]{libAsset});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLibAssetsForMainAssetPath(String assetPath, String[] libAssets) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || !Objects.equals(key.mResDir, assetPath)) continue;
                Object[] newLibAssets = key.mLibDirs;
                for (String libAsset : libAssets) {
                    newLibAssets = ArrayUtils.appendElement(String.class, newLibAssets, libAsset);
                }
                if (Arrays.equals(newLibAssets, key.mLibDirs)) continue;
                updatedResourceKeys.put(impl, new ResourcesKey(key.mResDir, key.mSplitResDirs, key.mOverlayDirs, (String[])newLibAssets, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo, key.mLoaders));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyNewResourceDirsLocked(ApplicationInfo appInfo, String[] oldPaths) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyNewResourceDirsLocked");
            String baseCodePath = appInfo.getBaseCodePath();
            int myUid = Process.myUid();
            String[] newSplitDirs = appInfo.uid == myUid ? appInfo.splitSourceDirs : appInfo.splitPublicSourceDirs;
            String[] copiedSplitDirs = ArrayUtils.cloneOrNull(newSplitDirs);
            String[] copiedResourceDirs = ArrayUtils.cloneOrNull(appInfo.resourceDirs);
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || key.mResDir != null && !key.mResDir.equals(baseCodePath) && !ArrayUtils.contains(oldPaths, key.mResDir)) continue;
                updatedResourceKeys.put(impl, new ResourcesKey(baseCodePath, copiedSplitDirs, copiedResourceDirs, key.mLibDirs, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo, key.mLoaders));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private void redirectResourcesToNewImplLocked(ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys) {
        if (updatedResourceKeys.isEmpty()) {
            return;
        }
        int resourcesCount = this.mResourceReferences.size();
        for (int i = 0; i < resourcesCount; ++i) {
            ResourcesKey key;
            Resources r;
            WeakReference<Resources> ref = this.mResourceReferences.get(i);
            Resources resources = r = ref != null ? (Resources)ref.get() : null;
            if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
            ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
            if (impl == null) {
                throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
            }
            r.setImpl(impl);
        }
        for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
            int resCount = activityResources.activityResources.size();
            for (int i = 0; i < resCount; ++i) {
                ResourcesKey key;
                Resources r;
                WeakReference<Resources> ref = activityResources.activityResources.get(i);
                Resources resources = r = ref != null ? (Resources)ref.get() : null;
                if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
                ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
                if (impl == null) {
                    throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
                }
                r.setImpl(impl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean overrideTokenDisplayAdjustments(IBinder token, Consumer<DisplayAdjustments> override) {
        boolean handled = false;
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ActivityResources tokenResources = this.mActivityResourceReferences.get(token);
            if (tokenResources == null) {
                return false;
            }
            ArrayList<WeakReference<Resources>> resourcesRefs = tokenResources.activityResources;
            for (int i = resourcesRefs.size() - 1; i >= 0; --i) {
                Resources res = (Resources)resourcesRefs.get(i).get();
                if (res == null) continue;
                res.overrideDisplayAdjustments(override);
                handled = true;
            }
        }
        return handled;
    }

    private class UpdateHandler
    implements Resources.UpdateCallbacks {
        private UpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoadersChanged(Resources resources, List<ResourcesLoader> newLoader) {
            ResourcesManager resourcesManager = ResourcesManager.this;
            synchronized (resourcesManager) {
                ResourcesKey oldKey = ResourcesManager.this.findKeyForResourceImplLocked(resources.getImpl());
                if (oldKey == null) {
                    throw new IllegalArgumentException("Cannot modify resource loaders of ResourcesImpl not registered with ResourcesManager");
                }
                ResourcesKey newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayDirs, oldKey.mLibDirs, oldKey.mDisplayId, oldKey.mOverrideConfiguration, oldKey.mCompatInfo, newLoader.toArray(new ResourcesLoader[0]));
                ResourcesImpl impl = ResourcesManager.this.findOrCreateResourcesImplForKeyLocked(newKey);
                resources.setImpl(impl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLoaderUpdated(ResourcesLoader loader) {
            ResourcesManager resourcesManager = ResourcesManager.this;
            synchronized (resourcesManager) {
                ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceImplKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
                for (int i = ResourcesManager.this.mResourceImpls.size() - 1; i >= 0; --i) {
                    ResourcesKey key = (ResourcesKey)ResourcesManager.this.mResourceImpls.keyAt(i);
                    WeakReference impl = (WeakReference)ResourcesManager.this.mResourceImpls.valueAt(i);
                    if (impl == null || impl.get() == null || !ArrayUtils.contains(key.mLoaders, loader)) continue;
                    ResourcesManager.this.mResourceImpls.remove(key);
                    updatedResourceImplKeys.put((ResourcesImpl)impl.get(), key);
                }
                ResourcesManager.this.redirectResourcesToNewImplLocked(updatedResourceImplKeys);
            }
        }
    }

    private static class ActivityResources {
        public final Configuration overrideConfig = new Configuration();
        public final ArrayList<WeakReference<Resources>> activityResources = new ArrayList();
        final ReferenceQueue<Resources> activityResourcesQueue = new ReferenceQueue();

        @UnsupportedAppUsage
        private ActivityResources() {
        }
    }

    private static class ApkKey {
        public final String path;
        public final boolean sharedLib;
        public final boolean overlay;

        ApkKey(String path, boolean sharedLib, boolean overlay) {
            this.path = path;
            this.sharedLib = sharedLib;
            this.overlay = overlay;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + Boolean.hashCode(this.sharedLib);
            result = 31 * result + Boolean.hashCode(this.overlay);
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ApkKey)) {
                return false;
            }
            ApkKey other = (ApkKey)obj;
            return this.path.equals(other.path) && this.sharedLib == other.sharedLib && this.overlay == other.overlay;
        }
    }
}

