/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class AccessibilityGestureEvent
implements Parcelable {
    private final int mGestureId;
    private final int mDisplayId;
    public static final Parcelable.Creator<AccessibilityGestureEvent> CREATOR = new Parcelable.Creator<AccessibilityGestureEvent>(){

        @Override
        public AccessibilityGestureEvent createFromParcel(Parcel parcel) {
            return new AccessibilityGestureEvent(parcel);
        }

        public AccessibilityGestureEvent[] newArray(int size) {
            return new AccessibilityGestureEvent[size];
        }
    };

    public AccessibilityGestureEvent(int gestureId, int displayId) {
        this.mGestureId = gestureId;
        this.mDisplayId = displayId;
    }

    private AccessibilityGestureEvent(Parcel parcel) {
        this.mGestureId = parcel.readInt();
        this.mDisplayId = parcel.readInt();
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    public int getGestureId() {
        return this.mGestureId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AccessibilityGestureEvent[");
        stringBuilder.append("gestureId: ").append(AccessibilityGestureEvent.eventTypeToString(this.mGestureId));
        stringBuilder.append(", ");
        stringBuilder.append("displayId: ").append(this.mDisplayId);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String eventTypeToString(int eventType) {
        switch (eventType) {
            case 19: {
                return "GESTURE_2_FINGER_SINGLE_TAP";
            }
            case 20: {
                return "GESTURE_2_FINGER_DOUBLE_TAP";
            }
            case 40: {
                return "GESTURE_2_FINGER_DOUBLE_TAP_AND_HOLD";
            }
            case 21: {
                return "GESTURE_2_FINGER_TRIPLE_TAP";
            }
            case 22: {
                return "GESTURE_3_FINGER_SINGLE_TAP";
            }
            case 23: {
                return "GESTURE_3_FINGER_DOUBLE_TAP";
            }
            case 41: {
                return "GESTURE_3_FINGER_DOUBLE_TAP_AND_HOLD";
            }
            case 24: {
                return "GESTURE_3_FINGER_TRIPLE_TAP";
            }
            case 37: {
                return "GESTURE_4_FINGER_SINGLE_TAP";
            }
            case 38: {
                return "GESTURE_4_FINGER_DOUBLE_TAP";
            }
            case 42: {
                return "GESTURE_4_FINGER_DOUBLE_TAP_AND_HOLD";
            }
            case 39: {
                return "GESTURE_4_FINGER_TRIPLE_TAP";
            }
            case 17: {
                return "GESTURE_DOUBLE_TAP";
            }
            case 18: {
                return "GESTURE_DOUBLE_TAP_AND_HOLD";
            }
            case 2: {
                return "GESTURE_SWIPE_DOWN";
            }
            case 15: {
                return "GESTURE_SWIPE_DOWN_AND_LEFT";
            }
            case 8: {
                return "GESTURE_SWIPE_DOWN_AND_UP";
            }
            case 16: {
                return "GESTURE_SWIPE_DOWN_AND_RIGHT";
            }
            case 3: {
                return "GESTURE_SWIPE_LEFT";
            }
            case 9: {
                return "GESTURE_SWIPE_LEFT_AND_UP";
            }
            case 5: {
                return "GESTURE_SWIPE_LEFT_AND_RIGHT";
            }
            case 10: {
                return "GESTURE_SWIPE_LEFT_AND_DOWN";
            }
            case 4: {
                return "GESTURE_SWIPE_RIGHT";
            }
            case 11: {
                return "GESTURE_SWIPE_RIGHT_AND_UP";
            }
            case 6: {
                return "GESTURE_SWIPE_RIGHT_AND_LEFT";
            }
            case 12: {
                return "GESTURE_SWIPE_RIGHT_AND_DOWN";
            }
            case 1: {
                return "GESTURE_SWIPE_UP";
            }
            case 13: {
                return "GESTURE_SWIPE_UP_AND_LEFT";
            }
            case 7: {
                return "GESTURE_SWIPE_UP_AND_DOWN";
            }
            case 14: {
                return "GESTURE_SWIPE_UP_AND_RIGHT";
            }
            case 26: {
                return "GESTURE_2_FINGER_SWIPE_DOWN";
            }
            case 27: {
                return "GESTURE_2_FINGER_SWIPE_LEFT";
            }
            case 28: {
                return "GESTURE_2_FINGER_SWIPE_RIGHT";
            }
            case 25: {
                return "GESTURE_2_FINGER_SWIPE_UP";
            }
            case 30: {
                return "GESTURE_3_FINGER_SWIPE_DOWN";
            }
            case 31: {
                return "GESTURE_3_FINGER_SWIPE_LEFT";
            }
            case 32: {
                return "GESTURE_3_FINGER_SWIPE_RIGHT";
            }
            case 29: {
                return "GESTURE_3_FINGER_SWIPE_UP";
            }
            case 34: {
                return "GESTURE_4_FINGER_SWIPE_DOWN";
            }
            case 35: {
                return "GESTURE_4_FINGER_SWIPE_LEFT";
            }
            case 36: {
                return "GESTURE_4_FINGER_SWIPE_RIGHT";
            }
            case 33: {
                return "GESTURE_4_FINGER_SWIPE_UP";
            }
        }
        return Integer.toHexString(eventType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mGestureId);
        parcel.writeInt(this.mDisplayId);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GestureId {
    }
}

