/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.idea.core.KotlinFileTypeFactoryUtils;
import org.jetbrains.kotlin.idea.debugger.FileRankingCalculatorForIde;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J8\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J4\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u001c\u0010\u0003\u001a\u00020\u00048FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DebuggerUtils;", "", "()V", "forceRanking", "", "getForceRanking", "()Z", "setForceRanking", "(Z)V", "findFilesByNameInPackage", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findSourceFileForClass", "scopes", "location", "Lcom/sun/jdi/Location;", "findSourceFileForClassIncludeLibrarySources", "scope", "isKotlinSourceFile", "kotlin.jvm-debugger.util"})
public final class DebuggerUtils {
    private static boolean forceRanking;
    @NotNull
    public static final DebuggerUtils INSTANCE;

    public final boolean getForceRanking() {
        return forceRanking;
    }

    public final void setForceRanking(boolean bl) {
        forceRanking = bl;
    }

    @Nullable
    public final KtFile findSourceFileForClassIncludeLibrarySources(@NotNull Project project2, @NotNull GlobalSearchScope scope, @NotNull JvmClassName className, @NotNull String fileName, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return (KtFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(project2, scope, className, fileName, location){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ JvmClassName $className;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Location $location;

            @Nullable
            public final KtFile invoke() {
                Object[] objectArray = new GlobalSearchScope[2];
                objectArray[0] = this.$scope;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
                objectArray[1] = KotlinSourceFilterScope.Companion.librarySources(globalSearchScope, this.$project);
                return DebuggerUtils.INSTANCE.findSourceFileForClass(this.$project, CollectionsKt.listOf((Object[])objectArray), this.$className, this.$fileName, this.$location);
            }
            {
                this.$project = project2;
                this.$scope = globalSearchScope;
                this.$className = jvmClassName;
                this.$fileName = string;
                this.$location = location;
                super(0);
            }
        }));
    }

    public static /* synthetic */ KtFile findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils debuggerUtils, Project project2, GlobalSearchScope globalSearchScope, JvmClassName jvmClassName, String string, Location location, int n, Object object) {
        if ((n & 0x10) != 0) {
            location = null;
        }
        return debuggerUtils.findSourceFileForClassIncludeLibrarySources(project2, globalSearchScope, jvmClassName, string, location);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KtFile findSourceFileForClass(@NotNull Project project2, @NotNull List<? extends GlobalSearchScope> scopes, @NotNull JvmClassName className, @NotNull String fileName, @Nullable Location location) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!this.isKotlinSourceFile(fileName)) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(project)");
        if (dumbService.isDumb()) {
            return null;
        }
        FqName fqName = className.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"className.fqNameForClassNameWithoutDollars");
        FqName partFqName = fqName;
        for (GlobalSearchScope globalSearchScope : scopes) {
            Object v2;
            Iterable iterable;
            List<KtFile> files;
            block7: {
                void $this$singleOrNull$iv;
                files = this.findFilesByNameInPackage(className, fileName, project2, globalSearchScope);
                if (files.isEmpty()) continue;
                if (files.size() == 1 && !forceRanking || location == null) {
                    return (KtFile)CollectionsKt.first(files);
                }
                iterable = StaticFacadeIndexUtil.findFilesForFilePart((FqName)partFqName, (GlobalSearchScope)globalSearchScope, (Project)project2);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtFile it = (KtFile)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
                    if (found$iv) {
                        v2 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            KtFile ktFile = v2;
            if (ktFile != null) {
                iterable = ktFile;
                boolean bl = false;
                boolean bl2 = false;
                Iterable it = iterable;
                boolean bl3 = false;
                return it;
            }
            return FileRankingCalculatorForIde.INSTANCE.findMostAppropriateSource((Collection<? extends KtFile>)files, location);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className, String fileName, Project project2, GlobalSearchScope searchScope) {
        void $this$filterTo$iv$iv;
        FqName fqName = className.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"className.packageFqName");
        Iterable $this$filter$iv = PackageIndexUtil.findFilesWithExactPackage((FqName)fqName, (GlobalSearchScope)searchScope, (Project)project2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = (List)destination$iv$iv;
        return CollectionsKt.sortedWith((Iterable)files, (Comparator)JavaElementFinder.Companion.byClasspathComparator(searchScope));
    }

    public final boolean isKotlinSourceFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = FileUtilRt.getExtension((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtilRt.getExtension(fileName)");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String extension = string4;
        Intrinsics.checkNotNullExpressionValue((Object)KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS, (String)"KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS");
        return ArraysKt.contains((Object[])KotlinFileTypeFactoryUtils.KOTLIN_EXTENSIONS, (Object)extension);
    }

    private DebuggerUtils() {
    }

    static {
        DebuggerUtils debuggerUtils;
        INSTANCE = debuggerUtils = new DebuggerUtils();
    }
}

