/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.ui;

import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.TreeChooser;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNode;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B.\u0012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog;", "Lcom/intellij/ide/util/AbstractTreeClassChooserDialog;", "Lorg/jetbrains/kotlin/psi/KtFile;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "packageName", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Ljava/lang/String;)V", "createChooseByNameModel", "Lcom/intellij/ide/util/gotoByName/GotoFileModel;", "getClassesByName", "", "name", "checkBoxState", "", "pattern", "getSelectedFromTreeUserObject", "node", "Ljavax/swing/tree/DefaultMutableTreeNode;", "ScopeAwareClassFilter", "kotlin.idea"})
public final class KotlinFileChooserDialog
extends AbstractTreeClassChooserDialog<KtFile> {
    @Nullable
    protected KtFile getSelectedFromTreeUserObject(@NotNull DefaultMutableTreeNode node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object userObject = node.getUserObject();
        if (userObject instanceof KtFileTreeNode) {
            object = ((KtFileTreeNode)((Object)userObject)).getKtFile();
        } else if (userObject instanceof KtClassOrObjectTreeNode) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)((KtClassOrObjectTreeNode)((Object)userObject)).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)ktClassOrObject, (String)"userObject.value");
            KtFile ktFile = ktClassOrObject.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"userObject.value.containingKtFile");
            KtFile containingFile = ktFile;
            object = containingFile.getDeclarations().size() == 1 ? containingFile : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<KtFile> getClassesByName(@NotNull String name2, boolean checkBoxState, @NotNull String pattern, @NotNull GlobalSearchScope searchScope) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)this.getProject(), (String)name2, (GlobalSearchScope)searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026oject, name, searchScope)");
        PsiFile[] $this$filterIsInstance$iv = psiFileArray;
        boolean $i$f$filterIsInstance = false;
        PsiFile[] psiFileArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected GotoFileModel createChooseByNameModel() {
        return new GotoFileModel(this.getProject());
    }

    public KotlinFileChooserDialog(@NotNull String title, @NotNull Project project2, @Nullable GlobalSearchScope searchScope, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        GlobalSearchScope globalSearchScope = searchScope;
        if (globalSearchScope == null) {
            globalSearchScope = SearchUtilKt.restrictToKotlinSources((GlobalSearchScope)SearchUtilKt.projectScope((Project)project2));
        }
        super(title, project2, globalSearchScope, KtFile.class, (TreeChooser.Filter)new ScopeAwareClassFilter(searchScope, packageName), null, null, false, false);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog$ScopeAwareClassFilter;", "Lcom/intellij/ide/util/TreeChooser$Filter;", "Lorg/jetbrains/kotlin/psi/KtFile;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "packageName", "", "(Lcom/intellij/psi/search/GlobalSearchScope;Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "isAccepted", "", "element", "kotlin.idea"})
    private static final class ScopeAwareClassFilter
    implements TreeChooser.Filter<KtFile> {
        @Nullable
        private final GlobalSearchScope searchScope;
        @Nullable
        private final String packageName;

        public boolean isAccepted(@Nullable KtFile element3) {
            boolean bl;
            if (element3 == null) {
                return false;
            }
            if (this.searchScope == null && this.packageName == null) {
                return true;
            }
            GlobalSearchScope globalSearchScope = this.searchScope;
            boolean matchesSearchScope = globalSearchScope != null ? globalSearchScope.accept(element3.getVirtualFile()) : true;
            String string = this.packageName;
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string2;
                boolean bl4 = false;
                bl = Intrinsics.areEqual((Object)element3.getPackageFqName().asString(), (Object)it);
            } else {
                bl = true;
            }
            boolean matchesPackage = bl;
            return matchesSearchScope && matchesPackage;
        }

        @Nullable
        public final GlobalSearchScope getSearchScope() {
            return this.searchScope;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public ScopeAwareClassFilter(@Nullable GlobalSearchScope searchScope, @Nullable String packageName) {
            this.searchScope = searchScope;
            this.packageName = packageName;
        }
    }
}

