/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForExistingElement;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.ModelResultWithFUSData;
import org.jetbrains.kotlin.idea.statistics.MoveRefactoringFUSCollector;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "project", "Lcom/intellij/openapi/project/Project;", "openInEditorCheckBox", "", "selectedElementsToMove", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "originalClass", "targetClass", "Lcom/intellij/psi/PsiElement;", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "(Lcom/intellij/openapi/project/Project;ZLjava/util/List;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/move/MoveCallback;)V", "getMoveCallback", "()Lcom/intellij/refactoring/move/MoveCallback;", "getOpenInEditorCheckBox", "()Z", "getOriginalClass", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSelectedElementsToMove", "()Ljava/util/List;", "getTargetClass", "()Lcom/intellij/psi/PsiElement;", "computeModelResult", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/ModelResultWithFUSData;", "throwOnConflicts", "getCheckedTargetClass", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.idea"})
public final class MoveKotlinNestedClassesModel
implements Model {
    @NotNull
    private final Project project;
    private final boolean openInEditorCheckBox;
    @NotNull
    private final List<KtClassOrObject> selectedElementsToMove;
    @NotNull
    private final KtClassOrObject originalClass;
    @Nullable
    private final PsiElement targetClass;
    @Nullable
    private final MoveCallback moveCallback;

    private final KtElement getCheckedTargetClass() {
        PsiElement psiElement2 = this.targetClass;
        if (psiElement2 == null) {
            throw (Throwable)new ConfigurationException(RefactoringBundle.message((String)"no.destination.class.specified"));
        }
        PsiElement targetClass = psiElement2;
        if (!(targetClass instanceof KtClassOrObject)) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.destination.class.should.be.kotlin.class", new Object[0]));
        }
        if (this.originalClass == targetClass) {
            throw (Throwable)new ConfigurationException(RefactoringBundle.message((String)"source.and.destination.classes.should.be.different"));
        }
        for (KtClassOrObject classOrObject : this.selectedElementsToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)classOrObject), (PsiElement)targetClass, (boolean)false)) continue;
            throw (Throwable)new ConfigurationException(KotlinBundle.message("text.cannot.move.inner.class.0.into.itself", String.valueOf(classOrObject.getName())));
        }
        return (KtElement)targetClass;
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        List<KtClassOrObject> elementsToMove = this.selectedElementsToMove;
        KotlinMoveTargetForExistingElement target2 = new KotlinMoveTargetForExistingElement(this.getCheckedTargetClass());
        MoveDeclarationsDelegate.NestedClass delegate = new MoveDeclarationsDelegate.NestedClass(null, null, 3, null);
        MoveDeclarationsDescriptor descriptor2 = new MoveDeclarationsDescriptor(this.project, MoveKotlinDeclarationsProcessorKt.MoveSource((Collection<? extends KtNamedDeclaration>)elementsToMove), target2, delegate, false, false, false, this.moveCallback, this.openInEditorCheckBox, null, false, false, 3584, null);
        MoveKotlinDeclarationsProcessor processor2 = new MoveKotlinDeclarationsProcessor(descriptor2, Mover.Default.INSTANCE, throwOnConflicts);
        return new ModelResultWithFUSData(processor2, elementsToMove.size(), MoveRefactoringFUSCollector.MovedEntity.CLASSES, MoveRefactoringFUSCollector.MoveRefactoringDestination.DECLARATION);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getOpenInEditorCheckBox() {
        return this.openInEditorCheckBox;
    }

    @NotNull
    public final List<KtClassOrObject> getSelectedElementsToMove() {
        return this.selectedElementsToMove;
    }

    @NotNull
    public final KtClassOrObject getOriginalClass() {
        return this.originalClass;
    }

    @Nullable
    public final PsiElement getTargetClass() {
        return this.targetClass;
    }

    @Nullable
    public final MoveCallback getMoveCallback() {
        return this.moveCallback;
    }

    public MoveKotlinNestedClassesModel(@NotNull Project project2, boolean openInEditorCheckBox, @NotNull List<? extends KtClassOrObject> selectedElementsToMove, @NotNull KtClassOrObject originalClass, @Nullable PsiElement targetClass, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(selectedElementsToMove, (String)"selectedElementsToMove");
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        this.project = project2;
        this.openInEditorCheckBox = openInEditorCheckBox;
        this.selectedElementsToMove = selectedElementsToMove;
        this.originalClass = originalClass;
        this.targetClass = targetClass;
        this.moveCallback = moveCallback;
    }
}

