/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionParametersFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.util.QuickfixUtilKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000fH\u0004J\"\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\nH\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "element", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "getFunctionDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getFamilyName", "", "getNewArgumentName", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "validator", "Lkotlin/Function1;", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isSpecialName", "name", "startInWriteAction", "Companion", "kotlin.idea"})
public abstract class ChangeFunctionSignatureFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    private final FunctionDescriptor functionDescriptor;
    @NotNull
    private static final String FAMILY_NAME;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getFamilyName() {
        return FAMILY_NAME;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        boolean bl;
        Collection declarations;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Collection collection = declarations = DescriptorToSourceUtilsIde.getAllDeclarations$default((DescriptorToSourceUtilsIde)DescriptorToSourceUtilsIde.INSTANCE, (Project)project2, (DeclarationDescriptor)((DeclarationDescriptor)this.functionDescriptor), null, (int)4, null);
        boolean bl2 = false;
        if (collection.isEmpty()) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        Iterable $this$all$iv = declarations;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            PsiElement it = (PsiElement)element$iv;
            boolean bl4 = false;
            if (!it.isValid()) return false;
            if (!KotlinRefactoringUtilKt.canRefactor(it)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @NotNull
    protected final String getNewArgumentName(@NotNull ValueArgument argument2, @NotNull Function1<? super String, Boolean> validator2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter(validator2, (String)"validator");
        KtExpression expression2 = KtPsiUtil.deparenthesize((KtExpression)argument2.getArgumentExpression());
        Object object = argument2.getArgumentName();
        if (object == null || (object = object.getAsName()) == null || (object = object.asString()) == null) {
            Object object2;
            KtExpression ktExpression = expression2;
            if (!(ktExpression instanceof KtNameReferenceExpression)) {
                ktExpression = null;
            }
            if ((object2 = (KtNameReferenceExpression)ktExpression) != null && (object2 = object2.getReferencedName()) != null) {
                Object object3 = object2;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object3;
                boolean bl3 = false;
                object = !this.isSpecialName((String)it) ? object3 : null;
            } else {
                object = null;
            }
        }
        Object argumentName = object;
        if (argumentName != null) {
            string = KotlinNameSuggester.INSTANCE.suggestNameByName((String)argumentName, validator2);
        } else if (expression2 != null) {
            KotlinType type2;
            String expressionText;
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)((KtElement)expression2), (BodyResolveMode)BodyResolveMode.PARTIAL);
            String string2 = expressionText = expression2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expressionText");
            if (this.isSpecialName(string2) && (type2 = CallUtilKt.getType((KtExpression)expression2, (BindingContext)bindingContext2)) != null) {
                return (String)CollectionsKt.first((List)KotlinNameSuggester.INSTANCE.suggestNamesByType(type2, validator2, "param"));
            }
            string = (String)CollectionsKt.first((Iterable)KotlinNameSuggester.INSTANCE.suggestNamesByExpressionAndType(expression2, null, bindingContext2, validator2, "param"));
        } else {
            string = KotlinNameSuggester.INSTANCE.suggestNameByName("param", validator2);
        }
        return string;
    }

    private final boolean isSpecialName(String name2) {
        return Intrinsics.areEqual((Object)name2, (Object)"it") || Intrinsics.areEqual((Object)name2, (Object)"field");
    }

    @NotNull
    protected final FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public ChangeFunctionSignatureFix(@NotNull PsiElement element3, @NotNull FunctionDescriptor functionDescriptor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)functionDescriptor2, (String)"functionDescriptor");
        super(element3);
        this.functionDescriptor = functionDescriptor2;
    }

    static {
        Companion = new Companion(null);
        FAMILY_NAME = KotlinBundle.message("fix.change.signature.family", new Object[0]);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0014J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "()V", "FAMILY_NAME", "", "getFAMILY_NAME", "()Ljava/lang/String;", "createFix", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "originalElement", "data", "extractFixData", "element", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElementOfInterest", "runRemoveParameter", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "context", "Lcom/intellij/psi/PsiElement;", "RemoveParameterFix", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtCallElement, CallableDescriptor> {
        @Override
        @Nullable
        public KtCallElement getElementOfInterest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement $this$getStrictParentOfType$iv = diagnostic.getPsiElement();
            boolean $i$f$getStrictParentOfType = false;
            return (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallElement.class, (boolean)true);
        }

        @Override
        @Nullable
        public CallableDescriptor extractFixData(@NotNull KtCallElement element3, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            UnboundDiagnostic unboundDiagnostic = (UnboundDiagnostic)diagnostic;
            DiagnosticFactory[] diagnosticFactoryArray = new DiagnosticFactory[2];
            DiagnosticFactory1 diagnosticFactory1 = Errors.TOO_MANY_ARGUMENTS;
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory1, (String)"Errors.TOO_MANY_ARGUMENTS");
            diagnosticFactoryArray[0] = (DiagnosticFactory)diagnosticFactory1;
            DiagnosticFactory1 diagnosticFactory12 = Errors.NO_VALUE_FOR_PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory12, (String)"Errors.NO_VALUE_FOR_PARAMETER");
            diagnosticFactoryArray[1] = (DiagnosticFactory)diagnosticFactory12;
            UnboundDiagnostic unboundDiagnostic2 = DiagnosticFactory.Companion.cast(unboundDiagnostic, diagnosticFactoryArray);
            Intrinsics.checkNotNullExpressionValue((Object)unboundDiagnostic2, (String)"DiagnosticFactory.cast(d\u2026s.NO_VALUE_FOR_PARAMETER)");
            return (CallableDescriptor)((DiagnosticWithParameters1)unboundDiagnostic2).getA();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        protected ChangeFunctionSignatureFix createFix(@NotNull KtCallElement originalElement, @NotNull CallableDescriptor data) {
            FunctionDescriptor functionDescriptor2;
            Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            CallableDescriptor callableDescriptor = data;
            if (!(callableDescriptor instanceof FunctionDescriptor)) {
                callableDescriptor = null;
            }
            if ((functionDescriptor2 = (FunctionDescriptor)callableDescriptor) == null) {
                CallableDescriptor callableDescriptor2 = data;
                if (!(callableDescriptor2 instanceof ValueParameterDescriptor)) {
                    callableDescriptor2 = null;
                }
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)callableDescriptor2;
                Object object = valueParameterDescriptor != null ? valueParameterDescriptor.getContainingDeclaration() : null;
                if (!(object instanceof FunctionDescriptor)) {
                    object = null;
                }
                functionDescriptor2 = (FunctionDescriptor)object;
            }
            if (functionDescriptor2 == null) {
                return null;
            }
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            if (functionDescriptor3.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
                return null;
            }
            if (data instanceof ValueParameterDescriptor) {
                return new RemoveParameterFix((PsiElement)originalElement, functionDescriptor3, (ValueParameterDescriptor)data);
            }
            List list = functionDescriptor3.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"functionDescriptor.valueParameters");
            List parameters2 = list;
            List list2 = originalElement.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"originalElement.valueArguments");
            List arguments = list2;
            if (arguments.size() > parameters2.size()) {
                boolean bl;
                block20: {
                    Map argumentToParameter;
                    BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)((KtElement)originalElement), null, (int)1, null);
                    Call call = CallUtilKt.getCall((KtElement)((KtElement)originalElement), (BindingContext)bindingContext2);
                    if (call == null) {
                        return null;
                    }
                    Call call2 = call;
                    Map $this$any$iv = argumentToParameter = UtilsKt.mapArgumentsToParameters((Call)call2, (CallableDescriptor)((CallableDescriptor)functionDescriptor3));
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Map map2 = $this$any$iv;
                        boolean bl2 = false;
                        Iterator iterator = map2.entrySet().iterator();
                        while (iterator.hasNext()) {
                            boolean bl3;
                            block19: {
                                Collection argumentTypes2;
                                Collection collection;
                                void argument2;
                                Map.Entry element$iv;
                                Map.Entry $dstr$argument$parameter = element$iv = iterator.next();
                                boolean bl4 = false;
                                Map.Entry entry = $dstr$argument$parameter;
                                boolean bl5 = false;
                                ValueArgument valueArgument = (ValueArgument)entry.getKey();
                                entry = $dstr$argument$parameter;
                                bl5 = false;
                                ValueParameterDescriptor parameter = (ValueParameterDescriptor)entry.getValue();
                                if (argument2.getArgumentExpression() != null) {
                                    KtExpression ktExpression;
                                    boolean bl6 = false;
                                    boolean bl7 = false;
                                    KtExpression it = ktExpression;
                                    boolean bl8 = false;
                                    collection = QuickfixUtilKt.getDataFlowAwareTypes$default(it, bindingContext2, null, 4, null);
                                } else {
                                    collection = null;
                                }
                                Collection collection2 = argumentTypes2 = collection;
                                if (collection2 != null) {
                                    Iterable $this$none$iv = collection2;
                                    boolean $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl3 = true;
                                    } else {
                                        for (Object element$iv2 : $this$none$iv) {
                                            KotlinType dataFlowAwareType = (KotlinType)element$iv2;
                                            boolean bl9 = false;
                                            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(dataFlowAwareType, parameter.getType())) continue;
                                            bl3 = false;
                                            break block19;
                                        }
                                        bl3 = true;
                                    }
                                } else {
                                    bl3 = true;
                                }
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block20;
                        }
                        bl = false;
                    }
                }
                boolean hasTypeMismatches = bl;
                AddFunctionParametersFix.Kind kind = hasTypeMismatches ? (AddFunctionParametersFix.Kind)AddFunctionParametersFix.Kind.ChangeSignature.INSTANCE : (AddFunctionParametersFix.Kind)AddFunctionParametersFix.Kind.AddParameterGeneric.INSTANCE;
                return new AddFunctionParametersFix(originalElement, functionDescriptor3, kind);
            }
            return null;
        }

        @NotNull
        public final String getFAMILY_NAME() {
            return FAMILY_NAME;
        }

        public final void runRemoveParameter(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull PsiElement context2) {
            Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            CallableDescriptor callableDescriptor = parameterDescriptor.getContainingDeclaration();
            if (callableDescriptor == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
            Project project2 = context2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)functionDescriptor2;
            KotlinChangeSignatureConfiguration kotlinChangeSignatureConfiguration = new KotlinChangeSignatureConfiguration(parameterDescriptor){
                final /* synthetic */ ValueParameterDescriptor $parameterDescriptor;

                @NotNull
                public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)originalDescriptor, (String)"originalDescriptor");
                    return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(this){
                        final /* synthetic */ runRemoveParameter.1 this$0;

                        public final void invoke(@NotNull KotlinMutableMethodDescriptor descriptor2) {
                            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                            int index = descriptor2.getReceiver() != null ? this.this$0.$parameterDescriptor.getIndex() + 1 : this.this$0.$parameterDescriptor.getIndex();
                            descriptor2.removeParameter(index);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }

                public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                    Intrinsics.checkNotNullParameter(affectedFunctions, (String)"affectedFunctions");
                    return true;
                }

                public boolean forcePerformForSelectedFunctionOnly() {
                    return false;
                }
                {
                    this.$parameterDescriptor = $captured_local_variable$0;
                }
            };
            Object[] objectArray = new Object[1];
            String string = parameterDescriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameterDescriptor.name.asString()");
            objectArray[0] = string;
            KotlinChangeSignatureKt.runChangeSignature(project2, callableDescriptor2, kotlinChangeSignatureConfiguration, context2, KotlinBundle.message("fix.change.signature.remove.parameter", objectArray));
        }

        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix$Companion$RemoveParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "element", "Lcom/intellij/psi/PsiElement;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterToRemove", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)V", "getText", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
        private static final class RemoveParameterFix
        extends ChangeFunctionSignatureFix {
            private final ValueParameterDescriptor parameterToRemove;

            @NotNull
            public String getText() {
                Object[] objectArray = new Object[1];
                String string = this.parameterToRemove.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameterToRemove.name.asString()");
                objectArray[0] = string;
                return KotlinBundle.message("fix.change.signature.remove.parameter", objectArray);
            }

            @Override
            protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Object t = this.getElement();
                if (t == null) {
                    return;
                }
                Companion.runRemoveParameter(this.parameterToRemove, (PsiElement)t);
            }

            public RemoveParameterFix(@NotNull PsiElement element3, @NotNull FunctionDescriptor functionDescriptor2, @NotNull ValueParameterDescriptor parameterToRemove) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)functionDescriptor2, (String)"functionDescriptor");
                Intrinsics.checkNotNullParameter((Object)parameterToRemove, (String)"parameterToRemove");
                super(element3, functionDescriptor2);
                this.parameterToRemove = parameterToRemove;
            }
        }
    }
}

