/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyInitializerToGetterIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "allowCaretInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "kotlin.idea"})
public final class ConvertPropertyInitializerToGetterIntention
extends SelfTargetingRangeIntention<KtProperty> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public TextRange applicabilityRange(@NotNull KtProperty element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getInitializer();
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.initializer ?: return null");
        KtExpression initializer2 = ktExpression;
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.nameIdentifier ?: return null");
        PsiElement nameIdentifier = psiElement2;
        return element3.getGetter() == null && !KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)element3)) && !element3.isLocal() && !ModifierListModifactorKt.hasJvmFieldAnnotation((KtAnnotated)((KtAnnotated)element3)) ? new TextRange(PsiUtilsKt.getStartOffset((PsiElement)nameIdentifier), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)initializer2))) : null;
    }

    protected boolean allowCaretInsideElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return !(element3 instanceof KtDeclaration) && super.allowCaretInsideElement(element3);
    }

    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Companion.convertPropertyInitializerToGetter(element3, editor2);
    }

    public ConvertPropertyInitializerToGetterIntention() {
        super(KtProperty.class, KotlinBundle.lazyMessage("convert.property.initializer.to.getter", new Object[0]), null, 4, null);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyInitializerToGetterIntention$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "convertPropertyInitializerToGetter", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            return (IntentionAction)new ConvertPropertyInitializerToGetterIntention();
        }

        public final void convertPropertyInitializerToGetter(@NotNull KtProperty property2, @Nullable Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            KotlinType type2 = SpecifyTypeExplicitlyIntention.Companion.getTypeForDeclaration((KtCallableDeclaration)property2);
            if (!KotlinTypeKt.isError((KotlinType)type2)) {
                SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor2, (KtCallableDeclaration)property2, type2);
            }
            KtExpression ktExpression = property2.getInitializer();
            Intrinsics.checkNotNull((Object)ktExpression);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"property.initializer!!");
            KtExpression initializer2 = ktExpression;
            KtPropertyAccessor getter = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)property2), (boolean)false, (int)2, null).createPropertyGetter(initializer2);
            KtPropertyAccessor setter = property2.getSetter();
            if (setter != null) {
                property2.addBefore((PsiElement)getter, (PsiElement)setter);
            } else if (property2.isVar()) {
                property2.add((PsiElement)getter);
                KtExpression notImplemented = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)property2), (boolean)false, (int)2, null).createExpression("TODO()");
                KtPropertyAccessor notImplementedSetter = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)property2), (boolean)false, (int)2, null).createPropertySetter(notImplemented);
                property2.add((PsiElement)notImplementedSetter);
            } else {
                property2.add((PsiElement)getter);
            }
            property2.setInitializer((KtExpression)null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

