/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceToStringWithStringTemplateInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionText", "isApplicable", "", "kotlin.idea"})
public final class ReplaceToStringWithStringTemplateInspection
extends AbstractApplicabilityBasedInspection<KtDotQualifiedExpression> {
    public boolean isApplicable(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3.getReceiverExpression() instanceof KtReferenceExpression)) {
            return false;
        }
        if (element3.getParent() instanceof KtBlockStringTemplateEntry) {
            return false;
        }
        return UtilsKt.isToString(element3);
    }

    public void applyTo(@NotNull KtDotQualifiedExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        KtBlockStringTemplateEntry blockStringTemplateEntry;
        KtStringTemplateEntry ktStringTemplateEntry;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String variable2 = element3.getReceiverExpression().getText();
        PsiElement psiElement2 = element3.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null).createExpression("\"${" + variable2 + "}\""));
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.replace(KtPsiFac\u2026ion(\"\\\"\\${$variable}\\\"\"))");
        PsiElement replaced2 = psiElement2;
        PsiElement psiElement3 = replaced2;
        if (!(psiElement3 instanceof KtStringTemplateExpression)) {
            psiElement3 = null;
        }
        if (!(((objectArray = (Object[])psiElement3) != null && (objectArray = objectArray.getEntries()) != null ? (KtStringTemplateEntry)ArraysKt.firstOrNull((Object[])objectArray) : (ktStringTemplateEntry = null)) instanceof KtBlockStringTemplateEntry)) {
            ktStringTemplateEntry = null;
        }
        KtBlockStringTemplateEntry ktBlockStringTemplateEntry = blockStringTemplateEntry = (KtBlockStringTemplateEntry)ktStringTemplateEntry;
        if (ktBlockStringTemplateEntry != null) {
            if (PsiModificationUtilsKt.canDropBraces((KtBlockStringTemplateEntry)ktBlockStringTemplateEntry)) {
                PsiModificationUtilsKt.dropBraces((KtBlockStringTemplateEntry)blockStringTemplateEntry);
            }
        }
    }

    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("call.of.tostring.could.be.replaced.with.string.template", new Object[0]);
    }

    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.tostring.with.string.template", new Object[0]);
    }

    public ReplaceToStringWithStringTemplateInspection() {
        super(KtDotQualifiedExpression.class);
    }
}

