/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.handlers.KeywordConstructLookupObject;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u001a!\u0010\u0015\u001a\u0004\u0018\u00010\r*\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0019\u001a\u001a\u0010\u001a\u001a\u00020\b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001a\u0010\u001b\u001a\u00020\b*\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005\u001a\u0012\u0010\u001d\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\r\u001a\u0012\u0010\u001f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\r\u001a\u0014\u0010 \u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u00a8\u0006!"}, d2={"createKeywordConstructLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "project", "Lcom/intellij/openapi/project/Project;", "keyword", "", "fileTextToReformat", "trimSpacesAroundCaret", "", "detectIndent", "text", "", "offset", "", "removeRedundantBracesInStringTemplate", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "surroundWithBracesIfInStringTemplate", "indentLinesAfterFirst", "indent", "indexOfSkippingSpace", "c", "", "startIndex", "(Ljava/lang/CharSequence;CI)Ljava/lang/Integer;", "isCharAt", "isTextAt", "Lcom/intellij/openapi/editor/Document;", "skipSpaces", "index", "skipSpacesAndLineBreaks", "unindent", "kotlin.idea"})
public final class HandlerUtilsKt {
    public static final boolean surroundWithBracesIfInStringTemplate(@NotNull InsertionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        int startOffset = context2.getStartOffset();
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
        Document document2 = document;
        if (startOffset > 0 && document2.getCharsSequence().charAt(startOffset - 1) == '$') {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
            psiDocumentManager.commitAllDocuments();
            PsiElement psiElement2 = context2.getFile().findElementAt(startOffset - 1);
            if (Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START)) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
                document2.insertString(startOffset, (CharSequence)"{");
                context2.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + 1);
                int tailOffset = context2.getTailOffset();
                document2.insertString(tailOffset, (CharSequence)"}");
                context2.setTailOffset(tailOffset);
                return true;
            }
        }
        return false;
    }

    public static final void removeRedundantBracesInStringTemplate(@NotNull InsertionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
        Document document2 = document;
        int tailOffset = context2.getTailOffset();
        if (document2.getCharsSequence().charAt(tailOffset) == '}') {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
            psiDocumentManager.commitAllDocuments();
            PsiElement token = context2.getFile().findElementAt(tailOffset);
            if (token != null) {
                ASTNode aSTNode = token.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"token.node");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.LONG_TEMPLATE_ENTRY_END)) {
                    PsiElement psiElement2 = token.getParent();
                    if (psiElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry");
                    }
                    KtBlockStringTemplateEntry entry = (KtBlockStringTemplateEntry)psiElement2;
                    KtExpression ktExpression = entry.getExpression();
                    if (!(ktExpression instanceof KtNameReferenceExpression)) {
                        ktExpression = null;
                    }
                    KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
                    if (ktNameReferenceExpression == null) {
                        return;
                    }
                    KtNameReferenceExpression nameExpression2 = ktNameReferenceExpression;
                    if (KtPsiUtilKt.canPlaceAfterSimpleNameEntry((PsiElement)entry.getNextSibling())) {
                        InsertionContext insertionContext = context2;
                        int n = insertionContext.getTailOffset();
                        insertionContext.setTailOffset(n + 1);
                        String name2 = nameExpression2.getReferencedName();
                        KtSimpleNameStringTemplateEntry newEntry = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)entry), (boolean)false, (int)2, null).createSimpleNameStringTemplateEntry(name2);
                        entry.replace((PsiElement)newEntry);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Integer indexOfSkippingSpace(@NotNull CharSequence $this$indexOfSkippingSpace, char c, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOfSkippingSpace, (String)"$this$indexOfSkippingSpace");
        int n = startIndex;
        int n2 = $this$indexOfSkippingSpace.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                char currentChar;
                if (c == (currentChar = $this$indexOfSkippingSpace.charAt((int)i))) {
                    return (int)i;
                }
                if (currentChar != ' ' && currentChar != '\t') {
                    return null;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return null;
    }

    public static final int skipSpaces(@NotNull CharSequence $this$skipSpaces, int index) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$skipSpaces, (String)"$this$skipSpaces");
            int n = index;
            Iterable $this$firstOrNull$iv = (Iterable)new IntRange(n, $this$skipSpaces.length() - 1);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                char c = $this$skipSpaces.charAt(it);
                if (!(c != ' ' && c != '\t')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? n.intValue() : $this$skipSpaces.length();
    }

    public static final int skipSpacesAndLineBreaks(@NotNull CharSequence $this$skipSpacesAndLineBreaks, int index) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$skipSpacesAndLineBreaks, (String)"$this$skipSpacesAndLineBreaks");
            int n = index;
            Iterable $this$firstOrNull$iv = (Iterable)new IntRange(n, $this$skipSpacesAndLineBreaks.length() - 1);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                char c = $this$skipSpacesAndLineBreaks.charAt(it);
                if (!(c != ' ' && c != '\t' && c != '\n' && c != '\r')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? n.intValue() : $this$skipSpacesAndLineBreaks.length();
    }

    public static final boolean isCharAt(@NotNull CharSequence $this$isCharAt, int offset, char c) {
        Intrinsics.checkNotNullParameter((Object)$this$isCharAt, (String)"$this$isCharAt");
        return offset < $this$isCharAt.length() && $this$isCharAt.charAt(offset) == c;
    }

    public static final boolean isTextAt(@NotNull Document $this$isTextAt, int offset, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$isTextAt, (String)"$this$isTextAt");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return offset + text2.length() <= $this$isTextAt.getTextLength() && Intrinsics.areEqual((Object)$this$isTextAt.getText(new TextRange(offset, offset + text2.length())), (Object)text2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final LookupElement createKeywordConstructLookupElement(@NotNull Project project2, @NotNull String keyword, @NotNull String fileTextToReformat, boolean trimSpacesAroundCaret) {
        String string;
        String string2;
        boolean bl;
        void tailAfterCaret;
        void tailBeforeCaret;
        String newFileText;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)fileTextToReformat, (String)"fileTextToReformat");
        KtFile file = new KtPsiFactory(project2, false, 2, null).createFile(fileTextToReformat);
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)file);
        String string3 = newFileText = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"newFileText");
        int keywordOffset = StringsKt.indexOf$default((CharSequence)string3, (String)keyword, (int)0, (boolean)false, (int)6, null);
        boolean bl2 = keywordOffset >= 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl5 = false;
            String string4 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        int keywordEndOffset = keywordOffset + keyword.length();
        String caretPlaceHolder = "caret";
        int caretOffset = StringsKt.indexOf$default((CharSequence)newFileText, (String)caretPlaceHolder, (int)0, (boolean)false, (int)6, null);
        boolean bl6 = caretOffset >= 0;
        boolean bl7 = false;
        boolean bl8 = false;
        if (_Assertions.ENABLED && !bl6) {
            boolean bl9 = false;
            String string5 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string5));
        }
        bl6 = caretOffset >= keywordEndOffset;
        bl7 = false;
        bl8 = false;
        if (_Assertions.ENABLED && !bl6) {
            boolean bl10 = false;
            String string6 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string6));
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        String string7 = newFileText;
        bl8 = false;
        String string8 = string7.substring(keywordEndOffset, caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        objectRef.element = string8;
        string7 = new Ref.ObjectRef();
        String string9 = newFileText;
        int n = caretOffset + caretPlaceHolder.length();
        boolean bl11 = false;
        String string10 = string9.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
        ((Ref.ObjectRef)string7).element = string10;
        if (trimSpacesAroundCaret) {
            string9 = (String)tailBeforeCaret.element;
            n = 0;
            String string11 = string9;
            if (string11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            tailBeforeCaret.element = ((Object)StringsKt.trimEnd((CharSequence)string11)).toString();
            string9 = (String)tailAfterCaret.element;
            n = 0;
            String string12 = string9;
            if (string12 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            tailAfterCaret.element = ((Object)StringsKt.trimStart((CharSequence)string12)).toString();
        }
        String indent = HandlerUtilsKt.detectIndent(newFileText, keywordOffset);
        tailBeforeCaret.element = HandlerUtilsKt.unindent((String)tailBeforeCaret.element, indent);
        tailAfterCaret.element = HandlerUtilsKt.unindent((String)tailAfterCaret.element, indent);
        StringBuilder stringBuilder = new StringBuilder();
        if (StringsKt.contains$default((CharSequence)((String)tailBeforeCaret.element), (char)'\n', (boolean)false, (int)2, null)) {
            String string13 = StringsKt.replace$default((String)((String)tailBeforeCaret.element), (String)"\n", (String)"", (boolean)false, (int)4, null);
            bl = false;
            String string14 = string13;
            if (string14 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string2 = ((Object)StringsKt.trimEnd((CharSequence)string14)).toString();
        } else {
            string2 = (String)tailBeforeCaret.element;
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("...");
        if (StringsKt.contains$default((CharSequence)((String)tailAfterCaret.element), (char)'\n', (boolean)false, (int)2, null)) {
            String string15 = StringsKt.replace$default((String)((String)tailAfterCaret.element), (String)"\n", (String)"", (boolean)false, (int)4, null);
            bl = false;
            String string16 = string15;
            if (string16 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trimStart((CharSequence)string16)).toString();
        } else {
            string = (String)tailAfterCaret.element;
        }
        String tailText = stringBuilder2.append(string).toString();
        KeywordConstructLookupObject lookupElement2 = new KeywordConstructLookupObject(keyword, fileTextToReformat);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)lookupElement2, (String)keyword).bold().withTailText(tailText).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(keyword, (Ref.ObjectRef)tailBeforeCaret, (Ref.ObjectRef)tailAfterCaret){
            final /* synthetic */ String $keyword;
            final /* synthetic */ Ref.ObjectRef $tailBeforeCaret;
            final /* synthetic */ Ref.ObjectRef $tailAfterCaret;

            /*
             * Enabled aggressive block sorting
             */
            public final void handleInsert(@NotNull InsertionContext insertionContext, @NotNull LookupElement $noName_1) {
                PsiElement sibling;
                Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"insertionContext");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                if (insertionContext.getCompletionChar() != '\n' && insertionContext.getCompletionChar() != '\t') {
                    if (insertionContext.getCompletionChar() != '\u0000') return;
                }
                int offset = insertionContext.getTailOffset();
                Document document = insertionContext.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"insertionContext.document");
                CharSequence charSequence = document.getCharsSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"insertionContext.document.charsSequence");
                String newIndent = HandlerUtilsKt.access$detectIndent(charSequence, offset - this.$keyword.length());
                String beforeCaret = HandlerUtilsKt.access$indentLinesAfterFirst((String)this.$tailBeforeCaret.element, newIndent);
                String afterCaret = HandlerUtilsKt.access$indentLinesAfterFirst((String)this.$tailAfterCaret.element, newIndent);
                PsiElement element3 = insertionContext.getFile().findElementAt(offset);
                Object object = !(element3 instanceof PsiWhiteSpace) ? element3 : (sibling = element3.textContains('\n') ? null : PsiUtilsKt.getNextSiblingIgnoringWhitespace((PsiElement)element3, (boolean)true));
                if (sibling != null) {
                    String string = beforeCaret;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string4 = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
                    string4 = insertionContext.getDocument().getText(TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)sibling), (int)1));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"insertionContext.documen\u2026                        )");
                    if (StringsKt.startsWith$default((String)string3, (String)string4, (boolean)false, (int)2, null)) {
                        Editor editor2 = insertionContext.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"insertionContext.editor");
                        GenerateUtilKt.moveCaret$default((Editor)editor2, (int)(PsiUtilsKt.getStartOffset((PsiElement)sibling) + 1), null, (int)2, null);
                        return;
                    }
                }
                insertionContext.getDocument().insertString(offset, (CharSequence)(beforeCaret + afterCaret));
                Editor editor3 = insertionContext.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"insertionContext.editor");
                GenerateUtilKt.moveCaret$default((Editor)editor3, (int)(offset + beforeCaret.length()), null, (int)2, null);
            }
            {
                this.$keyword = string;
                this.$tailBeforeCaret = objectRef;
                this.$tailAfterCaret = objectRef2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026}\n            }\n        }");
        return (LookupElement)lookupElementBuilder;
    }

    public static /* synthetic */ LookupElement createKeywordConstructLookupElement$default(Project project2, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return HandlerUtilsKt.createKeywordConstructLookupElement(project2, string, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final String detectIndent(CharSequence text2, int offset) {
        CharSequence charSequence;
        block2: {
            CharSequence charSequence2 = text2;
            int n = 0;
            int n2 = 0;
            String $this$takeWhile$iv = StringsKt.substringAfterLast$default((String)((Object)charSequence2.subSequence(n, offset)).toString(), (char)'\n', null, (int)2, null);
            boolean $i$f$takeWhile = false;
            n2 = 0;
            int n3 = $this$takeWhile$iv.length();
            while (n2 < n3) {
                void index$iv;
                char p1 = $this$takeWhile$iv.charAt((int)index$iv);
                boolean bl = false;
                if (!CharsKt.isWhitespace((char)p1)) {
                    String string = $this$takeWhile$iv;
                    int n4 = 0;
                    boolean bl2 = false;
                    String string2 = string.substring(n4, (int)index$iv);
                    charSequence = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    break block2;
                }
                ++index$iv;
            }
            charSequence = charSequence2;
        }
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private static final String indentLinesAfterFirst(String $this$indentLinesAfterFirst, String indent) {
        String text2 = $this$indentLinesAfterFirst;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        List lines = StringsKt.lines((CharSequence)text2);
        boolean bl6 = false;
        for (String line : (Iterable)lines) {
            void index;
            if (index > 0) {
                $this$buildString.append(indent);
            }
            $this$buildString.append(line);
            if (index != CollectionsKt.getLastIndex((List)lines)) {
                $this$buildString.append('\n');
            }
            ++index;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final String unindent(String $this$unindent, String indent) {
        String text2 = $this$unindent;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        List lines = StringsKt.lines((CharSequence)text2);
        boolean bl6 = false;
        for (String line : (Iterable)lines) {
            void index;
            $this$buildString.append(StringsKt.removePrefix((String)line, (CharSequence)indent));
            if (index != CollectionsKt.getLastIndex((List)lines)) {
                $this$buildString.append('\n');
            }
            ++index;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final /* synthetic */ String access$detectIndent(CharSequence text2, int offset) {
        return HandlerUtilsKt.detectIndent(text2, offset);
    }

    public static final /* synthetic */ String access$indentLinesAfterFirst(String $this$access_u24indentLinesAfterFirst, String indent) {
        return HandlerUtilsKt.indentLinesAfterFirst($this$access_u24indentLinesAfterFirst, indent);
    }
}

