/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.androidPlugin.DataBindingOutputParser;
import com.android.utils.ILogger;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildFailureParser
implements PatternAwareOutputParser {
    private static final Pattern[] BEGINNING_PATTERNS = new Pattern[]{Pattern.compile("^FAILURE: Build failed with an exception."), Pattern.compile("^\\* What went wrong:")};
    private static final Pattern WHERE_LINE_1 = Pattern.compile("^\\* Where:");
    private static final Pattern WHERE_LINE_2 = Pattern.compile("^Build file '(.+)' line: (\\d+)");
    private static final Pattern[] ENDING_PATTERNS = new Pattern[]{Pattern.compile("^\\* Try:"), Pattern.compile("^Run with --stacktrace option to get the stack trace. Run with --info or --debug option to get more log output.")};
    private static final Pattern COMMAND_FAILURE_MESSAGE = Pattern.compile("^> Failed to run command:");
    private static final Pattern COMMAND_LINE_PARSER = Pattern.compile("^\\s+/([^/ ]+/)+([^/ ]+) (.*)");
    private static final Pattern COMMAND_LINE_ERROR_OUTPUT = Pattern.compile("^  Output:$");
    private static final Pattern COMPILE_FAILURE_MESSAGE = Pattern.compile("^> Build command failed.");
    private static final Pattern COMPILE_LINE_PARSER = Pattern.compile("^\\s*(.+):(\\d+):(\\d+): (([^:]+): .*)$");
    private AaptOutputParser myAaptParser = new AaptOutputParser();
    private DataBindingOutputParser myDataBindingParser = new DataBindingOutputParser();

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        State state = State.BEGINNING;
        int pos = 0;
        String currentLine = line;
        SourceFile file = SourceFile.UNKNOWN;
        SourcePosition position = SourcePosition.UNKNOWN;
        String lastQuotedLine = null;
        StringBuilder errorMessage = new StringBuilder();
        while (true) {
            switch (state) {
                case BEGINNING: {
                    if (WHERE_LINE_1.matcher(currentLine).matches()) {
                        state = State.WHERE;
                        break;
                    }
                    if (!BEGINNING_PATTERNS[pos].matcher(currentLine).matches()) {
                        return false;
                    }
                    if (++pos < BEGINNING_PATTERNS.length) break;
                    state = State.MESSAGE;
                    break;
                }
                case WHERE: {
                    Matcher matcher = WHERE_LINE_2.matcher(currentLine);
                    if (!matcher.matches()) {
                        return false;
                    }
                    file = new SourceFile(new File(matcher.group(1)));
                    position = new SourcePosition(Integer.parseInt(matcher.group(2)) - 1, 0, -1);
                    state = State.BEGINNING;
                    break;
                }
                case MESSAGE: {
                    boolean handledByDataBinding;
                    Matcher matcher;
                    if (ENDING_PATTERNS[0].matcher(currentLine).matches()) {
                        state = State.ENDING;
                        pos = 1;
                        break;
                    }
                    if (COMMAND_FAILURE_MESSAGE.matcher(currentLine).matches()) {
                        state = State.COMMAND_FAILURE_COMMAND_LINE;
                        break;
                    }
                    if (COMPILE_FAILURE_MESSAGE.matcher(currentLine).matches()) {
                        state = State.COMPILE_FAILURE_OUTPUT;
                        errorMessage.setLength(0);
                        break;
                    }
                    int quoted = -1;
                    int n = currentLine.length();
                    for (int i = 0; i < n; ++i) {
                        char c = currentLine.charAt(i);
                        if (c == '>') {
                            quoted = i;
                            break;
                        }
                        if (!Character.isWhitespace(c)) break;
                    }
                    if (quoted != -1) {
                        if (currentLine.startsWith("> In DataSet ", quoted) && currentLine.contains("no data file for changedFile")) {
                            matcher = Pattern.compile("\\s*> In DataSet '.+', no data file for changedFile '(.+)'").matcher(currentLine);
                            if (matcher.find()) {
                                file = new SourceFile(new File(matcher.group(1)));
                            }
                        } else if (currentLine.startsWith("> Duplicate resources: ", quoted)) {
                            matcher = Pattern.compile("\\s*> Duplicate resources: (.+):(.+), (.+):(.+)\\s*").matcher(currentLine);
                            if (matcher.matches()) {
                                file = new SourceFile(new File(matcher.group(1)));
                                position = AbstractAaptOutputParser.findResourceLine((File)file.getSourceFile(), (String)matcher.group(2), (ILogger)logger);
                                File other = new File(matcher.group(3));
                                SourcePosition otherPos = AbstractAaptOutputParser.findResourceLine((File)other, (String)matcher.group(4), (ILogger)logger);
                                messages.add(new Message(Message.Kind.ERROR, currentLine, new SourceFilePosition(file, position), new SourceFilePosition[]{new SourceFilePosition(other, otherPos)}));
                                break;
                            }
                        } else if (currentLine.startsWith("> Problems pinging owner of lock ", quoted)) {
                            String text = "Possibly unstable network connection: Failed to connect to lock owner. Try to rebuild.";
                            messages.add(new Message(Message.Kind.ERROR, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
                        }
                    }
                    if (!(handledByDataBinding = this.myDataBindingParser.parse(currentLine, reader, messages, logger))) {
                        if (errorMessage.length() > 0) {
                            errorMessage.append("\n");
                        }
                        errorMessage.append(currentLine);
                    }
                    if (!BuildFailureParser.isGradleQuotedLine(currentLine)) break;
                    lastQuotedLine = currentLine;
                    break;
                }
                case COMMAND_FAILURE_COMMAND_LINE: {
                    currentLine = currentLine.replaceAll("Android Studio", "Android_Studio");
                    Matcher matcher = COMMAND_LINE_PARSER.matcher(currentLine);
                    if (matcher.matches()) {
                        String message = String.format("Error while executing %s command", matcher.group(2));
                        messages.add(new Message(Message.Kind.ERROR, message, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
                        break;
                    }
                    if (COMMAND_LINE_ERROR_OUTPUT.matcher(currentLine).matches()) {
                        state = State.COMMAND_FAILURE_OUTPUT;
                        break;
                    }
                    if (!ENDING_PATTERNS[0].matcher(currentLine).matches()) break;
                    state = State.ENDING;
                    pos = 1;
                    break;
                }
                case COMMAND_FAILURE_OUTPUT: {
                    if (ENDING_PATTERNS[0].matcher(currentLine).matches()) {
                        state = State.ENDING;
                        pos = 1;
                        break;
                    }
                    if (this.myAaptParser.parse(currentLine = currentLine.trim(), reader, messages, logger)) break;
                    messages.add(new Message(Message.Kind.ERROR, currentLine, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
                    break;
                }
                case COMPILE_FAILURE_OUTPUT: {
                    if (ENDING_PATTERNS[0].matcher(currentLine).matches()) {
                        state = State.ENDING;
                        pos = 1;
                        break;
                    }
                    Matcher matcher = COMPILE_LINE_PARSER.matcher(currentLine);
                    if (!matcher.matches()) break;
                    file = new SourceFile(new File(matcher.group(1)));
                    position = new SourcePosition(Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)) - 1, -1);
                    String text = matcher.group(4);
                    String type = matcher.group(5);
                    Message.Kind kind = Message.Kind.UNKNOWN;
                    if (type.endsWith("error")) {
                        kind = Message.Kind.ERROR;
                    } else if (type.equals("warning")) {
                        kind = Message.Kind.WARNING;
                    } else if (type.equals("note")) {
                        kind = Message.Kind.INFO;
                    }
                    messages.add(new Message(kind, text, new SourceFilePosition(file, position), new SourceFilePosition[0]));
                    break;
                }
                case ENDING: {
                    if (!ENDING_PATTERNS[pos].matcher(currentLine).matches()) {
                        return false;
                    }
                    if (++pos < ENDING_PATTERNS.length) break;
                    if (errorMessage.length() > 0) {
                        String text = errorMessage.toString();
                        if (SourceFile.UNKNOWN.equals((Object)file) && lastQuotedLine != null) {
                            String lastLine;
                            String[] lines;
                            String msg = BuildFailureParser.unquoteGradleLine(lastQuotedLine);
                            Message rootCause = BuildFailureParser.findRootCause(msg, messages);
                            if (rootCause == null && msg.endsWith("Failed to run command:") && (lines = text.split("\n")).length > 2 && lines[lines.length - 2].contains("Output:") && !(lastLine = lines[lines.length - 1]).isEmpty()) {
                                rootCause = BuildFailureParser.findRootCause(lastLine.trim(), messages);
                            }
                            if (rootCause != null && !rootCause.getSourceFilePositions().isEmpty()) {
                                SourceFilePosition sourceFilePosition = (SourceFilePosition)rootCause.getSourceFilePositions().get(0);
                                file = sourceFilePosition.getFile();
                                position = sourceFilePosition.getPosition();
                            }
                        }
                        if (!SourceFile.UNKNOWN.equals((Object)file)) {
                            messages.add(new Message(Message.Kind.ERROR, text, new SourceFilePosition(file, position), new SourceFilePosition[0]));
                        } else if (text.contains("Build cancelled")) {
                            messages.add(new Message(Message.Kind.INFO, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
                        } else {
                            messages.add(new Message(Message.Kind.ERROR, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]));
                        }
                    }
                    return true;
                }
            }
            do {
                if ((currentLine = reader.readLine()) != null) continue;
                return false;
            } while (currentLine.trim().isEmpty());
        }
    }

    @Nullable
    private static Message findRootCause(@NotNull String text, @NotNull Collection<Message> messages) {
        for (Message message : messages) {
            if (message.getKind() == Message.Kind.INFO || !message.getText().contains(text) || !message.getSourceFilePositions().isEmpty()) continue;
            return message;
        }
        int index = text.indexOf(58);
        if (index != -1 && index < text.length() - 1) {
            return BuildFailureParser.findRootCause(text.substring(index + 1).trim(), messages);
        }
        return null;
    }

    private static boolean isGradleQuotedLine(@NotNull String line) {
        int n = line.length() - 1;
        for (int i = 0; i < n; ++i) {
            char c = line.charAt(i);
            if (c == '>') {
                return line.charAt(i + 1) == ' ';
            }
            if (c != ' ') break;
        }
        return false;
    }

    private static String unquoteGradleLine(@NotNull String line) {
        assert (BuildFailureParser.isGradleQuotedLine(line));
        return line.substring(line.indexOf(62) + 2);
    }

    private static enum State {
        BEGINNING,
        WHERE,
        MESSAGE,
        COMMAND_FAILURE_COMMAND_LINE,
        COMMAND_FAILURE_OUTPUT,
        COMPILE_FAILURE_OUTPUT,
        ENDING;

    }
}

