/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project.dependencies;

import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.util.BooleanBiFunction;
import com.intellij.openapi.externalSystem.util.IteratorUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDependencyNode
implements DependencyNode,
Serializable {
    private final long id;
    private final List<DependencyNode> dependencies;
    private String resolutionState;

    protected AbstractDependencyNode(long id) {
        this.id = id;
        this.dependencies = new ArrayList<DependencyNode>(0);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<DependencyNode> getDependencies() {
        return this.dependencies;
    }

    @Override
    @Nullable
    public String getResolutionState() {
        return this.resolutionState;
    }

    public void setResolutionState(@Nullable String resolutionState) {
        this.resolutionState = resolutionState;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDependencyNode node = (AbstractDependencyNode)o;
        if (this.id != node.id) {
            return false;
        }
        if (this.resolutionState != null ? !this.resolutionState.equals(node.resolutionState) : node.resolutionState != null) {
            return false;
        }
        if (!this.match(node)) {
            return false;
        }
        return AbstractDependencyNode.match(this.dependencies, node.dependencies);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.dependencies != null ? this.dependencies.size() : 0);
        result = 31 * result + (this.resolutionState != null ? this.resolutionState.hashCode() : 0);
        return result;
    }

    protected abstract boolean match(AbstractDependencyNode var1);

    private static boolean match(@NotNull Collection<DependencyNode> dependencies1, @NotNull Collection<DependencyNode> dependencies2) {
        return IteratorUtils.match(new DependenciesIterator(dependencies1), new DependenciesIterator(dependencies2), new BooleanBiFunction<DependencyNode, DependencyNode>(){

            @Override
            public Boolean fun(DependencyNode o1, DependencyNode o2) {
                if (o1 instanceof AbstractDependencyNode && o2 instanceof AbstractDependencyNode) {
                    AbstractDependencyNode o11 = (AbstractDependencyNode)o1;
                    AbstractDependencyNode o21 = (AbstractDependencyNode)o2;
                    if (o11.id != o21.id) {
                        return false;
                    }
                    if (o11.resolutionState != null ? !o11.resolutionState.equals(o21.resolutionState) : o21.resolutionState != null) {
                        return false;
                    }
                    return o11.match(o21);
                }
                return o1 == null ? o2 == null : o1.equals(o2);
            }
        });
    }

    private static class DependenciesIterator
    extends IteratorUtils.AbstractObjectGraphIterator<DependencyNode> {
        private DependenciesIterator(Collection<DependencyNode> dependencies) {
            super(dependencies);
        }

        @Override
        public Collection<? extends DependencyNode> getChildren(DependencyNode node) {
            return node.getDependencies();
        }
    }
}

