/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;

public class ProxyModule
extends BaseCommandRuntimeModule {
    public ProxyModule(@NotNull CommandRuntime runtime) {
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) {
        if (this.myAuthenticationService.haveDataForTmpConfig() && !CommandRuntime.isLocal(command)) {
            this.setupProxy(command);
        }
    }

    private void setupProxy(@NotNull Command command) {
        Url repositoryUrl = command.requireRepositoryUrl();
        Proxy proxy = AuthenticationService.getIdeaDefinedProxy(repositoryUrl);
        if (proxy != null) {
            String hostGroup = this.ensureGroupForHost(command, repositoryUrl.getHost());
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-host=%s", hostGroup, address.getHostName()));
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-port=%s", hostGroup, address.getPort()));
        }
    }

    @NotNull
    private String ensureGroupForHost(@NotNull Command command, @NotNull String host) {
        IdeaSVNConfigFile configFile = new IdeaSVNConfigFile(this.myAuthenticationService.getSpecialConfigDir());
        String groupName = IdeaSVNConfigFile.getGroupForHost(host, configFile);
        if (StringUtil.isEmptyOrSpaces((String)groupName)) {
            groupName = IdeaSVNConfigFile.getNewGroupName(host, configFile);
            command.put("--config-option");
            command.put(String.format("servers:groups:%s=%s*", groupName, host));
        }
        return groupName;
    }
}

