/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.status.StatusType;

public class CommandUtil {
    private static final Logger LOG = Logger.getInstance(CommandUtil.class);
    private static final Map<Class<?>, JAXBContext> cachedContexts = new ConcurrentHashMap();

    public static void put(@NotNull List<? super String> parameters, boolean condition, @NotNull String value) {
        if (condition) {
            parameters.add(value);
        }
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path) {
        CommandUtil.put(parameters, path.getAbsolutePath(), Revision.UNDEFINED);
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path, boolean usePegRevision) {
        if (usePegRevision) {
            CommandUtil.put(parameters, path);
        } else {
            parameters.add(path.getAbsolutePath());
        }
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull File path, @Nullable Revision pegRevision) {
        CommandUtil.put(parameters, path.getAbsolutePath(), pegRevision);
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull String path, @Nullable Revision pegRevision) {
        parameters.add(CommandUtil.format(path, pegRevision));
    }

    @NotNull
    public static String format(@NotNull String path, @Nullable Revision pegRevision) {
        boolean hasPegRevision;
        StringBuilder builder = new StringBuilder(path);
        boolean hasAtSymbol = path.contains("@");
        boolean bl = hasPegRevision = pegRevision != null && !Revision.UNDEFINED.equals(pegRevision) && !Revision.WORKING.equals(pegRevision) && pegRevision.isValid();
        if (hasPegRevision || hasAtSymbol) {
            builder.append("@");
        }
        if (hasPegRevision) {
            builder.append(CommandUtil.format(pegRevision));
        }
        return builder.toString();
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Target target) {
        CommandUtil.put(parameters, target.getPath(), target.getPegRevision());
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Target target, boolean usePegRevision) {
        if (usePegRevision) {
            CommandUtil.put(parameters, target);
        } else {
            parameters.add(target.getPath());
        }
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Depth depth) {
        CommandUtil.put(parameters, depth, false);
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Depth depth, boolean sticky) {
        if (depth != null && !Depth.UNKNOWN.equals((Object)depth)) {
            parameters.add("--depth");
            parameters.add(depth.getName());
            if (sticky) {
                parameters.add("--set-depth");
                parameters.add(depth.getName());
            }
        }
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable Revision revision) {
        if (revision != null && !Revision.UNDEFINED.equals(revision) && !Revision.WORKING.equals(revision) && revision.isValid()) {
            parameters.add("--revision");
            parameters.add(CommandUtil.format(revision));
        }
    }

    public static void put(@NotNull List<? super String> parameters, @NotNull Revision startRevision, @NotNull Revision endRevision) {
        parameters.add("--revision");
        parameters.add(CommandUtil.format(startRevision) + ":" + CommandUtil.format(endRevision));
    }

    @NotNull
    public static String format(@NotNull Revision revision) {
        return revision.getDate() != null ? "{" + DateFormatUtil.getIso8601Format().format(revision.getDate()) + "}" : revision.toString();
    }

    public static void put(@NotNull List<? super String> parameters, @Nullable DiffOptions diffOptions) {
        if (diffOptions != null) {
            String value;
            StringBuilder builder = new StringBuilder();
            if (diffOptions.isIgnoreAllWhitespace()) {
                builder.append(" --ignore-space-change");
            }
            if (diffOptions.isIgnoreAmountOfWhitespace()) {
                builder.append(" --ignore-all-space");
            }
            if (diffOptions.isIgnoreEOLStyle()) {
                builder.append(" --ignore-eol-style");
            }
            if (!StringUtil.isEmpty((String)(value = builder.toString().trim()))) {
                parameters.add("--extensions");
                parameters.add(value);
            }
        }
    }

    public static void putChangeLists(@NotNull List<? super String> parameters, @Nullable Iterable<String> changeLists) {
        if (changeLists != null) {
            for (String changeList : changeLists) {
                parameters.add("--cl");
                parameters.add(changeList);
            }
        }
    }

    public static String escape(@NotNull String path) {
        return path.contains("@") ? path + "@" : path;
    }

    public static <T> T parse(@NotNull String data, @NotNull Class<T> type) throws JAXBException {
        if (!cachedContexts.containsKey(type)) {
            cachedContexts.put(type, JAXBContext.newInstance((Class[])new Class[]{type}));
        }
        JAXBContext context = cachedContexts.get(type);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(@NotNull ValidationEvent event) {
                return event.getLinkedException() == null;
            }
        });
        return (T)unmarshaller.unmarshal((Reader)new StringReader(data.trim()));
    }

    @NotNull
    public static File getHomeDirectory() {
        return new File(PathManager.getHomePath());
    }

    public static char getStatusChar(@Nullable String type) {
        return !StringUtil.isEmpty((String)type) ? type.charAt(0) : (char)' ';
    }

    @NotNull
    public static StatusType getStatusType(@Nullable String type) {
        return CommandUtil.getStatusType(CommandUtil.getStatusChar(type));
    }

    @NotNull
    public static StatusType getStatusType(char first) {
        StatusType contentsStatus = 'A' == first ? StatusType.STATUS_ADDED : ('D' == first ? StatusType.STATUS_DELETED : ('U' == first ? StatusType.CHANGED : ('C' == first ? StatusType.CONFLICTED : ('G' == first ? StatusType.MERGED : ('R' == first ? StatusType.STATUS_REPLACED : ('E' == first ? StatusType.STATUS_OBSTRUCTED : StatusType.STATUS_NORMAL))))));
        return contentsStatus;
    }

    @Nullable
    public static File findExistingParent(@Nullable File file) {
        while (file != null) {
            if (file.exists() && file.isDirectory()) {
                return file;
            }
            file = file.getParentFile();
        }
        return null;
    }

    @NotNull
    public static File requireExistingParent(@NotNull File file) {
        File result = CommandUtil.findExistingParent(file);
        if (result == null) {
            LOG.error("Existing parent not found for " + file.getAbsolutePath());
        }
        return Objects.requireNonNull(result);
    }
}

