/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.gct.testing.BucketFileMetadata;
import com.google.gct.testing.CloudResultsLoader;
import com.google.gct.testing.ConfigurationInstance;
import com.google.gct.testing.ConfigurationResultListener;
import com.google.gct.testing.TestName;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public class ConfigurationResult {
    public static final String SCREENSHOT_FILENAME_DELIMITER = "-";
    private final ConfigurationInstance configurationInstance;
    private final String bucketName;
    private Optional<String> result = Optional.absent();
    private final Map<String, BucketFileMetadata> fileNameToScreenshotMetadata = new HashMap<String, BucketFileMetadata>();
    private final Map<ScreenshotKey, String> screenshotKeyToFileName = new HashMap<ScreenshotKey, String>();
    private long testDuration = -1L;
    private boolean isComplete;
    private boolean isInfrastructureFailure;
    private boolean isTriggeringError;
    private final List<ConfigurationResultListener> listeners = new LinkedList<ConfigurationResultListener>();

    public ConfigurationResult(String encodedConfigurationString, String bucketName) {
        this.configurationInstance = ConfigurationInstance.parseFromEncodedString(encodedConfigurationString);
        this.bucketName = bucketName;
    }

    public boolean hasResult() {
        return this.result.isPresent();
    }

    public String getResult() {
        return (String)this.result.get();
    }

    public void setResult(String result) {
        this.result = Optional.of((Object)result);
    }

    public ConfigurationInstance getConfigurationInstance() {
        return this.configurationInstance;
    }

    public long getTestDuration() {
        return this.testDuration;
    }

    public void setTestDuration(long testDuration) {
        this.testDuration = testDuration;
    }

    public void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setInfrastructureFailure(boolean infrastructureFailure) {
        this.isInfrastructureFailure = infrastructureFailure;
    }

    public boolean isInfrastructureFailure() {
        return this.isInfrastructureFailure;
    }

    public void setTriggeringError(boolean triggeringError) {
        this.isTriggeringError = triggeringError;
    }

    public boolean isTriggeringError() {
        return this.isTriggeringError;
    }

    public boolean isNoProgressExpected() {
        return this.isComplete() || this.isInfrastructureFailure() || this.isTriggeringError();
    }

    public void addScreenshotMetadata(String fileName, BucketFileMetadata fileMetadata) {
        this.fileNameToScreenshotMetadata.put(fileName, fileMetadata);
        this.screenshotKeyToFileName.put(ConfigurationResult.getScreenshotKey(fileName), fileName);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ConfigurationResultListener listener : ConfigurationResult.this.listeners) {
                    listener.screenshotsUpdated();
                }
            }
        });
    }

    private static ScreenshotKey getScreenshotKey(String fileName) {
        String[] fileNameParts = ConfigurationResult.getFileNameParts(fileName);
        String className = fileNameParts[0];
        String methodName = fileNameParts[1];
        String step = fileNameParts[3].substring(0, fileNameParts[3].indexOf(46));
        return new ScreenshotKey(className, methodName, step);
    }

    private static String[] getFileNameParts(String fileName) {
        String[] originalNameParts;
        try {
            originalNameParts = URLDecoder.decode(fileName, "UTF-8").split(SCREENSHOT_FILENAME_DELIMITER);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding!", e);
        }
        if (originalNameParts.length < 4) {
            System.out.println("Screenshot file name is not formatted properly: " + fileName);
            String[] nameParts = new String[]{"dummyTestClass", "dummyTestMethod", "dummyScreenshotName", "1.jpg"};
            return nameParts;
        }
        String[] nameParts = new String[4];
        nameParts[0] = originalNameParts[0];
        nameParts[1] = originalNameParts[1];
        nameParts[2] = originalNameParts[2];
        for (int i = 3; i < originalNameParts.length - 1; ++i) {
            nameParts[2] = nameParts[2] + SCREENSHOT_FILENAME_DELIMITER + originalNameParts[i];
        }
        nameParts[3] = originalNameParts[originalNameParts.length - 1];
        return nameParts;
    }

    public Map<String, BucketFileMetadata> getScreenshotMetadata() {
        return this.fileNameToScreenshotMetadata;
    }

    public BufferedImage getScreenshotForTestAndStep(TestName testName, int step) {
        String fileName = this.screenshotKeyToFileName.get(new ScreenshotKey(testName, step));
        BufferedImage image = null;
        BucketFileMetadata fileMetadata = this.fileNameToScreenshotMetadata.get(fileName);
        if (fileMetadata == null) {
            return null;
        }
        Optional<byte[]> optionalFileBytes = CloudResultsLoader.getFileBytes(this.bucketName, fileMetadata);
        if (optionalFileBytes.isPresent()) {
            try {
                image = ImageIO.read(new ByteArrayInputStream((byte[])optionalFileBytes.get()));
            }
            catch (IOException e) {
                System.out.println("Failed to create an image for screenshot: " + e.getMessage());
                return null;
            }
            image.flush();
        }
        return image;
    }

    public String getScreenshotNameForTestAndStep(TestName testName, int step) {
        String fileName = this.screenshotKeyToFileName.get(new ScreenshotKey(testName, step));
        return fileName == null ? "" : this.getScreenshotName(fileName);
    }

    private String getScreenshotName(String fileName) {
        String[] fileNameParts = ConfigurationResult.getFileNameParts(fileName);
        return fileNameParts[2];
    }

    public int maxScreenshotStep(final TestName testName) {
        if (this.fileNameToScreenshotMetadata.isEmpty()) {
            return 0;
        }
        return (Integer)Ordering.natural().max(Iterables.transform(this.fileNameToScreenshotMetadata.keySet(), (Function)new Function<String, Integer>(){

            public Integer apply(String fileName) {
                String[] fileNameParts = ConfigurationResult.getFileNameParts(fileName);
                if (testName.getClassName().equals(fileNameParts[0]) && testName.getMethodName().equals(fileNameParts[1])) {
                    return Integer.parseInt(fileNameParts[3].substring(0, fileNameParts[3].indexOf(46)));
                }
                return 0;
            }
        }));
    }

    public void addConfigurationResultListener(ConfigurationResultListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeConfigurationResultListener(ConfigurationResultListener listener) {
        return this.listeners.remove(listener);
    }

    public String toString() {
        return "ConfigurationResult{configurationInstance='" + this.configurationInstance.getResultsViewerDisplayString() + '\'' + ", result=" + this.result + ", isComplete=" + this.isComplete + '}';
    }

    public static void main(String[] args) {
        System.out.println(ConfigurationResult.getScreenshotKey("com.google.android.bootcamp.memegen.test.MemegenUITest%23testCreateMeme%23creatememe%231.bmp"));
        System.out.println(ConfigurationResult.getScreenshotKey("com.google.android.bootcamp.memegen.test.MemegenUITest%23testCreateMeme%23create+meme%231.bmp"));
        System.out.println(ConfigurationResult.getScreenshotKey("com.google.android.bootcamp.memegen.test.MemegenUITest#testCreateMeme#create meme#1.bmp"));
    }

    private static class ScreenshotKey {
        private final String className;
        private final String methodName;
        private final int step;

        private ScreenshotKey(String className, String methodName, String step) {
            this.className = className;
            this.methodName = methodName;
            this.step = Integer.parseInt(step);
        }

        private ScreenshotKey(TestName testName, int step) {
            this.className = testName.getClassName();
            this.methodName = testName.getMethodName();
            this.step = step;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScreenshotKey that = (ScreenshotKey)o;
            if (this.step != that.step) {
                return false;
            }
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            return !(this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null);
        }

        public String toString() {
            return "ScreenshotKey{className='" + this.className + '\'' + ", methodName='" + this.methodName + '\'' + ", step=" + this.step + '}';
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            result = 31 * result + this.step;
            return result;
        }
    }
}

