/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonReaderBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import gnu.trove.TObjectHashingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.internal.impldep.com.google.api.client.repackaged.com.google.common.base.Objects;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.converters.BackwardsCompatibleIdeaModuleDependency;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.tooling.model.java.InstalledJdk;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalBuildIdentifier;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleModuleVersion;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleProject;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleTask;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaContentRoot;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaDependencyScope;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaJavaLanguageSettings;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaLanguageLevel;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaModule;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaModuleDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaProject;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaSingleEntryLibraryDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaSourceDirectory;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalInstalledJdk;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalProjectIdentifier;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;
import org.jetbrains.plugins.gradle.tooling.util.GradleVersionComparator;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public class IdeaProjectSerializationService
implements SerializationService<IdeaProject> {
    private final GradleVersionComparator myGradleVersionComparator;
    private final WriteContext myWriteContext;
    private final ReadContext myReadContext;

    public IdeaProjectSerializationService(@NotNull GradleVersion gradleVersion) {
        this.myGradleVersionComparator = new GradleVersionComparator(gradleVersion.getBaseVersion());
        this.myWriteContext = new WriteContext(this.myGradleVersionComparator);
        this.myReadContext = new ReadContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] write(IdeaProject ideaProject, Class<? extends IdeaProject> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = IonBinaryWriterBuilder.standard().build((OutputStream)out);
        try {
            this.writeProject(writer, this.myWriteContext, ideaProject);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdeaProject read(byte[] object, Class<? extends IdeaProject> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            InternalIdeaProject internalIdeaProject = this.readProject(reader, this.myReadContext);
            return internalIdeaProject;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public Class<? extends IdeaProject> getModelClass() {
        return IdeaProject.class;
    }

    private void writeProject(final IonWriter writer, final WriteContext context, final IdeaProject project) throws IOException {
        context.ideaProjectsCollector.add(project, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "name", project.getName());
                    ToolingStreamApiUtils.writeString(writer, "description", project.getDescription());
                    ToolingStreamApiUtils.writeString(writer, "jdkName", project.getJdkName());
                    IdeaProjectSerializationService.writeJavaLanguageSettings(writer, context, project.getJavaLanguageSettings());
                    ToolingStreamApiUtils.writeString(writer, "languageLevel", project.getLanguageLevel().getLevel());
                    IdeaProjectSerializationService.this.writeModules(writer, context, (DomainObjectSet<? extends IdeaModule>)project.getModules());
                }
                writer.stepOut();
            }
        });
    }

    private void writeModules(IonWriter writer, WriteContext context, DomainObjectSet<? extends IdeaModule> ideaModules) throws IOException {
        writer.setFieldName("ideaModules");
        writer.stepIn(IonType.LIST);
        for (IdeaModule ideaModule : ideaModules) {
            this.writeModule(writer, context, ideaModule);
        }
        writer.stepOut();
    }

    private void writeModule(IonWriter writer, WriteContext context, final IdeaModule ideaModule) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString(writer, "name", ideaModule.getName());
        ToolingStreamApiUtils.writeString(writer, "description", ideaModule.getDescription());
        ToolingStreamApiUtils.writeString(writer, "jdkName", IdeaProjectSerializationService.nullizeUnsupported(new Getter<String>(){

            public String get() {
                return ideaModule.getJdkName();
            }
        }));
        IdeaProjectSerializationService.writeGradleProject(writer, "gradleProject", context, ideaModule.getGradleProject());
        IdeaProjectSerializationService.writeCompilerOutput(writer, context, ideaModule.getCompilerOutput());
        IdeaProjectSerializationService.writeContentRoots(writer, (DomainObjectSet<? extends IdeaContentRoot>)ideaModule.getContentRoots());
        IdeaProjectSerializationService.writeJavaLanguageSettings(writer, context, IdeaProjectSerializationService.nullizeUnsupported(new Getter<IdeaJavaLanguageSettings>(){

            public IdeaJavaLanguageSettings get() {
                return ideaModule.getJavaLanguageSettings();
            }
        }));
        this.writeDependencies(writer, context, (DomainObjectSet<? extends IdeaDependency>)ideaModule.getDependencies());
        writer.stepOut();
    }

    private void writeDependencies(IonWriter writer, WriteContext context, DomainObjectSet<? extends IdeaDependency> dependencies) throws IOException {
        writer.setFieldName("dependencies");
        writer.stepIn(IonType.LIST);
        for (IdeaDependency dependency : dependencies) {
            this.writeDependency(writer, context, dependency);
        }
        writer.stepOut();
    }

    private void writeDependency(IonWriter writer, WriteContext context, IdeaDependency dependency) throws IOException {
        if (dependency instanceof IdeaModuleDependency) {
            this.writeModuleDependency(writer, context, (IdeaModuleDependency)dependency);
        } else if (dependency instanceof IdeaSingleEntryLibraryDependency) {
            IdeaProjectSerializationService.writeLibraryDependency(writer, context, (IdeaSingleEntryLibraryDependency)dependency);
        } else {
            Object unpack = context.modelAdapter.unpack((Object)dependency);
            if (unpack.getClass().getSimpleName().equals("DefaultIdeaModuleDependency")) {
                BackwardsCompatibleIdeaModuleDependency moduleDependency = (BackwardsCompatibleIdeaModuleDependency)context.modelAdapter.adapt(BackwardsCompatibleIdeaModuleDependency.class, unpack);
                this.writeModuleDependency(writer, context, (IdeaModuleDependency)moduleDependency);
            } else if (unpack.getClass().getSimpleName().equals("DefaultIdeaSingleEntryLibraryDependency")) {
                IdeaSingleEntryLibraryDependency libraryDependency = (IdeaSingleEntryLibraryDependency)context.modelAdapter.adapt(IdeaSingleEntryLibraryDependency.class, unpack);
                IdeaProjectSerializationService.writeLibraryDependency(writer, context, libraryDependency);
            }
        }
    }

    private static void writeLibraryDependency(final IonWriter writer, WriteContext context, final IdeaSingleEntryLibraryDependency libraryDependency) throws IOException {
        context.ideaDependenciesCollector.add(libraryDependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "_type", IdeaSingleEntryLibraryDependency.class.getSimpleName());
                    ToolingStreamApiUtils.writeFile(writer, "file", libraryDependency.getFile());
                    ToolingStreamApiUtils.writeFile(writer, "javadoc", libraryDependency.getJavadoc());
                    ToolingStreamApiUtils.writeFile(writer, "source", libraryDependency.getSource());
                    ToolingStreamApiUtils.writeString(writer, "scope", libraryDependency.getScope().getScope());
                    ToolingStreamApiUtils.writeBoolean(writer, "exported", libraryDependency.getExported());
                    writer.setFieldName("gradleModuleVersion");
                    GradleModuleVersion version = libraryDependency.getGradleModuleVersion();
                    if (version != null) {
                        writer.stepIn(IonType.STRUCT);
                        ToolingStreamApiUtils.writeString(writer, "group", version.getGroup());
                        ToolingStreamApiUtils.writeString(writer, "name", version.getName());
                        ToolingStreamApiUtils.writeString(writer, "version", version.getVersion());
                        writer.stepOut();
                    } else {
                        writer.writeNull();
                    }
                }
                writer.stepOut();
            }
        });
    }

    private void writeModuleDependency(final IonWriter writer, WriteContext context, final IdeaModuleDependency moduleDependency) throws IOException {
        context.ideaDependenciesCollector.add(moduleDependency, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "_type", IdeaModuleDependency.class.getSimpleName());
                    ToolingStreamApiUtils.writeString(writer, "targetModuleName", new TargetModuleNameGetter(moduleDependency, IdeaProjectSerializationService.this.myGradleVersionComparator).get());
                    ToolingStreamApiUtils.writeString(writer, "scope", moduleDependency.getScope().getScope());
                    ToolingStreamApiUtils.writeBoolean(writer, "exported", moduleDependency.getExported());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeJavaLanguageSettings(final @NotNull IonWriter writer, @NotNull WriteContext context, final @Nullable IdeaJavaLanguageSettings languageSettings) throws IOException {
        writer.setFieldName("javaLanguageSettings");
        if (languageSettings == null) {
            writer.writeNull();
            return;
        }
        context.ideaJavaLanguageSettingsCollector.add(languageSettings, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "languageLevel", IdeaProjectSerializationService.getJavaVersion(IdeaProjectSerializationService.getLanguageLevel(languageSettings)));
                    ToolingStreamApiUtils.writeString(writer, "targetBytecodeVersion", IdeaProjectSerializationService.getJavaVersion((JavaVersion)IdeaProjectSerializationService.nullizeUnsupported(new TargetBytecodeVersionGetter(languageSettings))));
                    writer.setFieldName("jdk");
                    InstalledJdk jdk = (InstalledJdk)IdeaProjectSerializationService.nullizeUnsupported(new JdkGetter(languageSettings));
                    if (jdk != null) {
                        writer.stepIn(IonType.STRUCT);
                        ToolingStreamApiUtils.writeFile(writer, "javaHome", jdk.getJavaHome());
                        JavaVersion jdkJavaVersion = IdeaProjectSerializationService.getJavaVersion(jdk);
                        ToolingStreamApiUtils.writeString(writer, "javaVersion", jdkJavaVersion == null ? null : jdkJavaVersion.name());
                        writer.stepOut();
                    } else {
                        writer.writeNull();
                    }
                }
                writer.stepOut();
            }
        });
    }

    private static void writeContentRoots(IonWriter writer, DomainObjectSet<? extends IdeaContentRoot> roots) throws IOException {
        writer.setFieldName("contentRoots");
        writer.stepIn(IonType.LIST);
        for (IdeaContentRoot contentRoot : roots) {
            IdeaProjectSerializationService.writeContentRoot(writer, contentRoot);
        }
        writer.stepOut();
    }

    private static void writeContentRoot(IonWriter writer, IdeaContentRoot contentRoot) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeFile(writer, "rootDirectory", contentRoot.getRootDirectory());
        IdeaProjectSerializationService.writeSourceDirectories(writer, "sourceDirectories", (DomainObjectSet<? extends IdeaSourceDirectory>)contentRoot.getSourceDirectories());
        IdeaProjectSerializationService.writeSourceDirectories(writer, "testDirectories", (DomainObjectSet<? extends IdeaSourceDirectory>)contentRoot.getTestDirectories());
        IdeaProjectSerializationService.writeSourceDirectories(writer, "resourceDirectories", IdeaProjectSerializationService.notNullize(IdeaProjectSerializationService.nullizeUnsupported(new ResourceDirectoriesGetter(contentRoot))));
        IdeaProjectSerializationService.writeSourceDirectories(writer, "testResourceDirectories", IdeaProjectSerializationService.notNullize(IdeaProjectSerializationService.nullizeUnsupported(new TestResourceDirectoriesGetter(contentRoot))));
        ToolingStreamApiUtils.writeFiles(writer, "excludeDirectories", contentRoot.getExcludeDirectories());
        writer.stepOut();
    }

    private static void writeSourceDirectories(IonWriter writer, String fieldName, DomainObjectSet<? extends IdeaSourceDirectory> directories) throws IOException {
        writer.setFieldName(fieldName);
        writer.stepIn(IonType.LIST);
        for (IdeaSourceDirectory sourceDirectory : directories) {
            writer.stepIn(IonType.STRUCT);
            ToolingStreamApiUtils.writeBoolean(writer, "generated", sourceDirectory.isGenerated());
            ToolingStreamApiUtils.writeFile(writer, "directory", sourceDirectory.getDirectory());
            writer.stepOut();
        }
        writer.stepOut();
    }

    private static void writeCompilerOutput(final IonWriter writer, WriteContext context, final IdeaCompilerOutput ideaCompilerOutput) throws IOException {
        writer.setFieldName("compilerOutput");
        if (ideaCompilerOutput == null) {
            writer.writeNull();
            return;
        }
        context.ideaCompilerOutputCollector.add(ideaCompilerOutput, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeBoolean(writer, "inheritOutputDirs", ideaCompilerOutput.getInheritOutputDirs());
                    ToolingStreamApiUtils.writeFile(writer, "outputDir", ideaCompilerOutput.getOutputDir());
                    ToolingStreamApiUtils.writeFile(writer, "testOutputDir", ideaCompilerOutput.getTestOutputDir());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeGradleProject(final @NotNull IonWriter writer, @Nullable String fieldName, final @NotNull WriteContext context, final @Nullable GradleProject gradleProject) throws IOException {
        if (fieldName != null) {
            writer.setFieldName(fieldName);
        }
        if (gradleProject == null) {
            writer.writeNull();
            return;
        }
        context.gradleProjectsCollector.add(gradleProject, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "name", gradleProject.getName());
                    ToolingStreamApiUtils.writeString(writer, "description", gradleProject.getDescription());
                    ToolingStreamApiUtils.writeFile(writer, "projectDirectory", gradleProject.getProjectDirectory());
                    IdeaProjectSerializationService.writeProjectIdentifier(writer, context, gradleProject.getProjectIdentifier());
                    ToolingStreamApiUtils.writeFile(writer, "buildDirectory", gradleProject.getBuildDirectory());
                    IdeaProjectSerializationService.writeGradleProject(writer, "parent", context, gradleProject.getParent());
                    writer.setFieldName("children");
                    writer.stepIn(IonType.LIST);
                    for (GradleProject ideaModule : gradleProject.getChildren()) {
                        IdeaProjectSerializationService.writeGradleProject(writer, null, context, ideaModule);
                    }
                    writer.stepOut();
                    ToolingStreamApiUtils.writeFile(writer, "buildScript", gradleProject.getBuildScript().getSourceFile());
                    writer.setFieldName("tasks");
                    writer.stepIn(IonType.LIST);
                    for (GradleTask task : gradleProject.getTasks()) {
                        IdeaProjectSerializationService.writeGradleTask(writer, context, task);
                    }
                    writer.stepOut();
                }
                writer.stepOut();
            }
        });
    }

    private static void writeGradleTask(final IonWriter writer, final WriteContext context, final @Nullable GradleTask task) throws IOException {
        if (task == null) {
            writer.writeNull();
            return;
        }
        context.gradleTasksCollector.add(task, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "name", task.getName());
                    ToolingStreamApiUtils.writeString(writer, "description", task.getDescription());
                    ToolingStreamApiUtils.writeString(writer, "path", task.getPath());
                    ToolingStreamApiUtils.writeString(writer, "group", task.getGroup());
                    ToolingStreamApiUtils.writeString(writer, "displayName", task.getDisplayName());
                    ToolingStreamApiUtils.writeBoolean(writer, "isPublic", task.isPublic());
                    IdeaProjectSerializationService.writeProjectIdentifier(writer, context, task.getProjectIdentifier());
                    IdeaProjectSerializationService.writeGradleProject(writer, "project", context, task.getProject());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeProjectIdentifier(final IonWriter writer, final WriteContext context, final ProjectIdentifier projectIdentifier) throws IOException {
        writer.setFieldName("projectIdentifier");
        if (projectIdentifier == null) {
            writer.writeNull();
            return;
        }
        context.projectIdentifiersCollector.add(projectIdentifier, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "projectPath", projectIdentifier.getProjectPath());
                    IdeaProjectSerializationService.writeBuildIdentifier(writer, context, projectIdentifier.getBuildIdentifier());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeBuildIdentifier(final IonWriter writer, WriteContext context, final BuildIdentifier buildIdentifier) throws IOException {
        writer.setFieldName("buildIdentifier");
        context.buildIdentifiersCollector.add(buildIdentifier, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeFile(writer, "rootDir", buildIdentifier.getRootDir());
                }
                writer.stepOut();
            }
        });
    }

    @Nullable
    private InternalIdeaProject readProject(final @NotNull IonReader reader, final @NotNull ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaProject project = context.projectsMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), new IntObjectMap.ObjectFactory<InternalIdeaProject>(){

            @Override
            public InternalIdeaProject newInstance() {
                return new InternalIdeaProject();
            }

            @Override
            public void fill(InternalIdeaProject ideaProject) {
                ideaProject.setName(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "name")));
                ideaProject.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
                ideaProject.setJdkName(ToolingStreamApiUtils.readString(reader, "jdkName"));
                ideaProject.setJavaLanguageSettings(IdeaProjectSerializationService.readJavaLanguageSettings(reader, context));
                ideaProject.setLanguageLevel(new InternalIdeaLanguageLevel(ToolingStreamApiUtils.readString(reader, "languageLevel")));
                IdeaProjectSerializationService.this.readModules(reader, context, ideaProject);
            }
        });
        reader.stepOut();
        return project;
    }

    private void readModules(IonReader reader, ReadContext context, InternalIdeaProject project) {
        InternalIdeaModule ideaModule;
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "ideaModules");
        reader.stepIn();
        ArrayList<InternalIdeaModule> ideaModules = new ArrayList<InternalIdeaModule>();
        while ((ideaModule = this.readModule(reader, context)) != null) {
            ideaModule.setParent(project);
            ideaModules.add(ideaModule);
        }
        project.setModules(ideaModules);
        reader.stepOut();
    }

    @Nullable
    private InternalIdeaModule readModule(IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaModule ideaModule = new InternalIdeaModule();
        ideaModule.setName(ToolingStreamApiUtils.readString(reader, "name"));
        ideaModule.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
        ideaModule.setJdkName(ToolingStreamApiUtils.readString(reader, "jdkName"));
        ideaModule.setGradleProject(IdeaProjectSerializationService.readGradleProject(reader, context, "gradleProject"));
        ideaModule.setCompilerOutput(IdeaProjectSerializationService.readCompilerOutput(reader, context));
        ideaModule.setContentRoots(this.readContentRoots(reader));
        ideaModule.setJavaLanguageSettings(IdeaProjectSerializationService.readJavaLanguageSettings(reader, context));
        ideaModule.setDependencies(IdeaProjectSerializationService.readDependencies(reader, context));
        reader.stepOut();
        return ideaModule;
    }

    private static List<InternalIdeaDependency> readDependencies(IonReader reader, ReadContext context) {
        InternalIdeaDependency dependency;
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "dependencies");
        reader.stepIn();
        ArrayList<InternalIdeaDependency> dependencies = new ArrayList<InternalIdeaDependency>();
        while ((dependency = IdeaProjectSerializationService.readDependency(reader, context)) != null) {
            dependencies.add(dependency);
        }
        reader.stepOut();
        return dependencies;
    }

    private static InternalIdeaDependency readDependency(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaDependency dependency = context.dependenciesMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<InternalIdeaDependency>(){

            @Override
            public InternalIdeaDependency create() {
                String type = ToolingStreamApiUtils.readString(reader, "_type");
                if (IdeaModuleDependency.class.getSimpleName().equals(type)) {
                    InternalIdeaModuleDependency moduleDependency = new InternalIdeaModuleDependency();
                    moduleDependency.setTargetModuleName(ToolingStreamApiUtils.readString(reader, "targetModuleName"));
                    moduleDependency.setScope(InternalIdeaDependencyScope.getInstance(ToolingStreamApiUtils.readString(reader, "scope")));
                    moduleDependency.setExported(ToolingStreamApiUtils.readBoolean(reader, "exported"));
                    return moduleDependency;
                }
                if (IdeaSingleEntryLibraryDependency.class.getSimpleName().equals(type)) {
                    File file = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readFile(reader, "file"));
                    InternalIdeaSingleEntryLibraryDependency libraryDependency = new InternalIdeaSingleEntryLibraryDependency(file);
                    libraryDependency.setJavadoc(ToolingStreamApiUtils.readFile(reader, "javadoc"));
                    libraryDependency.setSource(ToolingStreamApiUtils.readFile(reader, "source"));
                    libraryDependency.setScope(InternalIdeaDependencyScope.getInstance(ToolingStreamApiUtils.readString(reader, "scope")));
                    libraryDependency.setExported(ToolingStreamApiUtils.readBoolean(reader, "exported"));
                    IonType ionType = reader.next();
                    ToolingStreamApiUtils.assertFieldName(reader, "gradleModuleVersion");
                    if (ionType != IonType.NULL) {
                        reader.stepIn();
                        InternalGradleModuleVersion moduleVersion = new InternalGradleModuleVersion();
                        moduleVersion.setGroup(ToolingStreamApiUtils.readString(reader, "group"));
                        moduleVersion.setName(ToolingStreamApiUtils.readString(reader, "name"));
                        moduleVersion.setVersion(ToolingStreamApiUtils.readString(reader, "version"));
                        reader.stepOut();
                        libraryDependency.setModuleVersion(moduleVersion);
                    }
                    return libraryDependency;
                }
                throw new RuntimeException("Unsupported dependency '" + type + "'");
            }
        });
        reader.stepOut();
        return dependency;
    }

    @NotNull
    private List<InternalIdeaContentRoot> readContentRoots(IonReader reader) {
        InternalIdeaContentRoot child;
        reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "contentRoots");
        reader.stepIn();
        ArrayList<InternalIdeaContentRoot> contentRoots = new ArrayList<InternalIdeaContentRoot>();
        while ((child = this.readContentRoot(reader)) != null) {
            contentRoots.add(child);
        }
        reader.stepOut();
        return contentRoots;
    }

    private InternalIdeaContentRoot readContentRoot(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaContentRoot contentRoot = new InternalIdeaContentRoot(this.myGradleVersionComparator);
        contentRoot.setRootDirectory(ToolingStreamApiUtils.readFile(reader, "rootDirectory"));
        contentRoot.setSourceDirectories(IdeaProjectSerializationService.readSourceDirectories(reader, "sourceDirectories"));
        contentRoot.setTestDirectories(IdeaProjectSerializationService.readSourceDirectories(reader, "testDirectories"));
        contentRoot.setResourceDirectories(IdeaProjectSerializationService.readSourceDirectories(reader, "resourceDirectories"));
        contentRoot.setTestResourceDirectories(IdeaProjectSerializationService.readSourceDirectories(reader, "testResourceDirectories"));
        contentRoot.setExcludeDirectories(ToolingStreamApiUtils.readFilesSet(reader, "excludeDirectories"));
        reader.stepOut();
        return contentRoot;
    }

    private static Set<InternalIdeaSourceDirectory> readSourceDirectories(IonReader reader, String fieldName) {
        InternalIdeaSourceDirectory sourceDirectory;
        IonType ionType = reader.next();
        if (fieldName != null) {
            ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        }
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        LinkedHashSet<InternalIdeaSourceDirectory> sourceDirectories = new LinkedHashSet<InternalIdeaSourceDirectory>();
        while ((sourceDirectory = IdeaProjectSerializationService.readSourceDirectory(reader)) != null) {
            sourceDirectories.add(sourceDirectory);
        }
        reader.stepOut();
        return sourceDirectories;
    }

    private static InternalIdeaSourceDirectory readSourceDirectory(IonReader reader) {
        IonType ionType = reader.next();
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaSourceDirectory sourceDirectory = new InternalIdeaSourceDirectory();
        sourceDirectory.setGenerated(ToolingStreamApiUtils.readBoolean(reader, "generated"));
        sourceDirectory.setDirectory(ToolingStreamApiUtils.readFile(reader, "directory"));
        reader.stepOut();
        return sourceDirectory;
    }

    private static InternalIdeaCompilerOutput readCompilerOutput(final IonReader reader, ReadContext context) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "compilerOutput");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaCompilerOutput project = context.compilerOutputsMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<InternalIdeaCompilerOutput>(){

            @Override
            public InternalIdeaCompilerOutput create() {
                InternalIdeaCompilerOutput compilerOutput = new InternalIdeaCompilerOutput();
                compilerOutput.setInheritOutputDirs(ToolingStreamApiUtils.readBoolean(reader, "inheritOutputDirs"));
                compilerOutput.setOutputDir(ToolingStreamApiUtils.readFile(reader, "outputDir"));
                compilerOutput.setTestOutputDir(ToolingStreamApiUtils.readFile(reader, "testOutputDir"));
                return compilerOutput;
            }
        });
        reader.stepOut();
        return project;
    }

    @Nullable
    private static InternalGradleProject readGradleProject(final IonReader reader, final ReadContext context, String fieldName) {
        IonType ionType = reader.next();
        if (fieldName != null) {
            ToolingStreamApiUtils.assertFieldName(reader, fieldName);
        }
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalGradleProject project = context.gradleProjectsMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), new IntObjectMap.ObjectFactory<InternalGradleProject>(){

            @Override
            public InternalGradleProject newInstance() {
                return new InternalGradleProject();
            }

            @Override
            public void fill(InternalGradleProject gradleProject) {
                InternalGradleTask task;
                InternalGradleProject child;
                gradleProject.setName(ToolingStreamApiUtils.readString(reader, "name"));
                gradleProject.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
                gradleProject.setProjectDirectory(ToolingStreamApiUtils.readFile(reader, "projectDirectory"));
                gradleProject.setProjectIdentifier(IdeaProjectSerializationService.readProjectIdentifier(reader, context));
                gradleProject.setBuildDirectory(ToolingStreamApiUtils.readFile(reader, "buildDirectory"));
                gradleProject.setParent(IdeaProjectSerializationService.readGradleProject(reader, context, "parent"));
                reader.next();
                ToolingStreamApiUtils.assertFieldName(reader, "children");
                reader.stepIn();
                ArrayList<InternalGradleProject> children = new ArrayList<InternalGradleProject>();
                while ((child = IdeaProjectSerializationService.readGradleProject(reader, context, null)) != null) {
                    children.add(child);
                }
                gradleProject.setChildren(children);
                reader.stepOut();
                gradleProject.getBuildScript().setSourceFile(ToolingStreamApiUtils.readFile(reader, "buildScript"));
                reader.next();
                ToolingStreamApiUtils.assertFieldName(reader, "tasks");
                reader.stepIn();
                ArrayList<InternalGradleTask> tasks = new ArrayList<InternalGradleTask>();
                while ((task = IdeaProjectSerializationService.readGradleTask(reader, context)) != null) {
                    tasks.add(task);
                }
                gradleProject.setTasks(tasks);
                reader.stepOut();
            }
        });
        reader.stepOut();
        return project;
    }

    private static InternalGradleTask readGradleTask(final IonReader reader, final ReadContext context) {
        IonType ionType = reader.next();
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalGradleTask project = context.tasksMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), new IntObjectMap.ObjectFactory<InternalGradleTask>(){

            @Override
            public InternalGradleTask newInstance() {
                return new InternalGradleTask();
            }

            @Override
            public void fill(InternalGradleTask gradleTask) {
                gradleTask.setName(ToolingStreamApiUtils.readString(reader, "name"));
                gradleTask.setDescription(ToolingStreamApiUtils.readString(reader, "description"));
                gradleTask.setPath(ToolingStreamApiUtils.readString(reader, "path"));
                gradleTask.setGroup(ToolingStreamApiUtils.readString(reader, "group"));
                gradleTask.setDisplayName(ToolingStreamApiUtils.readString(reader, "displayName"));
                gradleTask.setPublic(ToolingStreamApiUtils.readBoolean(reader, "isPublic"));
                gradleTask.setProjectIdentifier(IdeaProjectSerializationService.readProjectIdentifier(reader, context));
                gradleTask.setGradleProject(IdeaProjectSerializationService.readGradleProject(reader, context, "project"));
            }
        });
        reader.stepOut();
        return project;
    }

    private static InternalProjectIdentifier readProjectIdentifier(final IonReader reader, final ReadContext context) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "projectIdentifier");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalProjectIdentifier dependency = context.projectsIdentifiersMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<InternalProjectIdentifier>(){

            @Override
            public InternalProjectIdentifier create() {
                String projectPath = ToolingStreamApiUtils.readString(reader, "projectPath");
                InternalBuildIdentifier buildIdentifier = IdeaProjectSerializationService.readBuildIdentifier(reader, context);
                return new InternalProjectIdentifier(buildIdentifier, projectPath);
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static InternalBuildIdentifier readBuildIdentifier(final IonReader reader, ReadContext context) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "buildIdentifier");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalBuildIdentifier buildIdentifier = context.buildsIdentifiersMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<InternalBuildIdentifier>(){

            @Override
            public InternalBuildIdentifier create() {
                return new InternalBuildIdentifier(ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readFile(reader, "rootDir")));
            }
        });
        reader.stepOut();
        return buildIdentifier;
    }

    private static InternalIdeaJavaLanguageSettings readJavaLanguageSettings(final IonReader reader, ReadContext context) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "javaLanguageSettings");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        InternalIdeaJavaLanguageSettings dependency = context.languageSettingsMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), new IntObjectMap.SimpleObjectFactory<InternalIdeaJavaLanguageSettings>(){

            @Override
            public InternalIdeaJavaLanguageSettings create() {
                String bytecodeVersion;
                InternalIdeaJavaLanguageSettings languageSettings = new InternalIdeaJavaLanguageSettings();
                String languageLevel = ToolingStreamApiUtils.readString(reader, "languageLevel");
                if (languageLevel != null) {
                    languageSettings.setLanguageLevel(JavaVersion.valueOf((String)languageLevel));
                }
                if ((bytecodeVersion = ToolingStreamApiUtils.readString(reader, "targetBytecodeVersion")) != null) {
                    languageSettings.setTargetBytecodeVersion(JavaVersion.valueOf((String)bytecodeVersion));
                }
                languageSettings.setJdk(IdeaProjectSerializationService.readJdk(reader));
                return languageSettings;
            }
        });
        reader.stepOut();
        return dependency;
    }

    @Nullable
    private static InternalInstalledJdk readJdk(IonReader reader) {
        IonType ionType = reader.next();
        ToolingStreamApiUtils.assertFieldName(reader, "jdk");
        if (ionType == IonType.NULL || ionType == null) {
            return null;
        }
        reader.stepIn();
        File javaHome = ToolingStreamApiUtils.readFile(reader, "javaHome");
        String versionString = ToolingStreamApiUtils.readString(reader, "javaVersion");
        JavaVersion javaVersion = versionString == null ? null : JavaVersion.valueOf((String)versionString);
        InternalInstalledJdk jdk = new InternalInstalledJdk(javaHome, javaVersion);
        reader.stepOut();
        return jdk;
    }

    @Nullable
    private static String getJavaVersion(@Nullable JavaVersion javaVersion) {
        return javaVersion == null ? null : javaVersion.name();
    }

    @Nullable
    private static JavaVersion getLanguageLevel(@NotNull IdeaJavaLanguageSettings languageSettings) {
        try {
            return languageSettings.getLanguageLevel();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static JavaVersion getTargetBytecodeVersion(@NotNull IdeaJavaLanguageSettings languageSettings) {
        try {
            return languageSettings.getTargetBytecodeVersion();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static JavaVersion getJavaVersion(@NotNull InstalledJdk jdk) {
        try {
            return jdk.getJavaVersion();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static <T> T nullizeUnsupported(Getter<T> getter) {
        try {
            return (T)getter.get();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @NotNull
    public static <T> DomainObjectSet<T> notNullize(@Nullable DomainObjectSet<T> set) {
        return set == null ? GradleContainerUtil.emptyDomainObjectSet() : set;
    }

    private static class TargetModuleNameGetter
    implements Getter<String> {
        private final IdeaModuleDependency myModuleDependency;
        private final GradleVersionComparator myGradleVersionComparator;

        private TargetModuleNameGetter(@NotNull IdeaModuleDependency moduleDependency, @NotNull GradleVersionComparator gradleVersionComparator) {
            this.myModuleDependency = moduleDependency;
            this.myGradleVersionComparator = gradleVersionComparator;
        }

        public String get() {
            if (this.myModuleDependency instanceof BackwardsCompatibleIdeaModuleDependency && this.myGradleVersionComparator.lessThan("3.1")) {
                return ((BackwardsCompatibleIdeaModuleDependency)this.myModuleDependency).getDependencyModule().getName();
            }
            return this.myModuleDependency.getTargetModuleName();
        }
    }

    private static class TestResourceDirectoriesGetter
    implements Getter<DomainObjectSet<? extends IdeaSourceDirectory>> {
        private final IdeaContentRoot myContentRoot;

        private TestResourceDirectoriesGetter(IdeaContentRoot contentRoot) {
            this.myContentRoot = contentRoot;
        }

        public DomainObjectSet<? extends IdeaSourceDirectory> get() {
            return this.myContentRoot.getTestResourceDirectories();
        }
    }

    private static class ResourceDirectoriesGetter
    implements Getter<DomainObjectSet<? extends IdeaSourceDirectory>> {
        private final IdeaContentRoot myContentRoot;

        private ResourceDirectoriesGetter(IdeaContentRoot contentRoot) {
            this.myContentRoot = contentRoot;
        }

        public DomainObjectSet<? extends IdeaSourceDirectory> get() {
            return this.myContentRoot.getResourceDirectories();
        }
    }

    private static class JavaHomePathGetter
    implements Getter<String> {
        private final IdeaJavaLanguageSettings myObject;

        private JavaHomePathGetter(IdeaJavaLanguageSettings object) {
            this.myObject = object;
        }

        public String get() {
            InstalledJdk jdk = this.myObject.getJdk();
            if (jdk != null) {
                File home = jdk.getJavaHome();
                return home == null ? null : home.getPath();
            }
            return null;
        }
    }

    private static class JdkGetter
    implements Getter<InstalledJdk> {
        private final IdeaJavaLanguageSettings myObject;

        private JdkGetter(IdeaJavaLanguageSettings object) {
            this.myObject = object;
        }

        public InstalledJdk get() {
            return this.myObject.getJdk();
        }
    }

    private static class TargetBytecodeVersionGetter
    implements Getter<JavaVersion> {
        private final IdeaJavaLanguageSettings myObject;

        private TargetBytecodeVersionGetter(IdeaJavaLanguageSettings object) {
            this.myObject = object;
        }

        public JavaVersion get() {
            return IdeaProjectSerializationService.getTargetBytecodeVersion(this.myObject);
        }
    }

    private static class WriteContext {
        private final ProtocolToModelAdapter modelAdapter = new ProtocolToModelAdapter();
        private final GradleVersionComparator myGradleVersionComparator;
        private final ObjectCollector<IdeaProject, IOException> ideaProjectsCollector = new ObjectCollector(new TObjectHashingStrategy<IdeaProject>(){

            public int computeHashCode(IdeaProject object) {
                return object == null ? 0 : object.getName().hashCode();
            }

            public boolean equals(IdeaProject o1, IdeaProject o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 != null && o2 != null) {
                    DomainObjectSet modules1 = o1.getModules();
                    DomainObjectSet modules2 = o2.getModules();
                    if (modules1.size() != modules2.size()) {
                        return false;
                    }
                    BuildIdentifier buildIdentifier1 = ((IdeaModule)modules1.getAt(0)).getGradleProject().getProjectIdentifier().getBuildIdentifier();
                    BuildIdentifier buildIdentifier2 = ((IdeaModule)modules2.getAt(0)).getGradleProject().getProjectIdentifier().getBuildIdentifier();
                    return WriteContext.isSameBuild(buildIdentifier1, buildIdentifier2);
                }
                return false;
            }
        });
        private final ObjectCollector<GradleProject, IOException> gradleProjectsCollector = new ObjectCollector(new TObjectHashingStrategy<GradleProject>(){

            public int computeHashCode(GradleProject object) {
                return object == null ? 0 : object.getPath().hashCode();
            }

            public boolean equals(GradleProject o1, GradleProject o2) {
                return o1 == o2 || o1 != null && o2 != null && WriteContext.isSameProject(o1.getProjectIdentifier(), o2.getProjectIdentifier());
            }
        });
        private final ObjectCollector<IdeaCompilerOutput, IOException> ideaCompilerOutputCollector = new ObjectCollector(new TObjectHashingStrategy<IdeaCompilerOutput>(){

            public int computeHashCode(IdeaCompilerOutput object) {
                return Objects.hashCode((Object[])new Object[]{object.getInheritOutputDirs(), object.getOutputDir(), object.getTestOutputDir()});
            }

            public boolean equals(IdeaCompilerOutput o1, IdeaCompilerOutput o2) {
                return o1 == o2 || o1 != null && o2 != null && o1.getInheritOutputDirs() == o1.getInheritOutputDirs() && Comparing.compare((Object)o1.getOutputDir(), (Object)o2.getOutputDir(), (Comparator)new FilePathComparator()) == 0 && Comparing.compare((Comparable)o1.getTestOutputDir(), (Comparable)o2.getTestOutputDir()) == 0;
            }
        });
        private final ObjectCollector<GradleTask, IOException> gradleTasksCollector = new ObjectCollector(new TObjectHashingStrategy<GradleTask>(){

            public int computeHashCode(GradleTask object) {
                return object == null ? 0 : object.getPath().hashCode();
            }

            public boolean equals(GradleTask o1, GradleTask o2) {
                return o1 == o2 || o1 != null && o2 != null && o1.getPath().equals(o2.getPath()) && WriteContext.isSameProject(o1.getProjectIdentifier(), o2.getProjectIdentifier());
            }
        });
        private final ObjectCollector<IdeaDependency, IOException> ideaDependenciesCollector = new ObjectCollector(new TObjectHashingStrategy<IdeaDependency>(){

            public int computeHashCode(IdeaDependency object) {
                if (object == null) {
                    return 0;
                }
                if (object instanceof IdeaModuleDependency) {
                    return this.computeHashCode((IdeaModuleDependency)object);
                }
                if (object instanceof IdeaSingleEntryLibraryDependency) {
                    return this.computeHashCode((IdeaSingleEntryLibraryDependency)object);
                }
                return object.hashCode();
            }

            public boolean equals(IdeaDependency o1, IdeaDependency o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 != null && o2 != null) {
                    if (o1 instanceof IdeaModuleDependency && o2 instanceof IdeaModuleDependency) {
                        return this.equals((IdeaModuleDependency)o1, (IdeaModuleDependency)o2);
                    }
                    if (o1 instanceof IdeaSingleEntryLibraryDependency && o2 instanceof IdeaSingleEntryLibraryDependency) {
                        return this.equals((IdeaSingleEntryLibraryDependency)o1, (IdeaSingleEntryLibraryDependency)o2);
                    }
                }
                return false;
            }

            private int computeHashCode(@NotNull IdeaModuleDependency object) {
                return Objects.hashCode((Object[])new Object[]{new TargetModuleNameGetter(object, WriteContext.this.myGradleVersionComparator).get(), object.getScope().getScope()});
            }

            private int computeHashCode(@NotNull IdeaSingleEntryLibraryDependency object) {
                return Objects.hashCode((Object[])new Object[]{object.getFile(), object.getScope().getScope(), this.hasCode(object.getGradleModuleVersion())});
            }

            private int hasCode(@Nullable GradleModuleVersion version) {
                return version == null ? 0 : Objects.hashCode((Object[])new Object[]{version.getGroup(), version.getName(), version.getVersion()});
            }

            private boolean equals(@NotNull IdeaModuleDependency o1, @NotNull IdeaModuleDependency o2) {
                return o1.getExported() == o2.getExported() && Objects.equal((Object)new TargetModuleNameGetter(o1, WriteContext.this.myGradleVersionComparator).get(), (Object)new TargetModuleNameGetter(o2, WriteContext.this.myGradleVersionComparator).get()) && Objects.equal((Object)o1.getScope().getScope(), (Object)o2.getScope().getScope());
            }

            private boolean equals(@NotNull IdeaSingleEntryLibraryDependency o1, @NotNull IdeaSingleEntryLibraryDependency o2) {
                return o1.getExported() == o2.getExported() && this.equal(o1.getGradleModuleVersion(), o2.getGradleModuleVersion()) && Objects.equal((Object)o1.getFile().getPath(), (Object)o2.getFile().getPath()) && Objects.equal((Object)o1.getScope().getScope(), (Object)o2.getScope().getScope());
            }

            private boolean equal(@Nullable GradleModuleVersion version1, @Nullable GradleModuleVersion version2) {
                return version1 == version2 || version1 != null && version2 != null && Objects.equal((Object)version1.getName(), (Object)version2.getName()) && Objects.equal((Object)version1.getGroup(), (Object)version2.getGroup()) && Objects.equal((Object)version1.getVersion(), (Object)version2.getVersion());
            }
        });
        private final ObjectCollector<IdeaJavaLanguageSettings, IOException> ideaJavaLanguageSettingsCollector = new ObjectCollector(new TObjectHashingStrategy<IdeaJavaLanguageSettings>(){

            public int computeHashCode(IdeaJavaLanguageSettings object) {
                return object == null ? 0 : Objects.hashCode((Object[])new Object[]{IdeaProjectSerializationService.getLanguageLevel(object), IdeaProjectSerializationService.nullizeUnsupported(new TargetBytecodeVersionGetter(object)), IdeaProjectSerializationService.nullizeUnsupported(new JavaHomePathGetter(object))});
            }

            public boolean equals(IdeaJavaLanguageSettings o1, IdeaJavaLanguageSettings o2) {
                return o1 == o2 || o1 != null && o2 != null && IdeaProjectSerializationService.getLanguageLevel(o1) == IdeaProjectSerializationService.getLanguageLevel(o2) && Objects.equal((Object)IdeaProjectSerializationService.nullizeUnsupported(new TargetBytecodeVersionGetter(o1)), (Object)IdeaProjectSerializationService.nullizeUnsupported(new TargetBytecodeVersionGetter(o2))) && Objects.equal((Object)IdeaProjectSerializationService.nullizeUnsupported(new JavaHomePathGetter(o1)), (Object)IdeaProjectSerializationService.nullizeUnsupported(new JavaHomePathGetter(o2)));
            }
        });
        private final ObjectCollector<ProjectIdentifier, IOException> projectIdentifiersCollector = new ObjectCollector(new TObjectHashingStrategy<ProjectIdentifier>(){

            public int computeHashCode(ProjectIdentifier object) {
                return object == null ? 0 : object.getProjectPath().hashCode();
            }

            public boolean equals(ProjectIdentifier o1, ProjectIdentifier o2) {
                return o1 == o2 || o1 != null && o2 != null && WriteContext.isSameProject(o1, o2);
            }
        });
        private final ObjectCollector<BuildIdentifier, IOException> buildIdentifiersCollector = new ObjectCollector(new TObjectHashingStrategy<BuildIdentifier>(){

            public int computeHashCode(BuildIdentifier object) {
                return object == null ? 0 : object.getRootDir().getPath().hashCode();
            }

            public boolean equals(BuildIdentifier o1, BuildIdentifier o2) {
                return o1 == o2 || o1 != null && o2 != null && WriteContext.isSameBuild(o1, o2);
            }
        });

        private WriteContext(GradleVersionComparator gradleVersionComparator) {
            this.myGradleVersionComparator = gradleVersionComparator;
        }

        private static boolean isSameBuild(BuildIdentifier buildIdentifier1, BuildIdentifier buildIdentifier2) {
            String rootBuildPath1 = buildIdentifier1.getRootDir().getPath();
            String rootBuildPath2 = buildIdentifier2.getRootDir().getPath();
            return rootBuildPath1.equals(rootBuildPath2);
        }

        private static boolean isSameProject(ProjectIdentifier o1, ProjectIdentifier o2) {
            if (o1 == null || o2 == null) {
                return false;
            }
            if (!o1.getProjectPath().equals(o2.getProjectPath())) {
                return false;
            }
            return WriteContext.isSameBuild(o1.getBuildIdentifier(), o2.getBuildIdentifier());
        }

        private static class FilePathComparator
        implements Comparator<File> {
            private FilePathComparator() {
            }

            @Override
            public int compare(File o1, File o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        }
    }

    private static class ReadContext {
        private final IntObjectMap<InternalIdeaProject> projectsMap = new IntObjectMap();
        private final IntObjectMap<InternalIdeaJavaLanguageSettings> languageSettingsMap = new IntObjectMap();
        private final IntObjectMap<InternalGradleProject> gradleProjectsMap = new IntObjectMap();
        private final IntObjectMap<InternalProjectIdentifier> projectsIdentifiersMap = new IntObjectMap();
        private final IntObjectMap<InternalBuildIdentifier> buildsIdentifiersMap = new IntObjectMap();
        private final IntObjectMap<InternalGradleTask> tasksMap = new IntObjectMap();
        private final IntObjectMap<InternalIdeaCompilerOutput> compilerOutputsMap = new IntObjectMap();
        private final IntObjectMap<InternalIdeaDependency> dependenciesMap = new IntObjectMap();

        private ReadContext() {
        }
    }
}

