/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.util.ExceptionUtilRt;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.Message;

@ApiStatus.Experimental
public final class MessageBuilder {
    @Nullable
    private String myGroup;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myText;
    @Nullable
    private Exception myException;
    @NotNull
    private Message.Kind myKind = Message.Kind.INFO;
    @Nullable
    private String myFilePath;
    private int myLine;
    private int myColumn;

    private MessageBuilder(@NotNull String title, @NotNull String text) {
        this.myTitle = title;
        this.myText = text;
    }

    public static MessageBuilder create(@NotNull String title, @NotNull String text) {
        return new MessageBuilder(title, text);
    }

    public final MessageBuilder warning() {
        this.myKind = Message.Kind.WARNING;
        return this;
    }

    public final MessageBuilder error() {
        this.myKind = Message.Kind.ERROR;
        return this;
    }

    public final MessageBuilder withGroup(String group) {
        this.myGroup = group;
        return this;
    }

    public final MessageBuilder withException(Exception e) {
        this.myException = e;
        return this;
    }

    public MessageBuilder withLocation(String filePath, int line, int column) {
        this.myFilePath = filePath;
        this.myLine = line;
        this.myColumn = column;
        return this;
    }

    @NotNull
    public Message build() {
        String text = this.myText;
        if (this.myException != null) {
            text = this.myException.getStackTrace().length > 0 ? text + "\n\n" + MessageBuilder.getErrorMessage(this.myException) : text + "\n\n" + this.myException.getMessage();
        }
        Message.FilePosition filePosition = this.myFilePath == null ? null : new Message.FilePosition(this.myFilePath, this.myLine, this.myColumn);
        return new Message(this.myTitle, text, this.myGroup, this.myKind, filePosition);
    }

    public String buildJson() {
        return new GsonBuilder().create().toJson((Object)this.build());
    }

    @Contract(value="null -> null; !null->!null")
    private static String getErrorMessage(@Nullable Throwable e) {
        if (e == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        ExternalSystemException esException = (ExternalSystemException)ExceptionUtilRt.findCause((Throwable)e, ExternalSystemException.class);
        if (esException != null && esException != e) {
            sw.append("\nCaused by: ").append(esException.getOriginalReason());
        }
        return sw.toString();
    }
}

