/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling;

import org.gradle.api.Project;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.MessageBuilder;

public final class ErrorMessageBuilder {
    @NotNull
    private final Project myProject;
    @Nullable
    private final Exception myException;
    @NotNull
    private final String myGroup;
    @Nullable
    private String myDescription;

    private ErrorMessageBuilder(@NotNull Project project, @Nullable Exception exception, @NotNull String group) {
        this.myProject = project;
        this.myException = exception;
        this.myGroup = group;
    }

    public static ErrorMessageBuilder create(@NotNull Project project, @NotNull String group) {
        return new ErrorMessageBuilder(project, null, group);
    }

    public static ErrorMessageBuilder create(@NotNull Project project, @Nullable Exception exception, @NotNull String group) {
        return new ErrorMessageBuilder(project, exception, group);
    }

    public ErrorMessageBuilder withDescription(@NotNull String description) {
        this.myDescription = description;
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public String build() {
        Message message = this.buildMessage();
        return new GsonBuilder().create().toJson((Object)message);
    }

    @ApiStatus.Internal
    public Message buildMessage() {
        String message = this.myDescription != null ? this.myDescription : "";
        String projectDisplayName = ErrorMessageBuilder.getDisplayName(this.myProject);
        String title = this.myException != null ? ErrorMessageBuilder.getRootCauseMessage(this.myException) : (this.myDescription != null ? this.myDescription : this.myGroup);
        title = projectDisplayName + ": " + title;
        return MessageBuilder.create(title, message).warning().withException(this.myException).withGroup(this.myGroup).withLocation(this.myProject.getBuildFile().getPath(), 0, 0).build();
    }

    @NotNull
    private static String getDisplayName(@NotNull Project project) {
        String projectDisplayName;
        if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"3.3")) < 0) {
            StringBuilder builder = new StringBuilder();
            if (project.getParent() == null && project.getGradle().getParent() == null) {
                builder.append("root project '");
                builder.append(project.getName());
                builder.append('\'');
            } else {
                builder.append("project '");
                builder.append(project.getPath());
                builder.append("'");
            }
            projectDisplayName = builder.toString();
        } else {
            projectDisplayName = project.getDisplayName();
        }
        return projectDisplayName;
    }

    @NotNull
    private static String getRootCauseMessage(@NotNull Throwable e) {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e.getMessage();
    }
}

