/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.internal.statistic.actions.TestParseEventsSchemeDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestParseEventsSchemeAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            PsiFile fileType = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            Editor editor = fileType != null && StringUtil.equalsIgnoreCase((CharSequence)fileType.getFileType().getName(), (CharSequence)"json") ? (Editor)e.getData(CommonDataKeys.EDITOR) : null;
            new TestParseEventsSchemeDialog(project, editor).show();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled = TestParseEventsSchemeAction.isEnabled(e.getProject());
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private static boolean isEnabled(@Nullable Project project) {
        return project != null && ApplicationManager.getApplication().isInternal();
    }
}

