/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.gdpr.ConsentConfigurable;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class OpenEventLogFileAction
extends DumbAwareAction {
    private final String myRecorderId;

    public OpenEventLogFileAction(String recorderId) {
        super(StatisticsBundle.message((String)"stats.open.0.event.log", (Object[])new Object[]{recorderId}), ActionsBundle.message((String)"group.OpenEventLogFileAction.description", (Object[])new Object[0]), AllIcons.FileTypes.Text);
        this.myRecorderId = recorderId;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile logVFile;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        EventLogFile logFile = StatisticsEventLoggerKt.getEventLogProvider((String)this.myRecorderId).getActiveLogFile();
        VirtualFile virtualFile = logVFile = logFile != null ? LocalFileSystem.getInstance().findFileByIoFile(logFile.getFile()) : null;
        if (logVFile == null) {
            this.showNotification(project, NotificationType.WARNING, StatisticsBundle.message((String)"stats.there.is.no.active.event.log", (Object[])new Object[0]));
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile(logVFile, true);
    }

    protected void showNotification(@NotNull Project project, @NotNull NotificationType type, @NotNull String message) {
        String title = StatisticsBundle.message((String)"stats.feature.usage.statistics", (Object[])new Object[0]);
        Notification notification = new Notification("FeatureUsageStatistics", title, message, type);
        notification.addAction((AnAction)NotificationAction.createSimple((Supplier)StatisticsBundle.messagePointer((String)"stats.enable.data.sharing", (Object[])new Object[0]), () -> {
            SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)new ConsentConfigurable());
            editor.show();
        }));
        notification.notify(project);
    }
}

