/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.index;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.NotNull;

public class DomNamespaceKeyIndex
extends StringStubIndexExtension<PsiFile> {
    public static final StubIndexKey<String, PsiFile> KEY = StubIndexKey.createIndexKey((String)"dom.namespaceKey");
    private static final DomNamespaceKeyIndex ourInstance = new DomNamespaceKeyIndex();

    public static DomNamespaceKeyIndex getInstance() {
        return ourInstance;
    }

    public boolean hasStubElementsWithNamespaceKey(DomFileElement domFileElement, String namespaceKey) {
        VirtualFile file = domFileElement.getFile().getVirtualFile();
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        final int virtualFileId = ((VirtualFileWithId)file).getId();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        StubIndex.getInstance().processElements(KEY, (Object)namespaceKey, domFileElement.getFile().getProject(), GlobalSearchScope.fileScope((PsiFile)domFileElement.getFile()), new IdFilter(){

            public boolean containsFileId(int id) {
                return id == virtualFileId;
            }
        }, PsiFile.class, (Processor)processor);
        return processor.isFound();
    }

    @NotNull
    public StubIndexKey<String, PsiFile> getKey() {
        return KEY;
    }

    public int getVersion() {
        return 1;
    }
}

