/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.editor;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.google.api.client.util.Lists;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.icons.AppIndexingIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppIndexingVirtualFile
extends LightVirtualFile {
    private static final String FILENAME_FORMAT = "FirebaseAppIndexingTest [%s]";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss");
    private String myDeepLink;
    private List<Runnable> myContentChangingCallbacks = Lists.newArrayList();
    private FetchAsGoogleTask myFetchAsGoogleTask;

    public AppIndexingVirtualFile(@NotNull String deepLink, @NotNull FetchAsGoogleTask fetchAsGoogleTask) {
        super(String.format(FILENAME_FORMAT, DATE_FORMAT.format(fetchAsGoogleTask.getCreatedTime())));
        this.myDeepLink = deepLink;
        this.myFetchAsGoogleTask = fetchAsGoogleTask;
    }

    public void fireContentChange() {
        for (Runnable callback : this.myContentChangingCallbacks) {
            callback.run();
        }
    }

    @NotNull
    public FetchAsGoogleTask getFetchAsGoogleTask() {
        return this.myFetchAsGoogleTask;
    }

    public void addContentChangeCallback(@NotNull Runnable runnable) {
        this.myContentChangingCallbacks.add(runnable);
    }

    @NotNull
    public String getDeepLink() {
        return this.myDeepLink;
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    @NotNull
    public FileType getFileType() {
        return AppIndexingFileType.INSTANCE;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return AndroidFakeFileSystem.INSTANCE;
    }

    @NotNull
    public String getPath() {
        return this.myDeepLink;
    }

    private static class AppIndexingFileType
    extends FakeFileType {
        public static final AppIndexingFileType INSTANCE = new AppIndexingFileType();

        private AppIndexingFileType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            return file.getFileType() instanceof AppIndexingFileType;
        }

        @NotNull
        public String getName() {
            return "";
        }

        @NotNull
        public String getDescription() {
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return AppIndexingIcons.FETCH_AS_GOOGLE;
        }
    }
}

