/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.rename;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.sh.ShSupport;
import com.intellij.sh.highlighting.ShTextOccurrencesUtil;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.psi.ShFunctionDefinition;
import com.intellij.sh.rename.ShRenameAllOccurrencesHandler;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ShRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        return editor != null && ShSupport.getInstance().isRenameEnabled() && ShRenameAllOccurrencesHandler.INSTANCE.isEnabled(editor, editor.getCaretModel().getPrimaryCaret(), dataContext) && ShRenameHandler.isRenameAvailable(editor, dataContext);
    }

    private static boolean isRenameAvailable(@NotNull Editor editor, @NotNull DataContext dataContext) {
        PsiElement element;
        ShFile file = (ShFile)((Object)ObjectUtils.tryCast((Object)dataContext.getData(CommonDataKeys.PSI_FILE), ShFile.class));
        if (file == null) {
            return false;
        }
        if (editor.getCaretModel().getPrimaryCaret().hasSelection()) {
            return true;
        }
        TextRange textRange = ShTextOccurrencesUtil.findTextRangeOfIdentifierAtCaret(editor);
        return textRange == null || (element = file.findElementAt(textRange.getStartOffset())) == null || !ShTokenTypes.keywords.contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof ShFunctionDefinition) {
            PsiElementRenameHandler.invoke((PsiElement)element, (Project)project, (PsiElement)file, (Editor)editor);
        } else {
            ShRenameAllOccurrencesHandler.INSTANCE.execute(editor, editor.getCaretModel().getPrimaryCaret(), null);
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
    }
}

