/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.sh.completion.ShCompletionUtil;
import com.intellij.sh.statistics.ShFeatureUsagesCollector;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShKeywordCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final int PRIORITY = 10;
    private final String @NotNull [] myKeywords;
    @NotNull
    private final String myFeatureActionId;
    private final boolean myWithDescription;

    ShKeywordCompletionProvider(@NotNull String featureActionId, String ... keywords) {
        this(featureActionId, false, keywords);
    }

    ShKeywordCompletionProvider(@NotNull String featureActionId, boolean withDescription, String ... keywords) {
        this.myKeywords = keywords;
        this.myFeatureActionId = featureActionId;
        this.myWithDescription = withDescription;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (ShCompletionUtil.endsWithDot(parameters)) {
            return;
        }
        Project project = parameters.getOriginalFile().getProject();
        for (String keyword : this.myKeywords) {
            result.addElement(this.createKeywordLookupElement(project, keyword));
        }
    }

    @NotNull
    private LookupElement createKeywordLookupElement(@NotNull Project project, @NotNull String keyword) {
        TemplateManagerImpl templateManager = (TemplateManagerImpl)TemplateManager.getInstance((Project)project);
        Template template = TemplateSettings.getInstance().getTemplateById("shell_" + keyword);
        InsertHandler<LookupElement> insertHandler = ShKeywordCompletionProvider.createTemplateBasedInsertHandler(templateManager, template, this.myFeatureActionId);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)keyword).withTypeText(template != null && this.myWithDescription ? template.getDescription() : "").withBoldness(true).withInsertHandler(insertHandler), (double)10.0);
    }

    private static InsertHandler<LookupElement> createTemplateBasedInsertHandler(@NotNull TemplateManagerImpl templateManager, @Nullable Template template, @NotNull String featureActionId) {
        return (context, item) -> {
            Editor editor = context.getEditor();
            if (template != null) {
                editor.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
                templateManager.startTemplate(editor, template);
            } else {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
            }
            ShFeatureUsagesCollector.logFeatureUsage(featureActionId);
        };
    }
}

