/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle.legacy;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.configuration.DefaultScriptingSupportBase;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;
import org.jetbrains.kotlin.idea.scripting.gradle.UtilsKt;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/legacy/GradleLegacyScriptListener;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildRootsManager", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsManager;", "getBuildRootsManager", "()Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsManager;", "checkUpToDate", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "documentChanged", "editorActivated", "isApplicable", "", "kotlin.gradle.gradle-idea"})
public final class GradleLegacyScriptListener
extends ScriptChangeListener {
    private final GradleBuildRootsManager getBuildRootsManager() {
        return GradleBuildRootsManager.Companion.getInstance(this.getProject());
    }

    public boolean isApplicable(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return UtilsKt.isGradleKotlinScript(vFile);
    }

    public void editorActivated(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        this.checkUpToDate(vFile);
    }

    public void documentChanged(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        this.checkUpToDate(vFile);
    }

    private final void checkUpToDate(VirtualFile vFile) {
        GradleBuildRootsManager gradleBuildRootsManager = this.getBuildRootsManager();
        String string = vFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vFile.path");
        if (!gradleBuildRootsManager.isAffectedGradleProjectFile(string)) {
            return;
        }
        KtFile file = this.getAnalyzableKtFileForScript(vFile);
        if (file != null) {
            DefaultScriptingSupportBase.ensureUpToDatedConfigurationSuggested$default((DefaultScriptingSupportBase)((DefaultScriptingSupportBase)this.getDefault()), (KtFile)file, (boolean)false, (boolean)false, (int)6, null);
        }
    }

    public GradleLegacyScriptListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }
}

