/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ui.BooleanCommitOption;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairConsumer;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightCheckinHandlerState;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateCopyrightCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        return new CheckinHandler(){

            public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
                return new BooleanCommitOption(panel, CopyrightBundle.message("before.checkin.update.copyright", new Object[0]), false, () -> this.getSettings().UPDATE_COPYRIGHT, value -> {
                    this.getSettings().UPDATE_COPYRIGHT = value;
                });
            }

            public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
                if (this.getSettings().UPDATE_COPYRIGHT) {
                    new UpdateCopyrightProcessor(panel.getProject(), null, this.getPsiFiles()).run();
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                return super.beforeCheckin();
            }

            @NotNull
            private UpdateCopyrightCheckinHandlerState getSettings() {
                return UpdateCopyrightCheckinHandlerState.getInstance(panel.getProject());
            }

            private PsiFile[] getPsiFiles() {
                Collection files = panel.getVirtualFiles();
                ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                PsiManager manager = PsiManager.getInstance((Project)panel.getProject());
                for (VirtualFile file : files) {
                    PsiFile psiFile = manager.findFile(file);
                    if (psiFile == null) continue;
                    psiFiles.add(psiFile);
                }
                return PsiUtilCore.toPsiFileArray(psiFiles);
            }
        };
    }
}

