/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleSdkData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.KotlinBuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionUtil;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleFrameworksWizardStep;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;

public abstract class AbstractGradleModuleBuilder
extends AbstractExternalModuleBuilder<GradleProjectSettings> {
    private static final Logger LOG = Logger.getInstance(AbstractGradleModuleBuilder.class);
    private static final String TEMPLATE_GRADLE_SETTINGS = "Gradle Settings.gradle";
    private static final String TEMPLATE_GRADLE_SETTINGS_MERGE = "Gradle Settings merge.gradle";
    private static final String TEMPLATE_GRADLE_BUILD_WITH_WRAPPER = "Gradle Build Script with wrapper.gradle";
    private static final String DEFAULT_TEMPLATE_GRADLE_BUILD = "Gradle Build Script.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_BUILD = "Gradle Kotlin DSL Build Script.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_BUILD_WITH_WRAPPER = "Gradle Kotlin DSL Build Script with wrapper.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_SETTINGS = "Gradle Kotlin DSL Settings.gradle";
    private static final String KOTLIN_DSL_TEMPLATE_GRADLE_SETTINGS_MERGE = "Gradle Kotlin DSL Settings merge.gradle";
    private static final String TEMPLATE_ATTRIBUTE_PROJECT_NAME = "PROJECT_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_PATH = "MODULE_PATH";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_FLAT_DIR = "MODULE_FLAT_DIR";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_NAME = "MODULE_NAME";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_GROUP = "MODULE_GROUP";
    private static final String TEMPLATE_ATTRIBUTE_MODULE_VERSION = "MODULE_VERSION";
    private static final String TEMPLATE_ATTRIBUTE_GRADLE_VERSION = "GRADLE_VERSION";
    private static final com.intellij.openapi.util.Key<BuildScriptDataBuilder> BUILD_SCRIPT_DATA = com.intellij.openapi.util.Key.create((String)"gradle.module.buildScriptData");
    @Nullable
    private ProjectData myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private ProjectId myProjectId;
    private Path rootProjectPath;
    private boolean myUseKotlinDSL;
    private boolean isCreatingNewProject;
    private boolean isCreatingNewLinkedProject;

    public AbstractGradleModuleBuilder() {
        super(GradleConstants.SYSTEM_ID, (ExternalProjectSettings)new GradleProjectSettings());
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, ConfigurationException {
        LOG.assertTrue(this.getName() != null);
        String moduleFilePath = this.getModuleFilePath();
        LOG.assertTrue(moduleFilePath != null);
        AbstractGradleModuleBuilder.deleteModuleFile((String)moduleFilePath);
        String moduleTypeId = this.getModuleType().getId();
        Module module = moduleModel.newModule(moduleFilePath, moduleTypeId);
        this.setupModule(module);
        return module;
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        BuildScriptDataBuilder builder;
        String contentEntryPath = this.getContentEntryPath();
        if (StringUtil.isEmpty((String)contentEntryPath)) {
            return;
        }
        File contentRootDir = new File(contentEntryPath);
        FileUtilRt.createDirectory((File)contentRootDir);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile modelContentRootDir = fileSystem.refreshAndFindFileByIoFile(contentRootDir);
        if (modelContentRootDir == null) {
            return;
        }
        modifiableRootModel.addContentEntry(modelContentRootDir);
        Project project = modifiableRootModel.getProject();
        Module module = modifiableRootModel.getModule();
        this.rootProjectPath = this.myParentProject != null ? Paths.get(this.myParentProject.getLinkedExternalProjectPath(), new String[0]) : (this.isCreatingNewProject ? Paths.get(Objects.requireNonNull(project.getBasePath()), new String[0]) : modelContentRootDir.toNioPath());
        VirtualFile gradleBuildFile = this.setupGradleBuildFile(modelContentRootDir);
        AbstractGradleModuleBuilder.setupGradleSettingsFile(this.rootProjectPath, modelContentRootDir, project.getName(), this.myProjectId == null ? module.getName() : this.myProjectId.getArtifactId(), this.isCreatingNewProject || this.myParentProject == null, this.myUseKotlinDSL);
        if (this.myUseKotlinDSL) {
            GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)this.getExternalProjectSettings();
            GradleVersion version = gradleProjectSettings.resolveGradleVersion();
            builder = new KotlinBuildScriptDataBuilder(gradleBuildFile, version);
        } else {
            builder = new BuildScriptDataBuilder(gradleBuildFile);
        }
        modifiableRootModel.getModule().putUserData(BUILD_SCRIPT_DATA, (Object)builder);
    }

    protected void setupModule(Module module) throws ConfigurationException {
        super.setupModule(module);
        assert (this.rootProjectPath != null);
        VirtualFile buildScriptFile = AbstractGradleModuleBuilder.createAndConfigureBuildScriptFile(module);
        FileDocumentManager.getInstance().saveAllDocuments();
        ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module);
        modulePropertyManager.setExternalId(GradleConstants.SYSTEM_ID);
        modulePropertyManager.setRootProjectPath(PathKt.getSystemIndependentPath((Path)this.rootProjectPath));
        modulePropertyManager.setLinkedProjectPath(PathKt.getSystemIndependentPath((Path)this.rootProjectPath));
        Project project = module.getProject();
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        GradleProjectSettings projectSettings = (GradleProjectSettings)this.getExternalProjectSettings();
        if (this.myParentProject == null) {
            GradleProjectImportUtil.setupGradleSettings((GradleSettings)settings);
            GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Path)this.rootProjectPath);
        }
        GradleVersion gradleVersion = AbstractGradleModuleBuilder.suggestGradleVersion(project);
        if (this.isCreatingNewLinkedProject) {
            GradleJvmResolutionUtil.setupGradleJvm((Project)project, (GradleProjectSettings)projectSettings, (GradleVersion)gradleVersion);
            GradleJvmValidationUtil.validateJavaHome((Project)project, (Path)this.rootProjectPath, (GradleVersion)gradleVersion);
        }
        if (this.myParentProject == null) {
            settings.linkProject((ExternalProjectSettings)projectSettings);
        }
        if (this.isCreatingNewProject) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
            project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isCreatingNewProject) {
                this.loadPreviewProject(project);
            }
            AbstractGradleModuleBuilder.openBuildScriptFile(project, buildScriptFile);
            if (this.isCreatingNewLinkedProject) {
                this.createWrapper(project, gradleVersion, () -> this.reloadProject(project));
            } else {
                this.reloadProject(project);
            }
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private void loadPreviewProject(@NotNull Project project) {
        ImportSpecBuilder previewSpec = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
        previewSpec.usePreviewMode();
        previewSpec.use(ProgressExecutionMode.MODAL_SYNC);
        previewSpec.callback((ExternalProjectRefreshCallback)new ConfigureGradleModuleCallback(previewSpec));
        ExternalSystemUtil.refreshProject((String)PathKt.getSystemIndependentPath((Path)this.rootProjectPath), (ImportSpecBuilder)previewSpec);
    }

    private void reloadProject(@NotNull Project project) {
        ImportSpecBuilder importSpec = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
        importSpec.createDirectoriesForEmptyContentRoots();
        importSpec.callback((ExternalProjectRefreshCallback)new ConfigureGradleModuleCallback(importSpec));
        ExternalSystemUtil.refreshProject((String)PathKt.getSystemIndependentPath((Path)this.rootProjectPath), (ImportSpecBuilder)importSpec);
    }

    private void createWrapper(@NotNull Project project, @NotNull GradleVersion gradleVersion, @NotNull Runnable callback) {
        GradleExecutionUtil.ensureInstalledWrapper((Project)project, (Path)this.rootProjectPath, (GradleVersion)gradleVersion, (Runnable)callback);
    }

    @NotNull
    private static GradleVersion suggestGradleVersion(@NotNull Project project) {
        GradleVersion gradleVersion = GradleJvmResolutionUtil.suggestGradleVersion((Project)project);
        return gradleVersion == null ? GradleVersion.current() : gradleVersion;
    }

    @Nullable
    private static VirtualFile createAndConfigureBuildScriptFile(@NotNull Module module) {
        BuildScriptDataBuilder buildScriptDataBuilder = AbstractGradleModuleBuilder.getBuildScriptData(module);
        if (buildScriptDataBuilder == null) {
            return null;
        }
        try {
            VirtualFile buildScriptFile = buildScriptDataBuilder.getBuildScriptFile();
            String lineSeparator = AbstractGradleModuleBuilder.lineSeparator(buildScriptFile);
            String imports = StringUtil.convertLineSeparators((String)buildScriptDataBuilder.buildImports(), (String)lineSeparator);
            String configurationPart = StringUtil.convertLineSeparators((String)buildScriptDataBuilder.buildConfigurationPart(), (String)lineSeparator);
            String existingText = StringUtil.trimTrailing((String)VfsUtilCore.loadText((VirtualFile)buildScriptFile));
            String content = (!imports.isEmpty() ? imports + lineSeparator : "") + (!configurationPart.isEmpty() ? configurationPart + lineSeparator : "") + (!existingText.isEmpty() ? existingText + lineSeparator : "") + lineSeparator + StringUtil.convertLineSeparators((String)buildScriptDataBuilder.buildMainPart(), (String)lineSeparator);
            VfsUtil.saveText((VirtualFile)buildScriptFile, (String)content);
            return buildScriptFile;
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception on applying frameworks templates", (Throwable)e);
            return null;
        }
    }

    private static void openBuildScriptFile(@NotNull Project project, VirtualFile buildScriptFile) {
        if (buildScriptFile == null) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psiFile = psiManager.findFile(buildScriptFile);
        if (psiFile == null) {
            return;
        }
        EditorHelper.openInEditor((PsiElement)psiFile);
    }

    public abstract ModuleWizardStep[] createWizardSteps(@NotNull WizardContext var1, @NotNull ModulesProvider var2);

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        GradleFrameworksWizardStep step = new GradleFrameworksWizardStep(context, this);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk instanceof JavaSdkType && !(sdk instanceof DependentSdkType);
    }

    public String getParentGroup() {
        return "Java";
    }

    public int getWeight() {
        return 80;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    @NotNull
    private VirtualFile setupGradleBuildFile(@NotNull VirtualFile modelContentRootDir) throws ConfigurationException {
        VirtualFile file;
        String scriptName = this.myUseKotlinDSL ? "build.gradle.kts" : "build.gradle";
        try {
            file = AbstractGradleModuleBuilder.getOrCreateExternalProjectConfigFile(modelContentRootDir.toNioPath(), scriptName, true);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new ConfigurationException(e.getMessage());
        }
        String templateName = this.myUseKotlinDSL ? (((GradleProjectSettings)this.getExternalProjectSettings()).getDistributionType() == DistributionType.WRAPPED ? KOTLIN_DSL_TEMPLATE_GRADLE_BUILD_WITH_WRAPPER : KOTLIN_DSL_TEMPLATE_GRADLE_BUILD) : (((GradleProjectSettings)this.getExternalProjectSettings()).getDistributionType() == DistributionType.WRAPPED ? TEMPLATE_GRADLE_BUILD_WITH_WRAPPER : DEFAULT_TEMPLATE_GRADLE_BUILD);
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (this.myProjectId != null) {
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_VERSION, this.myProjectId.getVersion());
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_GROUP, this.myProjectId.getGroupId());
            attributes.put(TEMPLATE_ATTRIBUTE_GRADLE_VERSION, GradleVersion.current().getVersion());
        }
        AbstractGradleModuleBuilder.saveFile(file, templateName, attributes);
        return file;
    }

    @NotNull
    public static VirtualFile setupGradleSettingsFile(@NotNull Path rootProjectPath, @NotNull VirtualFile modelContentRootDir, String projectName, String moduleName, boolean renderNewFile, boolean useKotlinDSL) throws ConfigurationException {
        VirtualFile file;
        if (!renderNewFile) {
            Path settingsFile = rootProjectPath.resolve("settings.gradle");
            Path kotlinKtsSettingsFile = rootProjectPath.resolve("settings.gradle.kts");
            useKotlinDSL = !Files.exists(settingsFile, new LinkOption[0]) && (Files.exists(kotlinKtsSettingsFile, new LinkOption[0]) || useKotlinDSL);
        }
        String scriptName = useKotlinDSL ? "settings.gradle.kts" : "settings.gradle";
        try {
            file = AbstractGradleModuleBuilder.getOrCreateExternalProjectConfigFile(rootProjectPath, scriptName, renderNewFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            throw new ConfigurationException(e.getMessage());
        }
        if (renderNewFile) {
            String templateName = useKotlinDSL ? KOTLIN_DSL_TEMPLATE_GRADLE_SETTINGS : TEMPLATE_GRADLE_SETTINGS;
            String moduleDirName = VfsUtilCore.getRelativePath((VirtualFile)modelContentRootDir, (VirtualFile)file.getParent(), (char)'/');
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(TEMPLATE_ATTRIBUTE_PROJECT_NAME, projectName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, moduleDirName);
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, moduleName);
            AbstractGradleModuleBuilder.saveFile(file, templateName, attributes);
        } else {
            String flatStructureModulePath;
            String templateName = useKotlinDSL ? KOTLIN_DSL_TEMPLATE_GRADLE_SETTINGS_MERGE : TEMPLATE_GRADLE_SETTINGS_MERGE;
            char separatorChar = file.getParent() == null || !VfsUtilCore.isAncestor((VirtualFile)file.getParent(), (VirtualFile)modelContentRootDir, (boolean)true) ? (char)'/' : ':';
            String modulePath = VfsUtilCore.findRelativePath((VirtualFile)file, (VirtualFile)modelContentRootDir, (char)separatorChar);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(TEMPLATE_ATTRIBUTE_MODULE_NAME, moduleName);
            String string = flatStructureModulePath = modulePath != null && StringUtil.startsWith((CharSequence)modulePath, (CharSequence)"../") ? StringUtil.trimStart((String)modulePath, (String)"../") : null;
            if (StringUtil.equals(flatStructureModulePath, (CharSequence)modelContentRootDir.getName())) {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_FLAT_DIR, "true");
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, flatStructureModulePath);
            } else {
                attributes.put(TEMPLATE_ATTRIBUTE_MODULE_PATH, modulePath);
            }
            AbstractGradleModuleBuilder.appendToFile(file, templateName, attributes);
        }
        return file;
    }

    private static void saveFile(@NotNull VirtualFile file, @NotNull String templateName, @Nullable Map templateAttributes) throws ConfigurationException {
        FileTemplateManager manager = FileTemplateManager.getDefaultInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            AbstractGradleModuleBuilder.appendToFile(file, templateAttributes != null ? template.getText(templateAttributes) : template.getText());
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected exception on applying template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(e.getMessage(), String.format("Can't apply %s template config text", GradleConstants.SYSTEM_ID.getReadableName()));
        }
    }

    private static void appendToFile(@NotNull VirtualFile file, @NotNull String templateName, @Nullable Map templateAttributes) throws ConfigurationException {
        FileTemplateManager manager = FileTemplateManager.getDefaultInstance();
        FileTemplate template = manager.getInternalTemplate(templateName);
        try {
            AbstractGradleModuleBuilder.appendToFile(file, templateAttributes != null ? template.getText(templateAttributes) : template.getText());
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected exception on appending template %s config", GradleConstants.SYSTEM_ID.getReadableName()), (Throwable)e);
            throw new ConfigurationException(e.getMessage(), String.format("Can't append %s template config text", GradleConstants.SYSTEM_ID.getReadableName()));
        }
    }

    @NotNull
    private static VirtualFile getOrCreateExternalProjectConfigFile(@NotNull Path parent, @NotNull String fileName, boolean deleteExistingFile) throws ConfigurationException, IOException {
        Path file = parent.resolve(fileName);
        if (deleteExistingFile) {
            Files.deleteIfExists(file);
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try {
            Files.createFile(file, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        VirtualFile virtualFile = VfsUtil.findFile((Path)file, (boolean)true);
        if (virtualFile == null) {
            throw new ConfigurationException(String.format("Can't create configuration file '%s'", file));
        }
        if (virtualFile.isDirectory()) {
            throw new ConfigurationException(String.format("Configuration file is a directory '%s'", file));
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
        return virtualFile;
    }

    public void setParentProject(@Nullable ProjectData parentProject) {
        this.myParentProject = parentProject;
        this.isCreatingNewLinkedProject = this.myParentProject == null;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public void setInheritGroupId(boolean inheritGroupId) {
        this.myInheritGroupId = inheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    public void setInheritVersion(boolean inheritVersion) {
        this.myInheritVersion = inheritVersion;
    }

    public ProjectId getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(@NotNull ProjectId projectId) {
        this.myProjectId = projectId;
    }

    protected boolean isCreatingNewProject() {
        return this.isCreatingNewProject;
    }

    protected void setCreatingNewProject(boolean creatingNewProject) {
        this.isCreatingNewProject = creatingNewProject;
    }

    public void cleanup() {
        this.myJdk = null;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep instanceof ProjectSettingsStep) {
            ProjectSettingsStep projectSettingsStep = (ProjectSettingsStep)settingsStep;
            if (this.myProjectId != null) {
                ModuleNameLocationSettings nameLocationSettings = settingsStep.getModuleNameLocationSettings();
                String artifactId = this.myProjectId.getArtifactId();
                if (nameLocationSettings != null && artifactId != null) {
                    nameLocationSettings.setModuleName(artifactId);
                }
            }
            projectSettingsStep.bindModuleSettings();
        }
        return super.modifySettingsStep(settingsStep);
    }

    public static void appendToFile(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        String lineSeparator = AbstractGradleModuleBuilder.lineSeparator(file);
        String existingText = StringUtil.trimTrailing((String)VfsUtilCore.loadText((VirtualFile)file));
        String content = (StringUtil.isNotEmpty((String)existingText) ? existingText + lineSeparator : "") + StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
        VfsUtil.saveText((VirtualFile)file, (String)content);
    }

    @NotNull
    private static String lineSeparator(@NotNull VirtualFile file) {
        String lineSeparator = LoadTextUtil.detectLineSeparator((VirtualFile)file, (boolean)true);
        if (lineSeparator == null) {
            lineSeparator = CodeStyle.getDefaultSettings().getLineSeparator();
        }
        return lineSeparator;
    }

    @Nullable
    public static BuildScriptDataBuilder getBuildScriptData(@Nullable Module module) {
        return module == null ? null : (BuildScriptDataBuilder)module.getUserData(BUILD_SCRIPT_DATA);
    }

    @Nullable
    public Project createProject(String name, String path) {
        return ExternalProjectsManagerImpl.setupCreatedProject((Project)super.createProject(name, path));
    }

    public void setUseKotlinDsl(boolean useKotlinDSL) {
        this.myUseKotlinDSL = useKotlinDSL;
    }

    private class ConfigureGradleModuleCallback
    implements ExternalProjectRefreshCallback {
        @Nullable
        private final String externalConfigPath;
        @Nullable
        private final String sdkName;
        @NotNull
        private final ImportSpecBuilder.DefaultProjectRefreshCallback defaultCallback;

        ConfigureGradleModuleCallback(ImportSpecBuilder importSpecBuilder) {
            this.defaultCallback = new ImportSpecBuilder.DefaultProjectRefreshCallback(importSpecBuilder.build());
            this.sdkName = (String)ObjectUtils.doIfNotNull((Object)AbstractGradleModuleBuilder.this.myJdk, it -> it.getName());
            this.externalConfigPath = FileUtil.toCanonicalPath((String)AbstractGradleModuleBuilder.this.getContentEntryPath());
        }

        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject != null) {
                this.configureModulesSdk(externalProject);
            }
            this.defaultCallback.onSuccess(externalProject);
        }

        private void configureModulesSdk(@NotNull DataNode<ProjectData> projectNode) {
            DataNode moduleNode = ExternalSystemApiUtil.find(projectNode, (Key)ProjectKeys.MODULE, this::isTargetModule);
            if (moduleNode == null) {
                return;
            }
            this.configureModuleSdk((DataNode<? extends ModuleData>)moduleNode);
            Collection sourceSetsNodes = ExternalSystemApiUtil.getChildren((DataNode)moduleNode, (Key)GradleSourceSetData.KEY);
            for (DataNode sourceSetsNode : sourceSetsNodes) {
                this.configureModuleSdk((DataNode<? extends ModuleData>)sourceSetsNode);
            }
        }

        private void configureModuleSdk(@NotNull DataNode<? extends ModuleData> moduleNode) {
            DataNode moduleSdkNode = ExternalSystemApiUtil.find(moduleNode, (Key)ModuleSdkData.KEY);
            if (moduleSdkNode == null) {
                return;
            }
            ((ModuleSdkData)moduleSdkNode.getData()).setSdkName(this.sdkName);
        }

        private boolean isTargetModule(@NotNull DataNode<ModuleData> moduleNode) {
            ModuleData moduleData = (ModuleData)moduleNode.getData();
            String linkedExternalProjectPath = moduleData.getLinkedExternalProjectPath();
            return linkedExternalProjectPath.equals(this.externalConfigPath);
        }
    }
}

