/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.action.GradleRerunFailedTestsAction;
import org.jetbrains.plugins.gradle.execution.filters.ReRunTaskFilter;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleOutputProcessor;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<GradleTestsExecutionConsole, ProcessHandler> {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public GradleTestsExecutionConsole attachExecutionConsole(@NotNull Project project, @NotNull ExternalSystemTask task, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler) {
        TestTreeRenderer originalRenderer;
        RunConfiguration configuration;
        if (env == null) {
            return null;
        }
        SMTRunnerConsoleProperties consoleProperties = null;
        RunnerAndConfigurationSettings settings = env.getRunnerAndConfigurationSettings();
        if (settings == null) {
            RunProfile runProfile = env.getRunProfile();
            if (!(runProfile instanceof AbstractImportTestsAction.ImportRunProfile)) return null;
            consoleProperties = ((AbstractImportTestsAction.ImportRunProfile)runProfile).getProperties();
            configuration = ((AbstractImportTestsAction.ImportRunProfile)runProfile).getInitialConfiguration();
        } else {
            configuration = settings.getConfiguration();
        }
        if (!(configuration instanceof ExternalSystemRunConfiguration)) {
            return null;
        }
        ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)configuration;
        if (consoleProperties == null) {
            consoleProperties = new GradleConsoleProperties(externalSystemRunConfiguration, env.getExecutor());
        }
        String testFrameworkName = externalSystemRunConfiguration.getSettings().getExternalSystemId().getReadableName();
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName((String)testFrameworkName);
        GradleTestsExecutionConsole consoleView = new GradleTestsExecutionConsole((TestConsoleProperties)consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)testFrameworkName);
        final SMTestRunnerResultsForm resultsViewer = consoleView.getResultsViewer();
        TestTreeView testTreeView = resultsViewer.getTreeView();
        if (testTreeView != null && (originalRenderer = (TestTreeRenderer)ObjectUtils.tryCast((Object)testTreeView.getCellRenderer(), TestTreeRenderer.class)) != null) {
            originalRenderer.setAdditionalRootFormatter(new SMRootTestProxyFormatter(){

                public void format(@NotNull SMTestProxy.SMRootTestProxy testProxy, @NotNull TestTreeRenderer renderer) {
                    if (!testProxy.isInProgress() && testProxy.isEmptySuite()) {
                        renderer.clear();
                        renderer.append(GradleBundle.message((String)"gradle.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
        }
        final SMTestProxy.SMRootTestProxy testsRootNode = resultsViewer.getTestsRootNode();
        testsRootNode.setSuiteStarted();
        if (processHandler != null) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (testsRootNode.isInProgress()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (event.getExitCode() == 1) {
                                testsRootNode.setTestFailed("", null, false);
                            } else {
                                testsRootNode.setFinished();
                            }
                            resultsViewer.onBeforeTestingFinished(testsRootNode);
                            resultsViewer.onTestingFinished(testsRootNode);
                        });
                    }
                }
            });
        }
        if (!(task instanceof ExternalSystemExecuteTaskTask)) return consoleView;
        ExternalSystemExecuteTaskTask executeTask = (ExternalSystemExecuteTaskTask)task;
        if (executeTask.getArguments() == null || !StringUtil.contains((CharSequence)executeTask.getArguments(), (CharSequence)"--tests")) {
            executeTask.appendArguments("--tests *");
        }
        consoleView.addMessageFilter((Filter)new ReRunTaskFilter((ExternalSystemExecuteTaskTask)task, env));
        return consoleView;
    }

    public void onOutput(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text, @NotNull Key processOutputType) {
        GradleTestsExecutionConsoleOutputProcessor.onOutput(executionConsole, text, processOutputType);
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        if (task instanceof ExternalSystemExecuteTaskTask) {
            ExternalSystemExecuteTaskTask taskTask = (ExternalSystemExecuteTaskTask)task;
            if (!StringUtil.equals((CharSequence)taskTask.getExternalSystemId().getId(), (CharSequence)GradleConstants.SYSTEM_ID.getId())) {
                return false;
            }
            String arguments = taskTask.getArguments();
            boolean isApplicable = arguments != null && StringUtil.contains((CharSequence)arguments, (CharSequence)"--tests");
            boolean bl = isApplicable = isApplicable || ContainerUtil.find((Iterable)taskTask.getTasksToExecute(), taskToExecute -> {
                ExternalProjectInfo externalProjectInfo;
                String projectPath = taskTask.getExternalProjectPath();
                File file = new File(projectPath);
                if (file.isFile()) {
                    projectPath = StringUtil.trimEnd((String)projectPath, (String)("/" + file.getName()));
                }
                if ((externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)taskTask.getIdeProject(), (ProjectSystemId)this.getExternalSystemId(), (String)projectPath)) == null) {
                    return false;
                }
                DataNode taskDataNode = GradleProjectResolverUtil.findTask((DataNode)externalProjectInfo.getExternalProjectStructure(), (String)projectPath, (String)taskToExecute);
                return taskDataNode != null && (((TaskData)taskDataNode.getData()).isTest() || "check".equals(((TaskData)taskDataNode.getData()).getName()) && "verification".equals(((TaskData)taskDataNode.getData()).getGroup()));
            }) != null;
            if (isApplicable) {
                taskTask.putUserData(GradleConstants.RUN_TASK_AS_TEST, (Object)true);
            }
            return isApplicable;
        }
        return false;
    }

    public AnAction[] getRestartActions(@NotNull GradleTestsExecutionConsole consoleView) {
        GradleRerunFailedTestsAction rerunFailedTestsAction = new GradleRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.setModelProvider(() -> consoleView.getResultsViewer());
        return new AnAction[]{rerunFailedTestsAction};
    }
}

