/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.execution.Platform;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;

public class GradleTestsExecutionConsole
extends SMTRunnerConsoleView
implements BuildViewSettingsProvider {
    private final Map<String, SMTestProxy> testsMap = new HashMap<String, SMTestProxy>();
    private final StringBuilder myBuffer = new StringBuilder();
    private boolean lastMessageWasEmptyLine;

    public GradleTestsExecutionConsole(TestConsoleProperties consoleProperties, @Nullable String splitterProperty) {
        super(consoleProperties, splitterProperty);
    }

    public Map<String, SMTestProxy> getTestsMap() {
        return this.testsMap;
    }

    public StringBuilder getBuffer() {
        return this.myBuffer;
    }

    public void dispose() {
        this.testsMap.clear();
        super.dispose();
    }

    public SMTestLocator getUrlProvider() {
        return GradleConsoleProperties.GRADLE_TEST_LOCATOR;
    }

    public boolean isExecutionViewHidden() {
        return Registry.is((String)"build.view.side-by-side", (boolean)true);
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (this.detectUnwantedEmptyLine(s)) {
            return;
        }
        super.print(s, contentType);
    }

    private boolean detectUnwantedEmptyLine(@NotNull String s) {
        if (Platform.current().lineSeparator.equals(s)) {
            if (this.lastMessageWasEmptyLine) {
                return true;
            }
            this.lastMessageWasEmptyLine = true;
        } else {
            this.lastMessageWasEmptyLine = false;
        }
        return false;
    }
}

