/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.DeepLink;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NavigationXmlDocument;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000234B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J4\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017J,\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J:\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0007Jx\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0#2\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060'H\u0002J\u0018\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010)\u001a\u00020\u001dH\u0002J \u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0002J \u00102\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0002\u00a8\u00065"}, d2={"Lcom/android/manifmerger/NavGraphExpander;", "", "()V", "addAttribute", "", "nsUri", "", "attrName", "attrValue", "element", "Lorg/w3c/dom/Element;", "addChildElement", "childTagName", "parentElement", "addChildElementWithSingleAttribute", "expandNavGraph", "xmlElement", "Lcom/android/manifmerger/XmlElement;", "navigationXmlId", "loadedNavigationMap", "", "Lcom/android/manifmerger/NavigationXmlDocument;", "mergingReportBuilder", "Lcom/android/manifmerger/MergingReport$Builder;", "expandNavGraphs", "Lcom/android/manifmerger/XmlDocument;", "xmlDocument", "findDeepLinks", "", "Lcom/android/manifmerger/DeepLink;", "sourceFilePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "deepLinkList", "", "deepLinkUriMap", "", "visitedNavigationFiles", "", "navigationFileAncestors", "Ljava/util/TreeSet;", "getDeepLinkUriBody", "deepLink", "includeQuery", "", "getDeepLinkUris", "recordXmlAttributeAddition", "xmlAttribute", "Lcom/android/manifmerger/XmlAttribute;", "actionRecorder", "Lcom/android/manifmerger/ActionRecorder;", "recordXmlElementAddition", "ChildElementData", "NavGraphException", "android.sdktools.manifest-merger"})
public final class NavGraphExpander {
    public static final NavGraphExpander INSTANCE;

    @NotNull
    public final XmlDocument expandNavGraphs(@NotNull XmlDocument xmlDocument, @NotNull Map<String, NavigationXmlDocument> loadedNavigationMap, @NotNull MergingReport.Builder mergingReportBuilder) {
        this.expandNavGraphs(xmlDocument.getRootNode(), loadedNavigationMap, mergingReportBuilder);
        return xmlDocument.reparse();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void expandNavGraphs(XmlElement xmlElement, Map<String, NavigationXmlDocument> loadedNavigationMap, MergingReport.Builder mergingReportBuilder) {
        for (XmlElement childElement : xmlElement.getMergeableElements()) {
            this.expandNavGraphs(childElement, loadedNavigationMap, mergingReportBuilder);
        }
        if (Intrinsics.areEqual((Object)xmlElement.getXml().getTagName(), (Object)"activity") ^ true) {
            return;
        }
        ImmutableList<XmlElement> navGraphs = xmlElement.getAllNodesByType(ManifestModel.NodeTypes.NAV_GRAPH);
        if (navGraphs.isEmpty()) {
            return;
        }
        for (XmlElement navGraph : navGraphs) {
            String navigationXmlId;
            String string;
            String graphValue;
            NamedNodeMap namedNodeMap = navGraph.getXml().getAttributes();
            Object object = namedNodeMap;
            String string2 = graphValue = object != null && (object = object.getNamedItemNS("http://schemas.android.com/apk/res/android", "value")) != null ? object.getNodeValue() : null;
            if (string2 != null && StringsKt.startsWith$default((String)string2, (String)"@navigation/", (boolean)false, (int)2, null)) {
                String string3 = graphValue;
                int n = "@navigation/".length();
                boolean bl = false;
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = navigationXmlId = null;
            }
            if (navigationXmlId == null) {
                String nsUriPrefix = XmlUtils.lookupNamespacePrefix((Node)navGraph.getXml(), (String)"http://schemas.android.com/apk/res/android", (boolean)false);
                String graphName = nsUriPrefix + ':' + "value";
                mergingReportBuilder.addMessage(new SourceFilePosition(xmlElement.getDocument().getSourceFile(), xmlElement.getPosition()), MergingReport.Record.Severity.ERROR, "Missing or malformed attribute in <nav-graph> element. " + "Android manifest <nav-graph> element must contain a " + graphName + ' ' + "attribute with a value beginning " + "with \"@navigation/\".");
                return;
            }
            this.expandNavGraph(xmlElement, navigationXmlId, loadedNavigationMap, mergingReportBuilder);
        }
        UnmodifiableIterator unmodifiableIterator = navGraphs.iterator();
        while (unmodifiableIterator.hasNext()) {
            XmlElement navGraph;
            navGraph = (XmlElement)unmodifiableIterator.next();
            xmlElement.getXml().removeChild(navGraph.getXml());
            mergingReportBuilder.getActionRecorder().recordNodeAction(navGraph, Actions.ActionType.CONVERTED);
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private final void expandNavGraph(XmlElement xmlElement, String navigationXmlId, Map<String, NavigationXmlDocument> loadedNavigationMap, MergingReport.Builder mergingReportBuilder) {
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        List<DeepLink> list;
        SourceFilePosition sourceFilePosition = new SourceFilePosition(xmlElement.getDocument().getSourceFile(), xmlElement.getPosition());
        try {
            list = this.findDeepLinks(navigationXmlId, loadedNavigationMap, mergingReportBuilder, sourceFilePosition);
        }
        catch (NavGraphException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Error finding deep links.";
            }
            mergingReportBuilder.addMessage(sourceFilePosition, MergingReport.Record.Severity.ERROR, string);
            return;
        }
        List<DeepLink> deepLinks2 = list;
        ActionRecorder actionRecorder = mergingReportBuilder.getActionRecorder();
        Iterable $this$groupBy$iv = deepLinks2;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DeepLink it = (DeepLink)element$iv$iv;
            boolean bl = false;
            key$iv$iv = INSTANCE.getDeepLinkUriBody(it, false);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map deepLinkGroups = destination$iv$iv;
        for (List deepLinkGroup : deepLinkGroups.values()) {
            void $this$flatMapTo$iv$iv;
            DeepLink deepLink = (DeepLink)CollectionsKt.first((List)deepLinkGroup);
            Element intentFilterElement = this.addChildElement("intent-filter", xmlElement.getXml());
            if (deepLink.isAutoVerify()) {
                this.addAttribute("http://schemas.android.com/apk/res/android", "autoVerify", "true", intentFilterElement);
            }
            List childElementDataList = CollectionsKt.mutableListOf((Object[])new ChildElementData[]{new ChildElementData("action", "name", "android.intent.action.VIEW"), new ChildElementData("category", "name", "android.intent.category.DEFAULT"), new ChildElementData("category", "name", "android.intent.category.BROWSABLE")});
            Iterable $this$flatMap$iv = deepLinkGroup;
            boolean $i$f$flatMap = false;
            key$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DeepLink it = (DeepLink)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getSchemes();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            for (String scheme : CollectionsKt.toSet((Iterable)((List)destination$iv$iv2))) {
                childElementDataList.add(new ChildElementData("data", "scheme", scheme));
            }
            if (deepLink.getHost() != null) {
                childElementDataList.add(new ChildElementData("data", "host", deepLink.getHost()));
            }
            if (deepLink.getPort() != -1) {
                childElementDataList.add(new ChildElementData("data", "port", String.valueOf(deepLink.getPort())));
            }
            String path = deepLink.getPath();
            if (StringsKt.substringBefore$default((String)path, (String)".*", null, (int)2, null).length() == path.length() - 2) {
                childElementDataList.add(new ChildElementData("data", "pathPrefix", StringsKt.substringBefore$default((String)path, (String)".*", null, (int)2, null)));
            } else if (StringsKt.contains$default((CharSequence)path, (CharSequence)".*", (boolean)false, (int)2, null)) {
                childElementDataList.add(new ChildElementData("data", "pathPattern", path));
            } else {
                childElementDataList.add(new ChildElementData("data", "path", path));
            }
            Iterable $this$forEach$iv = childElementDataList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChildElementData it = (ChildElementData)element$iv;
                boolean bl = false;
                INSTANCE.addChildElementWithSingleAttribute(it.getTagName(), intentFilterElement, "http://schemas.android.com/apk/res/android", it.getAttrName(), it.getAttrValue());
            }
            XmlElement intentFilterXmlElement = new XmlElement(intentFilterElement, xmlElement.getDocument());
            for (DeepLink dl : deepLinkGroup) {
                this.recordXmlElementAddition(intentFilterXmlElement, dl.getSourceFilePosition(), actionRecorder);
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public final List<DeepLink> findDeepLinks(@NotNull String navigationXmlId, @NotNull Map<String, NavigationXmlDocument> loadedNavigationMap, @NotNull MergingReport.Builder mergingReportBuilder, @NotNull SourceFilePosition sourceFilePosition) throws NavGraphException {
        boolean bl = false;
        List deepLinkList = new ArrayList();
        NavGraphExpander.findDeepLinks$default(this, navigationXmlId, loadedNavigationMap, deepLinkList, mergingReportBuilder, sourceFilePosition, null, null, null, 224, null);
        return (List)ImmutableList.copyOf((Collection)deepLinkList);
    }

    private final void findDeepLinks(String navigationXmlId, Map<String, NavigationXmlDocument> loadedNavigationMap, List<DeepLink> deepLinkList, MergingReport.Builder mergingReportBuilder, SourceFilePosition sourceFilePosition, Map<String, DeepLink> deepLinkUriMap, Set<String> visitedNavigationFiles, TreeSet<String> navigationFileAncestors) throws NavGraphException {
        if (!navigationFileAncestors.add(navigationXmlId)) {
            throw (Throwable)new NavGraphException("Illegal circular reference among navigation files when traversing navigation file references: " + CollectionsKt.joinToString$default((Iterable)navigationFileAncestors, (CharSequence)" > ", null, null, (int)0, null, null, (int)62, null) + " > " + navigationXmlId + '.');
        }
        if (!visitedNavigationFiles.add(navigationXmlId)) {
            mergingReportBuilder.addMessage(sourceFilePosition, MergingReport.Record.Severity.WARNING, "The navigation file with ID \"" + navigationXmlId + "\" is included multiple times in " + "the navigation graph, but only deep links on the first instance will be " + "triggered at runtime. Consider consolidating these instances into a " + "single <include> at a higher level of your navigation graph hierarchy.");
            navigationFileAncestors.remove(navigationXmlId);
            return;
        }
        NavigationXmlDocument navigationXmlDocument = loadedNavigationMap.get(navigationXmlId);
        if (navigationXmlDocument == null) {
            throw (Throwable)new NavGraphException("Referenced navigation file with navigationXmlId = " + navigationXmlId + " not found");
        }
        for (DeepLink deepLink : navigationXmlDocument.getDeepLinks()) {
            for (String deepLinkUri : this.getDeepLinkUris(deepLink)) {
                if (deepLinkUriMap.containsKey(deepLinkUri)) {
                    throw (Throwable)new NavGraphException("Multiple destinations found with a deep link to " + deepLinkUri);
                }
                deepLinkUriMap.put(deepLinkUri, deepLink);
            }
            deepLinkList.add(deepLink);
        }
        for (String otherNavigationXmlId : navigationXmlDocument.getNavigationXmlIds()) {
            this.findDeepLinks(otherNavigationXmlId, loadedNavigationMap, deepLinkList, mergingReportBuilder, sourceFilePosition, deepLinkUriMap, visitedNavigationFiles, navigationFileAncestors);
        }
        navigationFileAncestors.remove(navigationXmlId);
    }

    static /* synthetic */ void findDeepLinks$default(NavGraphExpander navGraphExpander, String string, Map map, List list, MergingReport.Builder builder, SourceFilePosition sourceFilePosition, Map map2, Set set, TreeSet treeSet, int n, Object object) throws NavGraphException {
        boolean bl;
        if ((n & 0x20) != 0) {
            bl = false;
            map2 = new LinkedHashMap();
        }
        if ((n & 0x40) != 0) {
            bl = false;
            set = new LinkedHashSet();
        }
        if ((n & 0x80) != 0) {
            treeSet = SetsKt.sortedSetOf((Object[])new String[0]);
        }
        navGraphExpander.findDeepLinks(string, map, list, builder, sourceFilePosition, map2, set, treeSet);
    }

    private final String getDeepLinkUriBody(DeepLink deepLink, boolean includeQuery) {
        String hostString = deepLink.getHost() == null ? "//" : "//" + deepLink.getHost();
        String portString = deepLink.getPort() == -1 ? "" : ":" + deepLink.getPort();
        String queryString = deepLink.getQuery() == null || !includeQuery ? "" : '?' + deepLink.getQuery();
        return hostString + portString + deepLink.getPath() + queryString;
    }

    private final List<String> getDeepLinkUris(DeepLink deepLink) {
        ImmutableList.Builder builder = ImmutableList.builder();
        String body = this.getDeepLinkUriBody(deepLink, true);
        for (String scheme : deepLink.getSchemes()) {
            builder.add((Object)(scheme + ':' + body));
        }
        return (List)builder.build();
    }

    private final void addChildElementWithSingleAttribute(String childTagName, Element parentElement, String nsUri, String attrName, String attrValue) {
        Element childElement = this.addChildElement(childTagName, parentElement);
        this.addAttribute(nsUri, attrName, attrValue, childElement);
    }

    private final Element addChildElement(String childTagName, Element parentElement) {
        Document document = parentElement.getOwnerDocument();
        Element childElement = document.createElement(childTagName);
        Node node = parentElement.appendChild(childElement);
        if (!(node instanceof Element)) {
            node = null;
        }
        Element element = (Element)node;
        if (element == null) {
            throw (Throwable)new RuntimeException("Unable to add " + childTagName + " element to " + parentElement.getTagName() + " element.");
        }
        return element;
    }

    private final void addAttribute(String nsUri, String attrName, String attrValue, Element element) {
        String prefix = XmlUtils.lookupNamespacePrefix((Node)element, (String)nsUri, (boolean)true);
        element.setAttributeNS(nsUri, prefix + ':' + attrName, attrValue);
    }

    private final void recordXmlElementAddition(XmlElement xmlElement, SourceFilePosition sourceFilePosition, ActionRecorder actionRecorder) {
        Actions.NodeRecord nodeRecord = new Actions.NodeRecord(Actions.ActionType.ADDED, sourceFilePosition, xmlElement.getId(), null, xmlElement.getOperationType());
        actionRecorder.recordNodeAction(xmlElement, nodeRecord);
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            this.recordXmlAttributeAddition(xmlAttribute, sourceFilePosition, actionRecorder);
        }
        for (XmlElement childXmlElement : xmlElement.getMergeableElements()) {
            this.recordXmlElementAddition(childXmlElement, sourceFilePosition, actionRecorder);
        }
    }

    private final void recordXmlAttributeAddition(XmlAttribute xmlAttribute, SourceFilePosition sourceFilePosition, ActionRecorder actionRecorder) {
        Actions.AttributeRecord attributeRecord = new Actions.AttributeRecord(Actions.ActionType.ADDED, sourceFilePosition, xmlAttribute.getId(), null, null);
        actionRecorder.recordAttributeAction(xmlAttribute, attributeRecord);
    }

    private NavGraphExpander() {
    }

    static {
        NavGraphExpander navGraphExpander;
        INSTANCE = navGraphExpander = new NavGraphExpander();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/manifmerger/NavGraphExpander$ChildElementData;", "", "tagName", "", "attrName", "attrValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAttrName", "()Ljava/lang/String;", "getAttrValue", "getTagName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.manifest-merger"})
    private static final class ChildElementData {
        @NotNull
        private final String tagName;
        @NotNull
        private final String attrName;
        @NotNull
        private final String attrValue;

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        @NotNull
        public final String getAttrName() {
            return this.attrName;
        }

        @NotNull
        public final String getAttrValue() {
            return this.attrValue;
        }

        public ChildElementData(@NotNull String tagName, @NotNull String attrName, @NotNull String attrValue) {
            this.tagName = tagName;
            this.attrName = attrName;
            this.attrValue = attrValue;
        }

        @NotNull
        public final String component1() {
            return this.tagName;
        }

        @NotNull
        public final String component2() {
            return this.attrName;
        }

        @NotNull
        public final String component3() {
            return this.attrValue;
        }

        @NotNull
        public final ChildElementData copy(@NotNull String tagName, @NotNull String attrName, @NotNull String attrValue) {
            return new ChildElementData(tagName, attrName, attrValue);
        }

        public static /* synthetic */ ChildElementData copy$default(ChildElementData childElementData, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = childElementData.tagName;
            }
            if ((n & 2) != 0) {
                string2 = childElementData.attrName;
            }
            if ((n & 4) != 0) {
                string3 = childElementData.attrValue;
            }
            return childElementData.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ChildElementData(tagName=" + this.tagName + ", attrName=" + this.attrName + ", attrValue=" + this.attrValue + ")";
        }

        public int hashCode() {
            String string = this.tagName;
            String string2 = this.attrName;
            String string3 = this.attrValue;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ChildElementData)) break block3;
                    ChildElementData childElementData = (ChildElementData)object;
                    if (!Intrinsics.areEqual((Object)this.tagName, (Object)childElementData.tagName) || !Intrinsics.areEqual((Object)this.attrName, (Object)childElementData.attrName) || !Intrinsics.areEqual((Object)this.attrValue, (Object)childElementData.attrValue)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/manifmerger/NavGraphExpander$NavGraphException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "s", "", "(Ljava/lang/String;)V", "android.sdktools.manifest-merger"})
    public static final class NavGraphException
    extends RuntimeException {
        public NavGraphException(@NotNull String s) {
            super(s);
        }
    }
}

