/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public class XmlPlistReader
implements PlistReader {
    @Override
    public Plist read(@NotNull InputStream inputStream) throws IOException {
        try {
            return XmlPlistReader.internalRead(JDOMUtil.load((InputStream)inputStream));
        }
        catch (JDOMException e) {
            throw new IOException("Error while parsing plist", e);
        }
    }

    @Override
    public Plist read(@NotNull File file) throws IOException {
        try {
            return XmlPlistReader.internalRead(JDOMUtil.load((File)file));
        }
        catch (JDOMException e) {
            throw new IOException("Error while parsing plist", e);
        }
    }

    private static Plist internalRead(@NotNull Element root) throws IOException {
        if (JDOMUtil.isEmpty((Element)root)) {
            return Plist.EMPTY_PLIST;
        }
        if (!"plist".equals(root.getName())) {
            throw new IOException("Unknown xml format. Root element is '" + root.getName() + "'");
        }
        Element dictElement = root.getChild("dict");
        return dictElement != null ? (Plist)XmlPlistReader.readDict(dictElement).getValue() : Plist.EMPTY_PLIST;
    }

    private static PListValue readDict(@NotNull Element dictElement) throws IOException {
        Plist dict = new Plist();
        List children = dictElement.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            String attributeKey;
            PListValue value;
            Element keyElement = (Element)children.get(i);
            if (!"key".equals(keyElement.getName()) || (value = XmlPlistReader.readValue(attributeKey = keyElement.getValue(), (Element)children.get(++i))) == null) continue;
            dict.setEntry(attributeKey, value);
        }
        return PListValue.value(dict, PlistValueType.DICT);
    }

    @Nullable
    private static PListValue readValue(@NotNull String key, @NotNull Element valueElement) throws IOException {
        String type = valueElement.getName();
        if ("dict".equals(type)) {
            return XmlPlistReader.readDict(valueElement);
        }
        if ("array".equals(type)) {
            return XmlPlistReader.readArray(key, valueElement);
        }
        return XmlPlistReader.readBasicValue(type, valueElement);
    }

    private static PListValue readArray(String key, Element element) throws IOException {
        ArrayList<PListValue> result = new ArrayList<PListValue>();
        for (Element child : element.getChildren()) {
            PListValue val = XmlPlistReader.readValue(key, child);
            if (val == null) continue;
            result.add(val);
        }
        return PListValue.value(result, PlistValueType.ARRAY);
    }

    @Nullable
    private static PListValue readBasicValue(@NotNull String type, @NotNull Element valueElement) throws IOException {
        if ("string".equals(type)) {
            return PListValue.value(StringUtil.unescapeXmlEntities((String)valueElement.getValue()), PlistValueType.STRING);
        }
        if ("true".equals(type)) {
            return PListValue.value(Boolean.TRUE, PlistValueType.BOOLEAN);
        }
        if ("false".equals(type)) {
            return PListValue.value(Boolean.FALSE, PlistValueType.BOOLEAN);
        }
        if ("integer".equals(type)) {
            return PListValue.value(Long.parseLong(valueElement.getValue()), PlistValueType.INTEGER);
        }
        if ("real".equals(type)) {
            return PListValue.value(Double.parseDouble(valueElement.getValue()), PlistValueType.REAL);
        }
        if ("date".equals(type)) {
            try {
                return PListValue.value(Plist.dateFormatter().parse(valueElement.getValue()), PlistValueType.DATE);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return null;
    }
}

