/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public class PListValue {
    private final Object myValue;
    private final PlistValueType myType;

    PListValue(Object value, PlistValueType type) {
        this.myValue = value;
        this.myType = type;
    }

    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    public PlistValueType getType() {
        return this.myType;
    }

    @NotNull
    public Plist getPlist() {
        return this.myType == PlistValueType.DICT ? (Plist)this.myValue : Plist.EMPTY_PLIST;
    }

    @NotNull
    public List<PListValue> getArray() {
        return this.myType == PlistValueType.ARRAY ? (List)this.myValue : Collections.emptyList();
    }

    @NotNull
    public List<String> getStringArray() {
        List<PListValue> array = this.getArray();
        ArrayList<String> result = new ArrayList<String>(array.size());
        for (PListValue value : array) {
            result.add(value.getString());
        }
        return result;
    }

    public String getString() {
        return this.myType == PlistValueType.STRING ? (String)this.myValue : this.myValue.toString();
    }

    public static PListValue value(Object value, PlistValueType type) {
        if (value == null) {
            return new NullablePListValue(type);
        }
        return new PListValue(value, type);
    }

    public static PListValue string(String value) {
        return PListValue.value(value, PlistValueType.STRING);
    }

    public static PListValue bool(Boolean value) {
        return PListValue.value(value, PlistValueType.BOOLEAN);
    }

    public static PListValue integer(Long value) {
        return PListValue.value(value, PlistValueType.INTEGER);
    }

    public static PListValue real(Double value) {
        return PListValue.value(value, PlistValueType.REAL);
    }

    public static PListValue date(Date value) {
        return PListValue.value(value, PlistValueType.DATE);
    }

    public static PListValue array(List<PListValue> value) {
        return PListValue.value(value, PlistValueType.ARRAY);
    }

    public static PListValue array(PListValue ... value) {
        return PListValue.value(Arrays.asList(value), PlistValueType.ARRAY);
    }

    public static PListValue dict(Plist value) {
        return PListValue.value(value, PlistValueType.DICT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PListValue value = (PListValue)o;
        if (this.myType != value.myType) {
            return false;
        }
        return Objects.equals(this.myValue, value.myValue);
    }

    public int hashCode() {
        int result = this.myValue != null ? this.myValue.hashCode() : 0;
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public String toString() {
        return "PListValue{myValue=" + this.myValue + ", myType=" + (Object)((Object)this.myType) + '}';
    }

    private static class NullablePListValue
    extends PListValue {
        private NullablePListValue(PlistValueType type) {
            super(null, type);
        }

        @Override
        @NotNull
        public Plist getPlist() {
            return Plist.EMPTY_PLIST;
        }

        @Override
        @NotNull
        public List<PListValue> getArray() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<String> getStringArray() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public String getString() {
            return null;
        }
    }
}

