/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.Interner;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptorImpl;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRootProxyDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRuleProxyDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxScopeProxyDescriptor;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class TextMateSyntaxTable {
    private static final Logger LOG = Logger.getInstance(TextMateSyntaxTable.class);
    private final Map<CharSequence, SyntaxNodeDescriptor> rulesMap = new THashMap();
    private TObjectIntHashMap<String> ruleIds;

    public void compact() {
        this.ruleIds = null;
    }

    @NotNull
    public CharSequence loadSyntax(Plist plist, @NotNull Interner<CharSequence> interner) {
        return this.loadRealNode(plist, null, interner).getScopeName();
    }

    @NotNull
    public SyntaxNodeDescriptor getSyntax(CharSequence scopeName) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.rulesMap.get(scopeName);
        if (syntaxNodeDescriptor == null) {
            LOG.debug("Can't find syntax node for scope: '" + scopeName + "'");
            return SyntaxNodeDescriptor.EMPTY_NODE;
        }
        return syntaxNodeDescriptor;
    }

    public void clear() {
        this.rulesMap.clear();
    }

    private SyntaxNodeDescriptor loadNestedSyntax(@NotNull Plist plist, @NotNull SyntaxNodeDescriptor parentNode, @NotNull Interner<CharSequence> interner) {
        return plist.contains("include") ? this.loadProxyNode(plist, parentNode, interner) : this.loadRealNode(plist, parentNode, interner);
    }

    @NotNull
    private SyntaxNodeDescriptor loadRealNode(@NotNull Plist plist, @Nullable SyntaxNodeDescriptor parentNode, @NotNull Interner<CharSequence> interner) {
        SyntaxNodeDescriptorImpl result = new SyntaxNodeDescriptorImpl(parentNode);
        for (Map.Entry<String, PListValue> entry : plist.entries()) {
            PListValue pListValue = entry.getValue();
            if (pListValue == null) continue;
            String key = entry.getKey();
            Constants.StringKey stringKey = Constants.StringKey.fromName(key);
            if (stringKey != null) {
                String stringValue = pListValue.getString();
                if (stringValue == null) continue;
                result.setStringAttribute(stringKey, (CharSequence)interner.intern((Object)stringValue));
                continue;
            }
            Constants.CaptureKey captureKey = Constants.CaptureKey.fromName(key);
            if (captureKey != null) {
                result.setCaptures(captureKey, TextMateSyntaxTable.loadCaptures(pListValue.getPlist(), interner));
                continue;
            }
            if ("repository".equalsIgnoreCase(key)) {
                this.loadRepository(result, pListValue, interner);
                continue;
            }
            if ("patterns".equalsIgnoreCase(key)) {
                this.loadPatterns(result, pListValue, interner);
                continue;
            }
            if (!"injections".equalsIgnoreCase(key)) continue;
            this.loadInjections(result, pListValue, interner);
        }
        if (plist.contains(Constants.StringKey.SCOPE_NAME.value)) {
            CharSequence scopeName = (CharSequence)interner.intern((Object)plist.getPlistValue(Constants.StringKey.SCOPE_NAME.value, "default").getString());
            result.setScopeName(scopeName);
            this.rulesMap.put(scopeName, result);
        }
        result.compact();
        return result;
    }

    @Nullable
    private static TIntObjectHashMap<CharSequence> loadCaptures(@NotNull Plist captures, @NotNull Interner<CharSequence> interner) {
        TIntObjectHashMap result = new TIntObjectHashMap();
        for (Map.Entry<String, PListValue> capture : captures.entries()) {
            try {
                int index = Integer.parseInt(capture.getKey());
                Plist captureDict = capture.getValue().getPlist();
                String captureName = captureDict.getPlistValue("name", "").getString();
                result.put(index, interner.intern((Object)captureName));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (result.isEmpty()) {
            return null;
        }
        result.trimToSize();
        return result;
    }

    private SyntaxNodeDescriptor loadProxyNode(@NotNull Plist plist, @NotNull SyntaxNodeDescriptor result, @NotNull Interner<CharSequence> interner) {
        String include = plist.getPlistValue("include", "").getString();
        if (include.length() > 0 && include.charAt(0) == '#') {
            return new SyntaxRuleProxyDescriptor(this.getRuleId(include.substring(1)), result);
        }
        if ("$self".equalsIgnoreCase(include) || "$base".equalsIgnoreCase(include)) {
            return new SyntaxRootProxyDescriptor(result);
        }
        int i = include.indexOf(35);
        String scope = i >= 0 ? include.subSequence(0, i) : include;
        String ruleId = i >= 0 ? include.substring(i + 1) : "";
        return new SyntaxScopeProxyDescriptor((CharSequence)interner.intern((Object)scope), ruleId.isEmpty() ? -1 : this.getRuleId(ruleId), this, result);
    }

    private void loadPatterns(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        for (PListValue value : pListValue.getArray()) {
            result.addChild(this.loadNestedSyntax(value.getPlist(), result, interner));
        }
    }

    private void loadRepository(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        for (Map.Entry<String, PListValue> repoEntry : pListValue.getPlist().entries()) {
            PListValue repoEntryValue = repoEntry.getValue();
            if (repoEntryValue == null) continue;
            result.appendRepository(this.getRuleId(repoEntry.getKey()), this.loadNestedSyntax(repoEntryValue.getPlist(), result, interner));
        }
    }

    private int getRuleId(@NotNull String ruleName) {
        int id;
        if (this.ruleIds == null) {
            this.ruleIds = new TObjectIntHashMap();
        }
        if ((id = this.ruleIds.get((Object)ruleName)) > 0) {
            return id;
        }
        int newId = this.ruleIds.size() + 1;
        this.ruleIds.put((Object)ruleName, newId);
        return newId;
    }

    private void loadInjections(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        for (Map.Entry<String, PListValue> injectionEntry : pListValue.getPlist().entries()) {
            Plist injectionEntryValue = injectionEntry.getValue().getPlist();
            result.addInjection(new InjectionNodeDescriptor(injectionEntry.getKey(), this.loadRealNode(injectionEntryValue, result, interner)));
        }
    }
}

