/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexer;

public class TextMateHighlightingLexer
extends LexerBase {
    private final TextMateLexer myLexer;
    private final Queue<TextMateLexer.Token> currentLineTokens = new LinkedList<TextMateLexer.Token>();
    private CharSequence myBuffer;
    private int myEndOffset;
    private int myCurrentOffset;
    private IElementType myTokenType;
    private int myTokenStart;
    private int myTokenEnd;
    private boolean myRestartable;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public TextMateHighlightingLexer(CharSequence scopeName, SyntaxNodeDescriptor languageRootSyntaxNode) {
        this.myLexer = new TextMateLexer(new TextMateLanguageDescriptor(scopeName, languageRootSyntaxNode), Registry.get((String)"textmate.line.highlighting.limit").asInteger());
    }

    public TextMateHighlightingLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, int lineLimit) {
        this.myLexer = new TextMateLexer(languageDescriptor, lineLimit);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myCurrentOffset = startOffset;
        this.myTokenStart = startOffset;
        this.myEndOffset = endOffset;
        this.currentLineTokens.clear();
        this.myLexer.init(this.myBuffer, startOffset);
        this.advance();
    }

    public int getState() {
        return this.myRestartable ? 0 : 1;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public void advance() {
        if (this.myCurrentOffset >= this.myEndOffset) {
            this.updateState(null, this.myEndOffset);
            return;
        }
        if (this.currentLineTokens.isEmpty()) {
            this.myLexer.advanceLine(this.currentLineTokens);
        }
        this.updateState(this.currentLineTokens.poll(), this.myLexer.getCurrentOffset());
    }

    protected void updateState(@Nullable TextMateLexer.Token token, int fallbackOffset) {
        if (token != null) {
            this.myTokenType = new TextMateElementType(token.selector);
            this.myTokenStart = token.startOffset;
            this.myTokenEnd = Math.min(token.endOffset, this.myEndOffset);
            this.myCurrentOffset = token.endOffset;
            this.myRestartable = token.restartable;
        } else {
            this.myTokenType = null;
            this.myTokenStart = fallbackOffset;
            this.myTokenEnd = fallbackOffset;
            this.myCurrentOffset = fallbackOffset;
            this.myRestartable = true;
        }
    }
}

