/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;

public class TextMateHighlighter
extends SyntaxHighlighterBase {
    private static final PlainSyntaxHighlighter PLAIN_SYNTAX_HIGHLIGHTER = new PlainSyntaxHighlighter();
    @Nullable
    private final Lexer myLexer;

    public TextMateHighlighter(@Nullable Lexer lexer) {
        this.myLexer = lexer;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return this.myLexer == null ? PLAIN_SYNTAX_HIGHLIGHTER.getHighlightingLexer() : this.myLexer;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        if (!(tokenType instanceof TextMateElementType)) {
            return PLAIN_SYNTAX_HIGHLIGHTER.getTokenHighlights(tokenType);
        }
        TextMateService service = TextMateService.getInstance();
        Map<CharSequence, TextMateTextAttributesAdapter> customHighlightingColors = service.getCustomHighlightingColors();
        Set highlightingRules = ContainerUtil.union(customHighlightingColors.keySet(), TextMateTheme.INSTANCE.getRules());
        return (TextAttributesKey[])ContainerUtil.map2Array((Collection)new TextMateScopeComparator((CharSequence)tokenType.toString(), Function.identity()).sortAndFilter((Collection)highlightingRules), TextAttributesKey.class, rule -> {
            TextMateTextAttributesAdapter customTextAttributes = (TextMateTextAttributesAdapter)customHighlightingColors.get(rule);
            return customTextAttributes != null ? customTextAttributes.getTextAttributesKey(TextMateTheme.INSTANCE) : TextMateTheme.INSTANCE.getTextAttributesKey((CharSequence)rule);
        });
    }
}

