/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateLanguage;
import org.jetbrains.plugins.textmate.TextMateService;

public class TextMateFileType
extends LanguageFileType
implements PlainTextLikeFileType,
FileTypeIdentifiableByVirtualFile {
    public static final TextMateFileType INSTANCE = new TextMateFileType();

    private TextMateFileType() {
        super((Language)TextMateLanguage.LANGUAGE);
    }

    @NotNull
    public String getName() {
        return "textmate";
    }

    @NotNull
    public String getDescription() {
        return TextMateBundle.message("textmate.filetype.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        if (file.isDirectory()) {
            return false;
        }
        CharSequence fileName = file.getNameSequence();
        FileType originalFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (!TextMateFileType.isTypeShouldBeReplacedByTextMateType(originalFileType)) {
            return false;
        }
        return TextMateService.getInstance().getLanguageDescriptorByFileName(fileName) != null;
    }

    private static boolean isTypeShouldBeReplacedByTextMateType(@Nullable FileType registeredType) {
        return registeredType == UnknownFileType.INSTANCE || registeredType == INSTANCE || registeredType == PlainTextFileType.INSTANCE;
    }
}

