/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.config;

import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogFileListProvider
implements EventLogFilesProvider {
    private final List<EventLogFile> myFiles;

    public EventLogFileListProvider(@NotNull List<String> paths) {
        this.myFiles = paths.stream().map(path -> new File((String)path)).filter(file -> file.exists()).map(file -> new EventLogFile((File)file)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<EventLogFile> getLogFiles() {
        return this.myFiles;
    }

    @Override
    @Nullable
    public Path getLogFilesDir() {
        return this.myFiles.isEmpty() ? null : Paths.get(this.myFiles.get(0).getFile().getParent(), new String[0]);
    }
}

