/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.BigNodesLabelHandler;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public class BigNodesSplitter
implements ILayoutProcessor<LGraph> {
    private static final double MIN_WIDTH = 50.0;
    private LGraph layeredGraph;
    private int dummyID = 0;
    private double spacing = 0.0;
    private Direction direction = Direction.UNDEFINED;
    private static boolean debug = false;

    public void process(LGraph theLayeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Big nodes pre-processing", 1.0f);
        debug = (Boolean)theLayeredGraph.getProperty(LayeredOptions.DEBUG_MODE);
        this.layeredGraph = theLayeredGraph;
        ArrayList nodes = Lists.newArrayList();
        for (Layer l : theLayeredGraph.getLayers()) {
            nodes.addAll(l.getNodes());
        }
        int counter = 0;
        for (LNode node : nodes) {
            node.id = counter++;
        }
        this.spacing = (Double)this.layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        this.direction = (Direction)this.layeredGraph.getProperty(LayeredOptions.DIRECTION);
        this.dummyID = nodes.size();
        double minWidth = 3.4028234663852886E38;
        for (LNode node : nodes) {
            if (node.getType() != LNode.NodeType.NORMAL || !(node.getSize().x < minWidth)) continue;
            minWidth = node.getSize().x;
        }
        minWidth = Math.max(50.0, minWidth);
        ArrayList bigNodes = Lists.newArrayList();
        double threshold = minWidth + this.spacing;
        for (Object node : nodes) {
            if (node.getType() != LNode.NodeType.NORMAL || !(node.getSize().x > threshold)) continue;
            int parts = 1;
            double chunkWidth = node.getSize().x;
            while (chunkWidth > minWidth) {
                chunkWidth = (node.getSize().x - (double)(++parts - 1) * this.spacing) / (double)parts;
            }
            bigNodes.add(new BigNode((LNode)((Object)node), parts));
        }
        for (Object node : bigNodes) {
            if (!this.isProcessorApplicable((BigNode)node)) continue;
            ((BigNode)node).process();
        }
        monitor.done();
    }

    private boolean isProcessorApplicable(BigNode node) {
        LNode target;
        LNode source;
        boolean hasIncoming;
        Iterable eastwardEdges;
        Iterable westwardEdges;
        if (node.node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_RATIO || node.node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS) {
            for (LPort port : node.node.getPorts()) {
                if (port.getSide() != PortSide.NORTH && port.getSide() != PortSide.SOUTH) continue;
                return false;
            }
        }
        for (LEdge edge : node.node.getOutgoingEdges()) {
            if (!((Object)((Object)edge.getSource().getNode())).equals((Object)edge.getTarget().getNode())) continue;
            return false;
        }
        if (((PortConstraints)node.node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) {
            ArrayList tmp = Lists.newArrayList();
            for (LPort p : node.node.getPorts(PortSide.WEST)) {
                tmp.add(p.getConnectedEdges());
            }
            westwardEdges = Iterables.concat((Iterable)tmp);
            tmp = Lists.newArrayList();
            for (LPort p : node.node.getPorts(PortSide.EAST)) {
                tmp.add(p.getConnectedEdges());
            }
            eastwardEdges = Iterables.concat((Iterable)tmp);
        } else {
            westwardEdges = node.node.getIncomingEdges();
            eastwardEdges = node.node.getOutgoingEdges();
        }
        boolean hasOutgoing = !Iterables.isEmpty(node.node.getOutgoingEdges());
        boolean bl = hasIncoming = !Iterables.isEmpty(node.node.getIncomingEdges());
        if (!hasOutgoing && !hasIncoming) {
            return false;
        }
        if (!hasOutgoing) {
            node.type = BigNodeType.NO_OUTGOING;
            return true;
        }
        if (!hasIncoming) {
            node.type = BigNodeType.NO_INCOMING;
            return true;
        }
        if (Iterables.size((Iterable)westwardEdges) == 1 && (source = ((LEdge)((Object)Iterables.get((Iterable)westwardEdges, (int)0))).getSource().getNode()).getType() == LNode.NodeType.LONG_EDGE && !((Object)((Object)((LPort)((Object)source.getProperty(InternalProperties.LONG_EDGE_SOURCE))).getNode())).equals((Object)node.node)) {
            node.type = BigNodeType.INC_LONG_EDGE;
            return true;
        }
        if (Iterables.size((Iterable)eastwardEdges) == 1 && (target = ((LEdge)((Object)Iterables.get((Iterable)eastwardEdges, (int)0))).getTarget().getNode()).getType() == LNode.NodeType.LONG_EDGE && !((Object)((Object)((LPort)((Object)target.getProperty(InternalProperties.LONG_EDGE_TARGET))).getNode())).equals((Object)node.node)) {
            node.type = BigNodeType.OUT_LONG_EDGE;
            return true;
        }
        return false;
    }

    private class BigNode {
        private LNode node;
        private int chunks;
        public BigNodeType type = BigNodeType.INVALID;
        private ArrayList<LNode> dummies = Lists.newArrayList();

        public BigNode(LNode node, int chunks) {
            this.node = node;
            this.chunks = chunks;
        }

        public void process() {
            ArrayList eastPorts = Lists.newArrayList();
            for (LPort port : this.node.getPorts()) {
                if (port.getSide() != PortSide.EAST) continue;
                eastPorts.add(port);
            }
            if (BigNodesSplitter.this.direction == Direction.RIGHT && !((PortConstraints)this.node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                for (LEdge e : this.node.getOutgoingEdges()) {
                    eastPorts.add(e.getSource());
                }
            }
            this.node.setProperty(InternalProperties.BIG_NODE_ORIGINAL_SIZE, Float.valueOf((float)this.node.getSize().x));
            this.node.setProperty(InternalProperties.BIG_NODE_INITIAL, true);
            this.dummies.add(this.node);
            Pair<Integer, Double> created = null;
            if (this.type == BigNodeType.NO_OUTGOING) {
                created = this.processNoOutgoingEdge(this.node, this.node.getLayer().getIndex(), this.node.getSize().x);
            } else if (this.type == BigNodeType.NO_INCOMING) {
                created = this.processNoIncomingEdge(this.node, this.node.getLayer().getIndex(), this.node.getSize().x);
            } else if (this.type == BigNodeType.OUT_LONG_EDGE) {
                created = this.processOutLongEdge(this.node, this.node.getSize().x);
            } else if (this.type == BigNodeType.INC_LONG_EDGE) {
                created = this.processIncLongEdge(this.node, this.node.getSize().x);
            }
            if (created != null) {
                BigNodesLabelHandler.handle(this.node, this.dummies, (Double)created.getSecond());
            }
        }

        private Pair<Integer, Double> processIncLongEdge(LNode bignode, double originalWidth) {
            ArrayList chainOfNodes = Lists.newArrayList();
            chainOfNodes.add(bignode);
            LNode start = bignode;
            int replacedDummies = 0;
            do {
                if ((start = this.swapIncLongEdgeDummy(start)) != null) {
                    chainOfNodes.add(start);
                }
                ++replacedDummies;
            } while (start != null);
            double newWidth = (originalWidth - (double)(chainOfNodes.size() - 1) * BigNodesSplitter.this.spacing) / (double)chainOfNodes.size();
            for (LNode d : chainOfNodes) {
                d.getSize().x = newWidth;
            }
            return Pair.of((Object)replacedDummies, (Object)newWidth);
        }

        private LNode swapIncLongEdgeDummy(LNode start) {
            if (Iterables.size(start.getIncomingEdges()) != 1 || ((LEdge)((Object)Iterables.get(start.getIncomingEdges(), (int)0))).getSource().getNode().getType() != LNode.NodeType.LONG_EDGE) {
                return null;
            }
            LEdge incEdge = (LEdge)((Object)Iterables.get(start.getIncomingEdges(), (int)0));
            LNode longEdgeDummy = incEdge.getSource().getNode();
            longEdgeDummy.setType(LNode.NodeType.NORMAL);
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, null);
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_TARGET, null);
            longEdgeDummy.setProperty(InternalProperties.BIG_NODE_ORIGINAL_SIZE, (Float)start.getProperty(InternalProperties.BIG_NODE_ORIGINAL_SIZE));
            longEdgeDummy.setProperty(InternalProperties.BIG_NODE_INITIAL, true);
            longEdgeDummy.setProperty(InternalProperties.ORIGIN, start.getProperty(InternalProperties.ORIGIN));
            longEdgeDummy.getSize().y = start.getSize().y;
            Object origin = incEdge.getTarget().getProperty(InternalProperties.ORIGIN);
            LPort outPort = null;
            for (LPort p : longEdgeDummy.getPorts(PortSide.WEST)) {
                if (p.getIncomingEdges().isEmpty()) continue;
                p.setProperty(InternalProperties.ORIGIN, origin);
                LPort tgt = incEdge.getTarget();
                p.getSize().x = tgt.getSize().x;
                p.getSize().y = tgt.getSize().y;
                p.getAnchor().x = tgt.getAnchor().x;
                p.getAnchor().y = tgt.getAnchor().y;
                p.getLabels().addAll(tgt.getLabels());
                tgt.getLabels().clear();
                outPort = p;
                break;
            }
            incEdge.getTarget().setProperty(InternalProperties.ORIGIN, null);
            if (Iterables.size(start.getPorts(PortSide.WEST)) > 1) {
                for (LPort p : Lists.newLinkedList(start.getPorts(PortSide.WEST))) {
                    if (p.getIncomingEdges().isEmpty()) {
                        LPort newPort = new LPort();
                        newPort.setSide(PortSide.WEST);
                        newPort.getSize().x = p.getSize().x;
                        newPort.getSize().y = p.getSize().y;
                        newPort.setNode(longEdgeDummy);
                        newPort.setProperty(InternalProperties.ORIGIN, p.getProperty(InternalProperties.ORIGIN));
                        p.setNode(null);
                        continue;
                    }
                    outPort.setNode(longEdgeDummy);
                }
            }
            start.setProperty(InternalProperties.ORIGIN, null);
            start.setProperty(InternalProperties.BIG_NODE_INITIAL, false);
            start.setType(LNode.NodeType.BIG_NODE);
            longEdgeDummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, (PortConstraints)start.getProperty(LayeredOptions.PORT_CONSTRAINTS));
            longEdgeDummy.setProperty(LayeredOptions.NODE_LABELS_PLACEMENT, (EnumSet)start.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT));
            this.dummies.add(0, longEdgeDummy);
            return longEdgeDummy;
        }

        private Pair<Integer, Double> processOutLongEdge(LNode bignode, double originalWidth) {
            ArrayList chainOfNodes = Lists.newArrayList();
            chainOfNodes.add(bignode);
            LNode start = bignode;
            int replacedDummies = 0;
            do {
                if ((start = this.replaceOutLongEdgeDummy(start)) != null) {
                    chainOfNodes.add(start);
                }
                ++replacedDummies;
            } while (start != null);
            double newWidth = (originalWidth - (double)(chainOfNodes.size() - 1) * BigNodesSplitter.this.spacing) / (double)chainOfNodes.size();
            for (LNode d : chainOfNodes) {
                d.getSize().x = newWidth;
            }
            return Pair.of((Object)replacedDummies, (Object)newWidth);
        }

        private LNode replaceOutLongEdgeDummy(LNode start) {
            if (Iterables.size(start.getOutgoingEdges()) != 1 || ((LEdge)((Object)Iterables.get(start.getOutgoingEdges(), (int)0))).getTarget().getNode().getType() != LNode.NodeType.LONG_EDGE) {
                return null;
            }
            LEdge outEdge = (LEdge)((Object)Iterables.get(start.getOutgoingEdges(), (int)0));
            LNode longEdgeDummy = outEdge.getTarget().getNode();
            longEdgeDummy.setType(LNode.NodeType.BIG_NODE);
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, null);
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_TARGET, null);
            longEdgeDummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, (PortConstraints)start.getProperty(LayeredOptions.PORT_CONSTRAINTS));
            longEdgeDummy.setProperty(LayeredOptions.NODE_LABELS_PLACEMENT, (EnumSet)start.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT));
            Object origin = outEdge.getSource().getProperty(InternalProperties.ORIGIN);
            LPort outPort = null;
            for (LPort p : longEdgeDummy.getPorts(PortSide.EAST)) {
                if (p.getOutgoingEdges().isEmpty()) continue;
                p.setProperty(InternalProperties.ORIGIN, origin);
                LPort src = outEdge.getSource();
                p.getSize().x = src.getSize().x;
                p.getSize().y = src.getSize().y;
                p.getAnchor().x = src.getAnchor().x;
                p.getAnchor().y = src.getAnchor().y;
                p.getLabels().addAll(src.getLabels());
                src.getLabels().clear();
                outPort = p;
                break;
            }
            outEdge.getSource().setProperty(InternalProperties.ORIGIN, null);
            if (!Iterables.isEmpty(start.getPorts(PortSide.EAST))) {
                for (LPort p : Lists.newArrayList(start.getPorts(PortSide.EAST))) {
                    if (p.getOutgoingEdges().isEmpty()) {
                        LPort newPort = new LPort();
                        newPort.setSide(PortSide.EAST);
                        newPort.getSize().x = p.getSize().x;
                        newPort.getSize().y = p.getSize().y;
                        newPort.setNode(longEdgeDummy);
                        newPort.setProperty(InternalProperties.ORIGIN, p.getProperty(InternalProperties.ORIGIN));
                        p.setNode(null);
                        continue;
                    }
                    outPort.setNode(longEdgeDummy);
                }
            }
            longEdgeDummy.getSize().y = start.getSize().y;
            this.dummies.add(longEdgeDummy);
            return longEdgeDummy;
        }

        private Pair<Integer, Double> processNoOutgoingEdge(LNode bignode, int startLayerIndex, double originalWidth) {
            int maxLayer = BigNodesSplitter.this.layeredGraph.getLayers().size();
            if (startLayerIndex >= maxLayer - 1) {
                return null;
            }
            ArrayList chainOfNodes = Lists.newArrayList();
            chainOfNodes.add(bignode);
            LNode start = bignode;
            int currentLayer = startLayerIndex;
            int inLayerPos = -1;
            Layer currentLayerLayer = BigNodesSplitter.this.layeredGraph.getLayers().get(currentLayer);
            int i = 0;
            while (i < currentLayerLayer.getNodes().size()) {
                LNode n = currentLayerLayer.getNodes().get(i);
                if (((Object)((Object)n)).equals((Object)start)) {
                    inLayerPos = i;
                    break;
                }
                ++i;
            }
            List<Integer> inLayerPositions = this.findPossibleDummyPositions(Dir.Right, inLayerPos, currentLayer, maxLayer, this.chunks, true);
            if (inLayerPositions == null) {
                return null;
            }
            int tmpChunks = this.chunks;
            int i2 = 0;
            int createdChunks = 0;
            while (start != null && tmpChunks > 1 && currentLayer < maxLayer - 1) {
                LNode dummy = this.introduceDummyNode(start, 0.0);
                Layer dummyLayer = BigNodesSplitter.this.layeredGraph.getLayers().get(currentLayer + 1);
                int upperStrokeMax = inLayerPositions.get(i2++);
                int newInLayerPos = Math.min(upperStrokeMax, dummyLayer.getNodes().size());
                dummy.setLayer(newInLayerPos, dummyLayer);
                if (start != null) {
                    chainOfNodes.add(start);
                }
                start = dummy;
                --tmpChunks;
                ++createdChunks;
                ++currentLayer;
            }
            double newWidth = (originalWidth - (double)(chainOfNodes.size() - 1) * BigNodesSplitter.this.spacing) / (double)chainOfNodes.size();
            for (LNode d : chainOfNodes) {
                d.getSize().x = newWidth;
            }
            return Pair.of((Object)createdChunks, (Object)newWidth);
        }

        private Pair<Integer, Double> processNoIncomingEdge(LNode bignode, int startLayerIndex, double originalWidth) {
            if (startLayerIndex <= 0) {
                return null;
            }
            ArrayList chainOfNodes = Lists.newArrayList();
            chainOfNodes.add(bignode);
            LNode start = bignode;
            int currentLayer = startLayerIndex;
            int inLayerPos = -1;
            Layer currentLayerLayer = BigNodesSplitter.this.layeredGraph.getLayers().get(currentLayer);
            int i = 0;
            while (i < currentLayerLayer.getNodes().size()) {
                LNode n = currentLayerLayer.getNodes().get(i);
                if (((Object)((Object)n)).equals((Object)start)) {
                    inLayerPos = i;
                    break;
                }
                ++i;
            }
            List<Integer> inLayerPositions = this.findPossibleDummyPositions(Dir.Left, inLayerPos, currentLayer, BigNodesSplitter.this.layeredGraph.getLayers().size(), this.chunks, true);
            if (inLayerPositions == null) {
                return null;
            }
            int tmpChunks = this.chunks;
            int i2 = 0;
            int createdChunks = 0;
            int prevInLayerPosition = inLayerPos;
            while (start != null && tmpChunks > 1 && currentLayer > 1) {
                LNode dummy = this.introduceDummyNode(start, 0.0);
                currentLayerLayer = BigNodesSplitter.this.layeredGraph.getLayers().get(currentLayer);
                Layer dummyLayer = BigNodesSplitter.this.layeredGraph.getLayers().get(currentLayer - 1);
                int upperStrokeMax = inLayerPositions.get(i2++);
                int newInLayerPos = Math.min(upperStrokeMax, dummyLayer.getNodes().size());
                start.setLayer(newInLayerPos, dummyLayer);
                dummy.setLayer(prevInLayerPosition, currentLayerLayer);
                prevInLayerPosition = newInLayerPos;
                if (start != null) {
                    chainOfNodes.add(start);
                }
                start = dummy;
                --tmpChunks;
                ++createdChunks;
                --currentLayer;
            }
            double newWidth = (originalWidth - (double)(chainOfNodes.size() - 1) * BigNodesSplitter.this.spacing) / (double)chainOfNodes.size();
            for (LNode d : chainOfNodes) {
                d.getSize().x = newWidth;
            }
            return Pair.of((Object)createdChunks, (Object)newWidth);
        }

        private List<Integer> findPossibleDummyPositions(Dir dir, int inLayerPos, int layerIndex, int maxLayer, int remainingChunks, boolean initial) {
            Iterable<LEdge> connectedEdges;
            Layer currentLayer = BigNodesSplitter.this.layeredGraph.getLayers().get(layerIndex);
            HashSet upper = Sets.newHashSet();
            HashSet lower = Sets.newHashSet();
            int i = 0;
            while (i < currentLayer.getNodes().size()) {
                LNode n = currentLayer.getNodes().get(i);
                if (i < inLayerPos) {
                    upper.add(n);
                } else if (i > inLayerPos) {
                    lower.add(n);
                }
                ++i;
            }
            HashSet upperPrime = Sets.newHashSet();
            HashSet lowerPrime = Sets.newHashSet();
            for (LNode n : upper) {
                connectedEdges = dir == Dir.Right ? n.getOutgoingEdges() : n.getIncomingEdges();
                for (LEdge e : connectedEdges) {
                    if (n.getLayer().getIndex() == e.getTarget().getNode().getLayer().getIndex()) continue;
                    upperPrime.add(e.getTarget().getNode());
                }
            }
            for (LNode n : lower) {
                connectedEdges = dir == Dir.Right ? n.getOutgoingEdges() : n.getIncomingEdges();
                for (LEdge e : connectedEdges) {
                    if (n.getLayer().getIndex() == e.getTarget().getNode().getLayer().getIndex()) continue;
                    lowerPrime.add(e.getTarget().getNode());
                }
            }
            if (debug) {
                System.out.println("\n" + (Object)((Object)this.node));
                System.out.println("Dir: " + (Object)((Object)dir));
                System.out.println("Upper: " + upper);
                System.out.println("Lower: " + lower);
                System.out.println("UpperStroke: " + upperPrime);
                System.out.println("LowerStroke: " + lowerPrime);
            }
            Layer nextLayer = BigNodesSplitter.this.layeredGraph.getLayers().get(layerIndex + (dir == Dir.Right ? 1 : -1));
            int maxUprime = Integer.MIN_VALUE;
            int minLprime = Integer.MAX_VALUE;
            int i2 = 0;
            while (i2 < nextLayer.getNodes().size()) {
                LNode lNode = nextLayer.getNodes().get(i2);
                if (upperPrime.contains((Object)lNode)) {
                    maxUprime = Math.max(maxUprime, i2);
                } else if (lowerPrime.contains((Object)lNode)) {
                    minLprime = Math.min(minLprime, i2);
                }
                ++i2;
            }
            if (maxUprime < minLprime) {
                for (LNode n : upperPrime) {
                    for (LEdge e : n.getOutgoingEdges()) {
                        if (n.getLayer().getIndex() != e.getTarget().getNode().getLayer().getIndex()) continue;
                        return null;
                    }
                    for (LEdge e : n.getIncomingEdges()) {
                        if (n.getLayer().getIndex() != e.getSource().getNode().getLayer().getIndex()) continue;
                        return null;
                    }
                }
                for (LNode n : lowerPrime) {
                    for (LEdge e : n.getOutgoingEdges()) {
                        if (n.getLayer().getIndex() != e.getTarget().getNode().getLayer().getIndex()) continue;
                        return null;
                    }
                    for (LEdge e : n.getIncomingEdges()) {
                        if (n.getLayer().getIndex() != e.getSource().getNode().getLayer().getIndex()) continue;
                        return null;
                    }
                }
                int upperStrokeMax = -1;
                upperStrokeMax = upper.isEmpty() ? 0 : (lower.isEmpty() ? nextLayer.getNodes().size() : maxUprime + 1);
                for (LNode lNode : currentLayer.getNodes()) {
                    if (lNode.getType() != LNode.NodeType.NORTH_SOUTH_PORT) continue;
                    return null;
                }
                if (remainingChunks == 1) {
                    return Lists.newArrayList((Object[])new Integer[]{upperStrokeMax});
                }
                if (dir == Dir.Right && layerIndex == maxLayer - 2 || dir == Dir.Left && layerIndex == 1) {
                    return Lists.newArrayList((Object[])new Integer[]{upperStrokeMax});
                }
                List<Integer> list = this.findPossibleDummyPositions(dir, upperStrokeMax, layerIndex + (dir == Dir.Right ? 1 : -1), maxLayer, remainingChunks - 1, false);
                if (list != null && dir == Dir.Right) {
                    list.add(0, upperStrokeMax);
                }
                return list;
            }
            return null;
        }

        private LNode introduceDummyNode(LNode src, double width) {
            LNode dummy = new LNode(BigNodesSplitter.this.layeredGraph);
            dummy.setType(LNode.NodeType.BIG_NODE);
            dummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, (PortConstraints)src.getProperty(LayeredOptions.PORT_CONSTRAINTS));
            dummy.setProperty(LayeredOptions.NODE_LABELS_PLACEMENT, (EnumSet)src.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT));
            BigNodesSplitter bigNodesSplitter = BigNodesSplitter.this;
            int n = bigNodesSplitter.dummyID;
            bigNodesSplitter.dummyID = n + 1;
            dummy.id = n;
            this.dummies.add(dummy);
            dummy.getSize().y = src.getSize().y;
            dummy.getSize().x = width;
            PortSide portSide = PortSide.EAST;
            ArrayList movePorts = Lists.newArrayList(src.getPorts(portSide));
            for (LPort p : movePorts) {
                p.setNode(dummy);
            }
            LPort outPort = new LPort();
            outPort.setSide(portSide);
            outPort.setNode(src);
            outPort.getPosition().x = dummy.getSize().x;
            outPort.getPosition().y = dummy.getSize().y / 2.0;
            LPort inPort = new LPort();
            inPort.setSide(portSide.opposed());
            inPort.setNode(dummy);
            inPort.getPosition().y = dummy.getSize().y / 2.0;
            inPort.getPosition().x = -inPort.getSize().x;
            LEdge edge = new LEdge();
            edge.setSource(outPort);
            edge.setTarget(inPort);
            return dummy;
        }
    }

    private static enum BigNodeType {
        NO_INCOMING,
        NO_OUTGOING,
        INC_LONG_EDGE,
        OUT_LONG_EDGE,
        INVALID;

    }

    private static enum Dir {
        Left,
        Right;

    }
}

