/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.util.ModuleIdentifierImpl;

public class ModuleComponentIdentifierImpl
implements ModuleComponentIdentifier {
    @NotNull
    private final String group;
    @NotNull
    private final String module;
    @NotNull
    private final String version;
    @NotNull
    private final ModuleIdentifier moduleIdentifier;

    public ModuleComponentIdentifierImpl(@NotNull String group, @NotNull String module, @NotNull String version) {
        this.group = group;
        this.module = module;
        this.version = version;
        this.moduleIdentifier = new ModuleIdentifierImpl(group, module);
    }

    public String getDisplayName() {
        return this.group + ":" + this.module + ":" + this.version;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    @NotNull
    public String getModule() {
        return this.module;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleComponentIdentifier)) {
            return false;
        }
        ModuleComponentIdentifier that = (ModuleComponentIdentifier)o;
        if (!this.group.equals(that.getGroup())) {
            return false;
        }
        if (!this.module.equals(that.getModule())) {
            return false;
        }
        return this.version.equals(that.getVersion());
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.module.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

