/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.Base62;
import com.intellij.util.io.DigestUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.jetbrains.annotations.NotNull;

public final class Ksuid {
    private static final int EPOCH = 1400000000;
    private static final int TIMESTAMP_LENGTH = 4;
    private static final int PAYLOAD_LENGTH = 16;
    private static final int MAX_ENCODED_LENGTH = 27;

    @NotNull
    public static String generate() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        long utc = ZonedDateTime.now(ZoneOffset.UTC).toInstant().toEpochMilli() / 1000L;
        int timestamp = (int)(utc - 1400000000L);
        byteBuffer.putInt(timestamp);
        byte[] bytes = new byte[16];
        DigestUtil.getRandom().nextBytes(bytes);
        byteBuffer.put(bytes);
        String uid = new String(Base62.encode(byteBuffer.array()), StandardCharsets.UTF_8);
        return uid.length() > 27 ? uid.substring(0, 27) : uid;
    }
}

