/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.jetbrains.annotations.NotNull;

public class EditorConfigIntellijNameUtil {
    public static final String IDE_PREFIX = "ij_";
    static final String GENERIC_PROPERTY_PREFIX = "any_";
    static final String GENERIC_OPTION_KEY_PREFIX = "ij_any_";

    private EditorConfigIntellijNameUtil() {
    }

    @NotNull
    public static List<String> toEditorConfigNames(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        switch (IntellijPropertyKindMap.getPropertyKind(propertyName)) {
            case EDITOR_CONFIG_STANDARD: {
                return Collections.singletonList(propertyName);
            }
            case UNSUPPORTED: {
                break;
            }
            case LANGUAGE: {
                if (!(mapper instanceof LanguageCodeStylePropertyMapper)) break;
                return Collections.singletonList(EditorConfigIntellijNameUtil.getLanguageProperty(mapper, propertyName));
            }
            case COMMON: {
                ArrayList<String> names = new ArrayList<String>();
                names.add(GENERIC_OPTION_KEY_PREFIX + propertyName);
                names.add(EditorConfigIntellijNameUtil.getLanguageProperty(mapper, propertyName));
                return names;
            }
            case GENERIC: {
                return Collections.singletonList(IDE_PREFIX + propertyName);
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public static String getLanguageProperty(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        return IDE_PREFIX + mapper.getLanguageDomainId() + "_" + propertyName;
    }

    @NotNull
    public static String toIntellijName(@NotNull String editorConfigName) {
        return StringUtil.trimStart((String)StringUtil.trimStart((String)editorConfigName, (String)IDE_PREFIX), (String)GENERIC_PROPERTY_PREFIX);
    }
}

