/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.FlowLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewFile;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigPreviewFileEditor
implements FileEditor,
CodeStyleSettingsListener {
    private final Editor myEditor;
    private final EditorConfigPreviewFile myPreviewFile;

    public EditorConfigPreviewFileEditor(@NotNull Editor editor, @NotNull EditorConfigPreviewFile previewFile) {
        this.myEditor = editor;
        this.myPreviewFile = previewFile;
        if (this.myEditor instanceof EditorEx) {
            ((EditorEx)this.myEditor).setPermanentHeaderComponent(EditorConfigPreviewFileEditor.getHeaderComponent());
        }
        this.myEditor.setHeaderComponent(EditorConfigPreviewFileEditor.getHeaderComponent());
        EditorSettings editorSettings = this.myEditor.getSettings();
        editorSettings.setWhitespacesShown(true);
        editorSettings.setGutterIconsShown(false);
        editorSettings.setLineNumbersShown(false);
        this.updateEditor();
        CodeStyleSettingsManager.getInstance((Project)this.myEditor.getProject()).addListener((CodeStyleSettingsListener)this);
    }

    private static JComponent getHeaderComponent() {
        JPanel previewHeaderPanel = new JPanel();
        previewHeaderPanel.setLayout(new FlowLayout(0));
        JLabel warningLabel = new JLabel(EditorConfigBundle.message("editor.preview.not.saved.warning"));
        warningLabel.setForeground((Color)JBColor.GRAY);
        previewHeaderPanel.add(warningLabel);
        previewHeaderPanel.setBorder(IdeBorderFactory.createBorder());
        return previewHeaderPanel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myEditor.getComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "Preview";
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myEditor.getProject(), (CodeStyleSettingsListener)this);
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        this.updateEditor();
    }

    private void updateEditor() {
        PsiFile originalPsi = this.myPreviewFile.resolveOriginalPsi();
        if (originalPsi != null && !this.myEditor.isDisposed()) {
            CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)originalPsi);
            Language language = this.myPreviewFile.getLanguage();
            this.myEditor.getSettings().setRightMargin(settings.getRightMargin(language));
            this.myEditor.getSettings().setSoftMargins(settings.getSoftMargins(language));
            this.myEditor.getSettings().setTabSize(settings.getTabSize(this.myPreviewFile.getFileType()));
        }
    }
}

